/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.strategies.scheduling;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceOffer;
import org.apache.storm.scheduler.resource.strategies.scheduling.ObjectResourcesItem;

public class ObjectResourcesSummary {
    private List<ObjectResourcesItem> objectResources = new LinkedList<ObjectResourcesItem>();
    private final NormalizedResourceOffer availableResourcesOverall;
    private final NormalizedResourceOffer totalResourcesOverall;
    private String identifier;

    public ObjectResourcesSummary(String identifier) {
        this.identifier = identifier;
        this.availableResourcesOverall = new NormalizedResourceOffer();
        this.totalResourcesOverall = new NormalizedResourceOffer();
    }

    public ObjectResourcesSummary(ObjectResourcesSummary other) {
        this(null, new NormalizedResourceOffer(other.availableResourcesOverall), new NormalizedResourceOffer(other.totalResourcesOverall), other.identifier);
        ArrayList<ObjectResourcesItem> objectResourcesList = new ArrayList<ObjectResourcesItem>();
        other.objectResources.forEach(x -> objectResourcesList.add(new ObjectResourcesItem((ObjectResourcesItem)x)));
        this.objectResources = objectResourcesList;
    }

    public ObjectResourcesSummary(List<ObjectResourcesItem> objectResources, NormalizedResourceOffer availableResourcesOverall, NormalizedResourceOffer totalResourcesOverall, String identifier) {
        this.objectResources = objectResources;
        this.availableResourcesOverall = availableResourcesOverall;
        this.totalResourcesOverall = totalResourcesOverall;
        this.identifier = identifier;
    }

    public void addObjectResourcesItem(ObjectResourcesItem item) {
        this.objectResources.add(item);
        this.availableResourcesOverall.add(item.availableResources);
        this.totalResourcesOverall.add(item.totalResources);
    }

    public List<ObjectResourcesItem> getObjectResources() {
        return this.objectResources;
    }

    public NormalizedResourceOffer getAvailableResourcesOverall() {
        return this.availableResourcesOverall;
    }

    public NormalizedResourceOffer getTotalResourcesOverall() {
        return this.totalResourcesOverall;
    }
}

