/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.container;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.container.ResourceIsolationInterface;
import org.apache.storm.daemon.supervisor.ClientSupervisorUtils;
import org.apache.storm.daemon.supervisor.ExitCodeCallback;
import org.apache.storm.daemon.supervisor.SupervisorUtils;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ServerUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceIsolationManager
implements ResourceIsolationInterface {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultResourceIsolationManager.class);
    protected Map<String, Object> conf;
    protected boolean runAsUser;

    @Override
    public void prepare(Map<String, Object> conf) throws IOException {
        this.conf = conf;
        this.runAsUser = ObjectReader.getBoolean((Object)conf.get("supervisor.run.worker.as.user"), (boolean)false);
    }

    @Override
    public void reserveResourcesForWorker(String workerId, Integer workerMemory, Integer workerCpu, String numaId) {
    }

    @Override
    public void cleanup(String user, String workerId, int port) throws IOException {
    }

    @Override
    public void launchWorkerProcess(String user, String topologyId, Map<String, Object> topoConf, int port, String workerId, List<String> command, Map<String, String> env, String logPrefix, ExitCodeCallback processExitCallback, File targetDir) throws IOException {
        if (this.runAsUser) {
            String workerDir = targetDir.getAbsolutePath();
            List<String> args = Arrays.asList("worker", workerDir, ServerUtils.writeScript(workerDir, command, env));
            ClientSupervisorUtils.processLauncher(this.conf, (String)user, null, args, null, (String)logPrefix, (ExitCodeCallback)processExitCallback, (File)targetDir);
        } else {
            ClientSupervisorUtils.launchProcess(command, env, (String)logPrefix, (ExitCodeCallback)processExitCallback, (File)targetDir);
        }
    }

    @Override
    public long getMemoryUsage(String user, String workerId, int port) throws IOException {
        return 0L;
    }

    @Override
    public long getSystemFreeMemoryMb() throws IOException {
        return 0L;
    }

    @Override
    public void kill(String user, String workerId) throws IOException {
        Set<Long> pids = this.getAllPids(workerId);
        for (Long pid : pids) {
            this.kill(pid, user);
        }
    }

    private void kill(long pid, String user) throws IOException {
        if (this.runAsUser) {
            this.signal(pid, 15, user);
        } else {
            ServerUtils.killProcessWithSigTerm(String.valueOf(pid));
        }
    }

    @Override
    public void forceKill(String user, String workerId) throws IOException {
        Set<Long> pids = this.getAllPids(workerId);
        for (Long pid : pids) {
            this.forceKill(pid, user);
        }
    }

    private void forceKill(long pid, String user) throws IOException {
        if (this.runAsUser) {
            this.signal(pid, 9, user);
        } else {
            ServerUtils.forceKillProcess(String.valueOf(pid));
        }
    }

    protected Set<Long> getAllPids(String workerId) throws IOException {
        HashSet<Long> ret = new HashSet<Long>();
        for (String listing : ConfigUtils.readDirContents((String)ConfigUtils.workerPidsRoot(this.conf, (String)workerId))) {
            ret.add(Long.valueOf(listing));
        }
        return ret;
    }

    private void signal(long pid, int signal, String user) throws IOException {
        List<String> commands = Arrays.asList("signal", String.valueOf(pid), String.valueOf(signal));
        String logPrefix = "kill -" + signal + " " + pid;
        ClientSupervisorUtils.processLauncherAndWait(this.conf, (String)user, commands, null, (String)logPrefix);
    }

    @Override
    public boolean areAllProcessesDead(String user, String workerId) throws IOException {
        Set<Long> pids = this.getAllPids(workerId);
        return ServerUtils.areAllProcessesDead(this.conf, user, workerId, pids);
    }

    @Override
    public boolean runProfilingCommand(String user, String workerId, List<String> command, Map<String, String> env, String logPrefix, File targetDir) throws IOException, InterruptedException {
        if (this.runAsUser) {
            String scriptFile;
            String td = targetDir.getAbsolutePath();
            LOG.info("Running as user: {} command: {}", (Object)user, command);
            String containerFile = ServerUtils.containerFilePath(td);
            if (Utils.checkFileExists((String)containerFile)) {
                SupervisorUtils.rmrAsUser(this.conf, containerFile, containerFile);
            }
            if (Utils.checkFileExists((String)(scriptFile = ServerUtils.scriptFilePath(td)))) {
                SupervisorUtils.rmrAsUser(this.conf, scriptFile, scriptFile);
            }
            String script = ServerUtils.writeScript(td, command, env);
            List<String> args = Arrays.asList("profiler", td, script);
            int ret = ClientSupervisorUtils.processLauncherAndWait(this.conf, (String)user, args, env, (String)logPrefix);
            return ret == 0;
        }
        Process p = ClientSupervisorUtils.launchProcess(command, env, (String)logPrefix, null, (File)targetDir);
        int ret = p.waitFor();
        return ret == 0;
    }

    @Override
    public boolean isResourceManaged() {
        return false;
    }
}

