/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.common.config;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;
import redis.clients.jedis.HostAndPort;

public class JedisClusterConfig
implements Serializable {
    private Set<InetSocketAddress> nodes;
    private int timeout;
    private int maxRedirections;
    private String password;

    public JedisClusterConfig() {
    }

    public JedisClusterConfig(Set<InetSocketAddress> nodes, int timeout, int maxRedirections) {
        this(nodes, timeout, maxRedirections, null);
    }

    public JedisClusterConfig(Set<InetSocketAddress> nodes, int timeout, int maxRedirections, String password) {
        Preconditions.checkNotNull(nodes, (Object)"Node information should be presented");
        this.nodes = nodes;
        this.timeout = timeout;
        this.maxRedirections = maxRedirections;
        this.password = password;
    }

    public Set<HostAndPort> getNodes() {
        HashSet<HostAndPort> ret = new HashSet<HostAndPort>();
        for (InetSocketAddress node : this.nodes) {
            ret.add(new HostAndPort(node.getHostName(), node.getPort()));
        }
        return ret;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getMaxRedirections() {
        return this.maxRedirections;
    }

    public String getPassword() {
        return this.password;
    }

    public static class Builder {
        private Set<InetSocketAddress> nodes;
        private int timeout = 2000;
        private int maxRedirections = 5;
        private String password;

        public Builder setNodes(Set<InetSocketAddress> nodes) {
            this.nodes = nodes;
            return this;
        }

        public Builder setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder setMaxRedirections(int maxRedirections) {
            this.maxRedirections = maxRedirections;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public JedisClusterConfig build() {
            return new JedisClusterConfig(this.nodes, this.timeout, this.maxRedirections, this.password);
        }
    }
}

