/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.bolt;

import java.util.List;
import org.apache.storm.redis.bolt.AbstractRedisBolt;
import org.apache.storm.redis.common.config.JedisClusterConfig;
import org.apache.storm.redis.common.config.JedisPoolConfig;
import org.apache.storm.redis.common.container.JedisCommandsContainer;
import org.apache.storm.redis.common.mapper.RedisDataTypeDescription;
import org.apache.storm.redis.common.mapper.RedisLookupMapper;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;

public class RedisLookupBolt
extends AbstractRedisBolt {
    private final RedisLookupMapper lookupMapper;
    private final RedisDataTypeDescription.RedisDataType dataType;
    private final String additionalKey;

    public RedisLookupBolt(JedisPoolConfig config, RedisLookupMapper lookupMapper) {
        super(config);
        this.lookupMapper = lookupMapper;
        RedisDataTypeDescription dataTypeDescription = lookupMapper.getDataTypeDescription();
        this.dataType = dataTypeDescription.getDataType();
        this.additionalKey = dataTypeDescription.getAdditionalKey();
    }

    public RedisLookupBolt(JedisClusterConfig config, RedisLookupMapper lookupMapper) {
        super(config);
        this.lookupMapper = lookupMapper;
        RedisDataTypeDescription dataTypeDescription = lookupMapper.getDataTypeDescription();
        this.dataType = dataTypeDescription.getDataType();
        this.additionalKey = dataTypeDescription.getAdditionalKey();
    }

    public void process(Tuple input) {
        String key = this.lookupMapper.getKeyFromTuple((ITuple)input);
        JedisCommandsContainer jedisCommand = null;
        try {
            jedisCommand = this.getInstance();
            List<Values> values = this.lookupMapper.toTuple((ITuple)input, switch (this.dataType) {
                case RedisDataTypeDescription.RedisDataType.STRING -> jedisCommand.get(key);
                case RedisDataTypeDescription.RedisDataType.LIST -> jedisCommand.lpop(key);
                case RedisDataTypeDescription.RedisDataType.HASH -> jedisCommand.hget(this.additionalKey, key);
                case RedisDataTypeDescription.RedisDataType.SET -> jedisCommand.scard(key);
                case RedisDataTypeDescription.RedisDataType.SORTED_SET -> jedisCommand.zscore(this.additionalKey, key);
                case RedisDataTypeDescription.RedisDataType.HYPER_LOG_LOG -> jedisCommand.pfcount(key);
                case RedisDataTypeDescription.RedisDataType.GEO -> jedisCommand.geopos(this.additionalKey, key);
                default -> throw new IllegalArgumentException("Cannot process such data type: " + String.valueOf((Object)this.dataType));
            });
            for (Values value : values) {
                this.collector.emit(input, (List)value);
            }
            this.collector.ack(input);
        }
        catch (Exception e) {
            this.collector.reportError((Throwable)e);
            this.collector.fail(input);
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.lookupMapper.declareOutputFields(declarer);
    }
}

