/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.trident.state;

import java.util.List;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.storm.redis.common.mapper.RedisDataTypeDescription;
import org.apache.storm.redis.trident.state.AbstractRedisMapState;
import org.apache.storm.redis.trident.state.KeyFactory;
import org.apache.storm.redis.trident.state.Options;
import org.apache.storm.task.IMetricsContext;
import org.apache.storm.trident.state.OpaqueValue;
import org.apache.storm.trident.state.Serializer;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.state.StateFactory;
import org.apache.storm.trident.state.StateType;
import org.apache.storm.trident.state.TransactionalValue;
import org.apache.storm.trident.state.map.CachedMap;
import org.apache.storm.trident.state.map.IBackingMap;
import org.apache.storm.trident.state.map.MapState;
import org.apache.storm.trident.state.map.NonTransactionalMap;
import org.apache.storm.trident.state.map.OpaqueMap;
import org.apache.storm.trident.state.map.SnapshottableMap;
import org.apache.storm.trident.state.map.TransactionalMap;
import org.apache.storm.tuple.Values;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Pipeline;

public class RedisMapState<T>
extends AbstractRedisMapState<T> {
    private JedisPool jedisPool;
    private Options options;
    private Serializer serializer;
    private KeyFactory keyFactory;

    public RedisMapState(JedisPool jedisPool, Options options, Serializer<T> serializer, KeyFactory keyFactory) {
        this.jedisPool = jedisPool;
        this.options = options;
        this.serializer = serializer;
        this.keyFactory = keyFactory;
    }

    public static StateFactory opaque(org.apache.storm.redis.common.config.JedisPoolConfig jedisPoolConfig) {
        return RedisMapState.opaque(jedisPoolConfig, new Options<OpaqueValue>());
    }

    public static StateFactory opaque(org.apache.storm.redis.common.config.JedisPoolConfig jedisPoolConfig, RedisDataTypeDescription dataTypeDescription) {
        Options<OpaqueValue> opts = new Options<OpaqueValue>();
        opts.dataTypeDescription = dataTypeDescription;
        return RedisMapState.opaque(jedisPoolConfig, opts);
    }

    public static StateFactory opaque(org.apache.storm.redis.common.config.JedisPoolConfig jedisPoolConfig, KeyFactory factory) {
        Options<OpaqueValue> opts = new Options<OpaqueValue>();
        opts.keyFactory = factory;
        return RedisMapState.opaque(jedisPoolConfig, opts);
    }

    public static StateFactory opaque(org.apache.storm.redis.common.config.JedisPoolConfig jedisPoolConfig, Options<OpaqueValue> opts) {
        return new Factory(jedisPoolConfig, StateType.OPAQUE, opts);
    }

    public static StateFactory transactional(org.apache.storm.redis.common.config.JedisPoolConfig jedisPoolConfig) {
        return RedisMapState.transactional(jedisPoolConfig, new Options<TransactionalValue>());
    }

    public static StateFactory transactional(org.apache.storm.redis.common.config.JedisPoolConfig jedisPoolConfig, RedisDataTypeDescription dataTypeDescription) {
        Options<TransactionalValue> opts = new Options<TransactionalValue>();
        opts.dataTypeDescription = dataTypeDescription;
        return RedisMapState.transactional(jedisPoolConfig, opts);
    }

    public static StateFactory transactional(org.apache.storm.redis.common.config.JedisPoolConfig jedisPoolConfig, KeyFactory factory) {
        Options<TransactionalValue> opts = new Options<TransactionalValue>();
        opts.keyFactory = factory;
        return RedisMapState.transactional(jedisPoolConfig, opts);
    }

    public static StateFactory transactional(org.apache.storm.redis.common.config.JedisPoolConfig jedisPoolConfig, Options<TransactionalValue> opts) {
        return new Factory(jedisPoolConfig, StateType.TRANSACTIONAL, opts);
    }

    public static StateFactory nonTransactional(org.apache.storm.redis.common.config.JedisPoolConfig jedisPoolConfig) {
        return RedisMapState.nonTransactional(jedisPoolConfig, new Options<Object>());
    }

    public static StateFactory nonTransactional(org.apache.storm.redis.common.config.JedisPoolConfig jedisPoolConfig, RedisDataTypeDescription dataTypeDescription) {
        Options<Object> opts = new Options<Object>();
        opts.dataTypeDescription = dataTypeDescription;
        return RedisMapState.nonTransactional(jedisPoolConfig, opts);
    }

    public static StateFactory nonTransactional(org.apache.storm.redis.common.config.JedisPoolConfig jedisPoolConfig, KeyFactory factory) {
        Options<Object> opts = new Options<Object>();
        opts.keyFactory = factory;
        return RedisMapState.nonTransactional(jedisPoolConfig, opts);
    }

    public static StateFactory nonTransactional(org.apache.storm.redis.common.config.JedisPoolConfig jedisPoolConfig, Options<Object> opts) {
        return new Factory(jedisPoolConfig, StateType.NON_TRANSACTIONAL, opts);
    }

    @Override
    protected Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    protected KeyFactory getKeyFactory() {
        return this.keyFactory;
    }

    @Override
    protected List<String> retrieveValuesFromRedis(List<String> keys) {
        String[] stringKeys = keys.toArray(new String[keys.size()]);
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            RedisDataTypeDescription description = this.options.dataTypeDescription;
            switch (description.getDataType()) {
                case STRING: {
                    List list = jedis.mget(stringKeys);
                    return list;
                }
                case HASH: {
                    List list = jedis.hmget(description.getAdditionalKey(), stringKeys);
                    return list;
                }
            }
            throw new IllegalArgumentException("Cannot process such data type: " + String.valueOf((Object)description.getDataType()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void updateStatesToRedis(Map<String, String> keyValues) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            RedisDataTypeDescription description = this.options.dataTypeDescription;
            switch (description.getDataType()) {
                case STRING: {
                    String[] keyValue = this.buildKeyValuesList(keyValues);
                    jedis.mset(keyValue);
                    if (this.options.expireIntervalSec <= 0) return;
                    Pipeline pipe = jedis.pipelined();
                    for (int i = 0; i < keyValue.length; i += 2) {
                        pipe.expire(keyValue[i], (long)this.options.expireIntervalSec);
                    }
                    pipe.sync();
                    return;
                }
                case HASH: {
                    jedis.hmset(description.getAdditionalKey(), keyValues);
                    if (this.options.expireIntervalSec <= 0) return;
                    jedis.expire(description.getAdditionalKey(), (long)this.options.expireIntervalSec);
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Cannot process such data type: " + String.valueOf((Object)description.getDataType()));
                }
            }
        }
    }

    private String[] buildKeyValuesList(Map<String, String> keyValues) {
        String[] keyValueLists = new String[keyValues.size() * 2];
        int idx = 0;
        for (Map.Entry<String, String> kvEntry : keyValues.entrySet()) {
            keyValueLists[idx++] = kvEntry.getKey();
            keyValueLists[idx++] = kvEntry.getValue();
        }
        return keyValueLists;
    }

    protected static class Factory
    implements StateFactory {
        public static final JedisPoolConfig DEFAULT_POOL_CONFIG = new JedisPoolConfig();
        org.apache.storm.redis.common.config.JedisPoolConfig jedisPoolConfig;
        StateType type;
        Serializer serializer;
        KeyFactory keyFactory;
        Options options;

        public Factory(org.apache.storm.redis.common.config.JedisPoolConfig jedisPoolConfig, StateType type, Options options) {
            this.jedisPoolConfig = jedisPoolConfig;
            this.type = type;
            this.options = options;
            this.keyFactory = options.keyFactory;
            if (this.keyFactory == null) {
                this.keyFactory = new KeyFactory.DefaultKeyFactory();
            }
            this.serializer = options.serializer;
            if (this.serializer == null) {
                this.serializer = AbstractRedisMapState.DEFAULT_SERIALIZERS.get(type);
                if (this.serializer == null) {
                    throw new RuntimeException("Couldn't find serializer for state type: " + String.valueOf(type));
                }
            }
        }

        public State makeState(Map<String, Object> conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            MapState ms;
            JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)DEFAULT_POOL_CONFIG, this.jedisPoolConfig.getHost(), this.jedisPoolConfig.getPort(), this.jedisPoolConfig.getTimeout(), this.jedisPoolConfig.getPassword(), this.jedisPoolConfig.getDatabase());
            RedisMapState state = new RedisMapState(jedisPool, this.options, this.serializer, this.keyFactory);
            CachedMap c = new CachedMap(state, this.options.localCacheSize);
            if (this.type == StateType.NON_TRANSACTIONAL) {
                ms = NonTransactionalMap.build((IBackingMap)c);
            } else if (this.type == StateType.OPAQUE) {
                ms = OpaqueMap.build((IBackingMap)c);
            } else if (this.type == StateType.TRANSACTIONAL) {
                ms = TransactionalMap.build((IBackingMap)c);
            } else {
                throw new RuntimeException("Unknown state type: " + String.valueOf(this.type));
            }
            return new SnapshottableMap(ms, (List)new Values(new Object[]{this.options.globalKey}));
        }
    }
}

