/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.bolt;

import java.util.List;
import java.util.Objects;
import org.apache.storm.redis.bolt.AbstractRedisBolt;
import org.apache.storm.redis.common.config.JedisClusterConfig;
import org.apache.storm.redis.common.config.JedisPoolConfig;
import org.apache.storm.redis.common.container.JedisCommandsContainer;
import org.apache.storm.redis.common.mapper.RedisDataTypeDescription;
import org.apache.storm.redis.common.mapper.RedisFilterMapper;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Tuple;
import redis.clients.jedis.GeoCoordinate;

public class RedisFilterBolt
extends AbstractRedisBolt {
    private final RedisFilterMapper filterMapper;
    private final RedisDataTypeDescription.RedisDataType dataType;
    private final String additionalKey;

    public RedisFilterBolt(JedisPoolConfig config, RedisFilterMapper filterMapper) {
        super(config);
        this.filterMapper = filterMapper;
        RedisDataTypeDescription dataTypeDescription = filterMapper.getDataTypeDescription();
        this.dataType = dataTypeDescription.getDataType();
        this.additionalKey = dataTypeDescription.getAdditionalKey();
        if (this.dataType == RedisDataTypeDescription.RedisDataType.SET && this.additionalKey == null) {
            throw new IllegalArgumentException("additionalKey should be defined");
        }
    }

    public RedisFilterBolt(JedisClusterConfig config, RedisFilterMapper filterMapper) {
        super(config);
        this.filterMapper = filterMapper;
        RedisDataTypeDescription dataTypeDescription = filterMapper.getDataTypeDescription();
        this.dataType = dataTypeDescription.getDataType();
        this.additionalKey = dataTypeDescription.getAdditionalKey();
    }

    public void process(Tuple input) {
        String key = this.filterMapper.getKeyFromTuple((ITuple)input);
        JedisCommandsContainer jedisCommand = null;
        try {
            jedisCommand = this.getInstance();
            if (switch (this.dataType) {
                case RedisDataTypeDescription.RedisDataType.STRING -> jedisCommand.exists(key);
                case RedisDataTypeDescription.RedisDataType.SET -> jedisCommand.sismember(this.additionalKey, key);
                case RedisDataTypeDescription.RedisDataType.HASH -> jedisCommand.hexists(this.additionalKey, key);
                case RedisDataTypeDescription.RedisDataType.SORTED_SET -> jedisCommand.zrank(this.additionalKey, key) != null;
                case RedisDataTypeDescription.RedisDataType.HYPER_LOG_LOG -> jedisCommand.pfcount(key) > 0L;
                case RedisDataTypeDescription.RedisDataType.GEO -> {
                    List<GeoCoordinate> geopos = jedisCommand.geopos(this.additionalKey, key);
                    if (geopos == null || geopos.isEmpty()) {
                        yield false;
                    }
                    yield geopos.stream().anyMatch(Objects::nonNull);
                }
                default -> throw new IllegalArgumentException("Cannot process such data type: " + String.valueOf((Object)this.dataType));
            }) {
                this.collector.emit(input, input.getValues());
            }
            this.collector.ack(input);
        }
        catch (Exception e) {
            this.collector.reportError((Throwable)e);
            this.collector.fail(input);
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.filterMapper.declareOutputFields(declarer);
    }
}

