/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.trident.state;

import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.storm.task.IMetricsContext;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.state.StateFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisState
implements State {
    private JedisPool jedisPool;

    public RedisState(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    public void beginCommit(Long someLong) {
    }

    public void commit(Long someLong) {
    }

    public Jedis getJedis() {
        return this.jedisPool.getResource();
    }

    public void returnJedis(Jedis jedis) {
        jedis.close();
    }

    public static class Factory
    implements StateFactory {
        public static final JedisPoolConfig DEFAULT_POOL_CONFIG = new JedisPoolConfig();
        private org.apache.storm.redis.common.config.JedisPoolConfig jedisPoolConfig;

        public Factory(org.apache.storm.redis.common.config.JedisPoolConfig config) {
            this.jedisPoolConfig = config;
        }

        public State makeState(Map<String, Object> conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)DEFAULT_POOL_CONFIG, this.jedisPoolConfig.getHost(), this.jedisPoolConfig.getPort(), this.jedisPoolConfig.getTimeout(), this.jedisPoolConfig.getPassword(), this.jedisPoolConfig.getDatabase());
            return new RedisState(jedisPool);
        }
    }
}

