/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.trident.state;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.redis.common.mapper.RedisDataTypeDescription;
import org.apache.storm.redis.common.mapper.RedisStoreMapper;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.state.BaseStateUpdater;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.tuple.ITuple;

public abstract class AbstractRedisStateUpdater<T extends State>
extends BaseStateUpdater<T> {
    protected final RedisDataTypeDescription.RedisDataType dataType;
    protected final String additionalKey;
    private final RedisStoreMapper storeMapper;
    protected int expireIntervalSec = 0;

    public AbstractRedisStateUpdater(RedisStoreMapper storeMapper) {
        this.storeMapper = storeMapper;
        RedisDataTypeDescription dataTypeDescription = storeMapper.getDataTypeDescription();
        this.dataType = dataTypeDescription.getDataType();
        this.additionalKey = dataTypeDescription.getAdditionalKey();
    }

    public void setExpireInterval(int expireIntervalSec) {
        this.expireIntervalSec = expireIntervalSec > 0 ? expireIntervalSec : 0;
    }

    public void updateState(T state, List<TridentTuple> inputs, TridentCollector collector) {
        HashMap<String, String> keyToValue = new HashMap<String, String>();
        for (TridentTuple input : inputs) {
            String key = this.storeMapper.getKeyFromTuple((ITuple)input);
            String value = this.storeMapper.getValueFromTuple((ITuple)input);
            keyToValue.put(key, value);
        }
        this.updateStatesToRedis(state, keyToValue);
    }

    protected abstract void updateStatesToRedis(T var1, Map<String, String> var2);
}

