/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.trident.state;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.redis.trident.state.KeyFactory;
import org.apache.storm.trident.state.JSONNonTransactionalSerializer;
import org.apache.storm.trident.state.JSONOpaqueSerializer;
import org.apache.storm.trident.state.JSONTransactionalSerializer;
import org.apache.storm.trident.state.Serializer;
import org.apache.storm.trident.state.StateType;
import org.apache.storm.trident.state.map.IBackingMap;

public abstract class AbstractRedisMapState<T>
implements IBackingMap<T> {
    public static final EnumMap<StateType, Serializer> DEFAULT_SERIALIZERS = Maps.newEnumMap(ImmutableMap.of(StateType.NON_TRANSACTIONAL, new JSONNonTransactionalSerializer(), StateType.TRANSACTIONAL, new JSONTransactionalSerializer(), StateType.OPAQUE, new JSONOpaqueSerializer()));

    public List<T> multiGet(List<List<Object>> keys) {
        if (keys.size() == 0) {
            return Collections.emptyList();
        }
        List<String> stringKeys = this.buildKeys(keys);
        List<String> values = this.retrieveValuesFromRedis(stringKeys);
        return this.deserializeValues(keys, values);
    }

    public void multiPut(List<List<Object>> keys, List<T> vals) {
        if (keys.size() == 0) {
            return;
        }
        HashMap<String, String> keyValues = new HashMap<String, String>();
        for (int i = 0; i < keys.size(); ++i) {
            String val = new String(this.getSerializer().serialize(vals.get(i)));
            String redisKey = this.getKeyFactory().build(keys.get(i));
            keyValues.put(redisKey, val);
        }
        this.updateStatesToRedis(keyValues);
    }

    private List<String> buildKeys(List<List<Object>> keys) {
        ArrayList<String> stringKeys = new ArrayList<String>();
        for (List<Object> key : keys) {
            stringKeys.add(this.getKeyFactory().build(key));
        }
        return stringKeys;
    }

    private List<T> deserializeValues(List<List<Object>> keys, List<String> values) {
        ArrayList<Object> result = new ArrayList<Object>(keys.size());
        for (String value : values) {
            if (value != null) {
                result.add(this.getSerializer().deserialize(value.getBytes()));
                continue;
            }
            result.add(null);
        }
        return result;
    }

    protected abstract Serializer getSerializer();

    protected abstract KeyFactory getKeyFactory();

    protected abstract List<String> retrieveValuesFromRedis(List<String> var1);

    protected abstract void updateStatesToRedis(Map<String, String> var1);
}

