/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.state;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.storm.redis.common.commands.RedisCommands;
import org.apache.storm.redis.common.container.RedisCommandsInstanceContainer;
import org.apache.storm.state.BaseBinaryStateIterator;
import org.apache.storm.state.DefaultStateEncoder;
import org.apache.storm.state.Serializer;
import org.apache.storm.state.StateEncoder;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;

public class RedisKeyValueStateIterator<K, V>
extends BaseBinaryStateIterator<K, V> {
    private final byte[] namespace;
    private final StateEncoder<K, V, byte[], byte[]> encoder;
    private final RedisCommandsInstanceContainer container;
    private final ScanParams scanParams;
    private Iterator<Map.Entry<byte[], byte[]>> cachedResultIterator;
    private byte[] cursor;

    public RedisKeyValueStateIterator(byte[] namespace, RedisCommandsInstanceContainer container, Iterator<Map.Entry<byte[], byte[]>> pendingPrepareIterator, Iterator<Map.Entry<byte[], byte[]>> pendingCommitIterator, int chunkSize, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        super(pendingPrepareIterator, pendingCommitIterator);
        this.namespace = namespace;
        this.container = container;
        this.encoder = new DefaultStateEncoder(keySerializer, valueSerializer);
        this.scanParams = new ScanParams().count(chunkSize);
        this.cursor = ScanParams.SCAN_POINTER_START_BINARY;
    }

    protected Iterator<Map.Entry<byte[], byte[]>> loadChunkFromStateStorage() {
        this.loadChunkFromRedis();
        return this.cachedResultIterator;
    }

    protected boolean isEndOfDataFromStorage() {
        return (this.cachedResultIterator == null || !this.cachedResultIterator.hasNext()) && Arrays.equals(this.cursor, ScanParams.SCAN_POINTER_START_BINARY);
    }

    protected K decodeKey(byte[] key) {
        return (K)this.encoder.decodeKey((Object)key);
    }

    protected V decodeValue(byte[] value) {
        return (V)this.encoder.decodeValue((Object)value);
    }

    protected boolean isTombstoneValue(byte[] value) {
        return Arrays.equals(value, (byte[])this.encoder.getTombstoneValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadChunkFromRedis() {
        RedisCommands commands = null;
        try {
            commands = this.container.getInstance();
            ScanResult<Map.Entry<byte[], byte[]>> scanResult = commands.hscan(this.namespace, this.cursor, this.scanParams);
            List<Map.Entry<byte[], byte[]>> result = scanResult.getResult();
            if (result != null) {
                this.cachedResultIterator = result.iterator();
            }
            this.cursor = scanResult.getCursorAsBytes();
        }
        finally {
            this.container.returnInstance(commands);
        }
    }
}

