/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.common.container;

import java.io.Closeable;
import java.io.IOException;
import org.apache.storm.redis.common.adapter.RedisCommandsAdapterJedis;
import org.apache.storm.redis.common.commands.RedisCommands;
import org.apache.storm.redis.common.container.JedisContainer;
import org.apache.storm.redis.common.container.RedisCommandsInstanceContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;

public class RedisContainer
implements RedisCommandsInstanceContainer {
    private static final Logger LOG = LoggerFactory.getLogger(JedisContainer.class);
    private JedisPool jedisPool;

    public RedisContainer(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public RedisCommands getInstance() {
        return new RedisCommandsAdapterJedis(this.jedisPool.getResource());
    }

    @Override
    public void returnInstance(RedisCommands redisCommands) {
        if (redisCommands == null) {
            return;
        }
        try {
            ((Closeable)((Object)redisCommands)).close();
        }
        catch (IOException e) {
            LOG.error("Failed to close (return) instance to pool");
        }
    }

    @Override
    public void close() throws IOException {
        this.jedisPool.close();
    }
}

