/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.trident;

import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.StormSubmitter;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.redis.common.config.JedisClusterConfig;
import org.apache.storm.redis.common.mapper.RedisDataTypeDescription;
import org.apache.storm.redis.trident.PrintFunction;
import org.apache.storm.redis.trident.state.RedisClusterMapState;
import org.apache.storm.trident.Stream;
import org.apache.storm.trident.TridentState;
import org.apache.storm.trident.TridentTopology;
import org.apache.storm.trident.operation.CombinerAggregator;
import org.apache.storm.trident.operation.Function;
import org.apache.storm.trident.operation.builtin.MapGet;
import org.apache.storm.trident.operation.builtin.Sum;
import org.apache.storm.trident.spout.IBatchSpout;
import org.apache.storm.trident.state.QueryFunction;
import org.apache.storm.trident.state.StateFactory;
import org.apache.storm.trident.testing.FixedBatchSpout;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;

public class WordCountTridentRedisClusterMap {
    public static StormTopology buildTopology(String redisHostPort) {
        Fields fields = new Fields(new String[]{"word", "count"});
        FixedBatchSpout spout = new FixedBatchSpout(fields, 4, new List[]{new Values(new Object[]{"storm", 1}), new Values(new Object[]{"trident", 1}), new Values(new Object[]{"needs", 1}), new Values(new Object[]{"javadoc", 1})});
        spout.setCycle(true);
        HashSet<InetSocketAddress> nodes = new HashSet<InetSocketAddress>();
        for (String hostPort : redisHostPort.split(",")) {
            String[] hostPortSplit = hostPort.split(":");
            nodes.add(new InetSocketAddress(hostPortSplit[0], (int)Integer.valueOf(hostPortSplit[1])));
        }
        JedisClusterConfig clusterConfig = new JedisClusterConfig.Builder().setNodes(nodes).build();
        RedisDataTypeDescription dataTypeDescription = new RedisDataTypeDescription(RedisDataTypeDescription.RedisDataType.HASH, "test");
        StateFactory factory = RedisClusterMapState.transactional(clusterConfig, dataTypeDescription);
        TridentTopology topology = new TridentTopology();
        Stream stream = topology.newStream("spout1", (IBatchSpout)spout);
        TridentState state = stream.groupBy(new Fields(new String[]{"word"})).persistentAggregate(factory, new Fields(new String[]{"count"}), (CombinerAggregator)new Sum(), new Fields(new String[]{"sum"}));
        stream.stateQuery(state, new Fields(new String[]{"word"}), (QueryFunction)new MapGet(), new Fields(new String[]{"sum"})).each(new Fields(new String[]{"word", "sum"}), (Function)new PrintFunction(), new Fields(new String[0]));
        return topology.build();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: WordCountTrident 127.0.0.1:6379,127.0.0.1:6380");
            System.exit(1);
        }
        String redisHostPort = args[0];
        Config conf = new Config();
        conf.setMaxSpoutPending(5);
        conf.setNumWorkers(3);
        StormSubmitter.submitTopology((String)"test_wordCounter_for_redis", (Map)conf, (StormTopology)WordCountTridentRedisClusterMap.buildTopology(redisHostPort));
    }
}

