/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.topology;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.BasicOutputCollector;
import org.apache.storm.topology.IBasicBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;

public class WordCounter
implements IBasicBolt {
    private Map<String, Integer> wordCounter = Maps.newHashMap();

    public void prepare(Map<String, Object> topoConf, TopologyContext context) {
    }

    public void execute(Tuple input, BasicOutputCollector collector) {
        int count;
        String word = input.getStringByField("word");
        if (this.wordCounter.containsKey(word)) {
            count = this.wordCounter.get(word) + 1;
            this.wordCounter.put(word, this.wordCounter.get(word) + 1);
        } else {
            count = 1;
        }
        this.wordCounter.put(word, count);
        collector.emit((List)new Values(new Object[]{word, String.valueOf(count)}));
    }

    public void cleanup() {
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields(new String[]{"word", "count"}));
    }

    public Map<String, Object> getComponentConfiguration() {
        return null;
    }
}

