/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.topology;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.storm.Config;
import org.apache.storm.StormSubmitter;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.redis.bolt.RedisLookupBolt;
import org.apache.storm.redis.common.config.JedisPoolConfig;
import org.apache.storm.redis.common.mapper.RedisDataTypeDescription;
import org.apache.storm.redis.common.mapper.RedisLookupMapper;
import org.apache.storm.redis.topology.WordSpout;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.topology.base.BaseRichBolt;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupWordCount {
    private static final String WORD_SPOUT = "WORD_SPOUT";
    private static final String LOOKUP_BOLT = "LOOKUP_BOLT";
    private static final String PRINT_BOLT = "PRINT_BOLT";
    private static final String TEST_REDIS_HOST = "127.0.0.1";
    private static final int TEST_REDIS_PORT = 6379;

    public static void main(String[] args) throws Exception {
        String host = TEST_REDIS_HOST;
        int port = 6379;
        if (args.length >= 2) {
            host = args[0];
            port = Integer.parseInt(args[1]);
        }
        JedisPoolConfig poolConfig = new JedisPoolConfig.Builder().setHost(host).setPort(port).build();
        WordSpout spout = new WordSpout();
        RedisLookupMapper lookupMapper = LookupWordCount.setupLookupMapper();
        RedisLookupBolt lookupBolt = new RedisLookupBolt(poolConfig, lookupMapper);
        PrintWordTotalCountBolt printBolt = new PrintWordTotalCountBolt();
        TopologyBuilder builder = new TopologyBuilder();
        builder.setSpout(WORD_SPOUT, (IRichSpout)spout, (Number)1);
        builder.setBolt(LOOKUP_BOLT, (IRichBolt)lookupBolt, (Number)1).shuffleGrouping(WORD_SPOUT);
        builder.setBolt(PRINT_BOLT, (IRichBolt)printBolt, (Number)1).shuffleGrouping(LOOKUP_BOLT);
        String topoName = "test";
        if (args.length == 3) {
            topoName = args[2];
        } else if (args.length > 3) {
            System.out.println("Usage: LookupWordCount <redis host> <redis port> (topology name)");
            return;
        }
        Config config = new Config();
        StormSubmitter.submitTopology((String)topoName, (Map)config, (StormTopology)builder.createTopology());
    }

    private static RedisLookupMapper setupLookupMapper() {
        return new WordCountRedisLookupMapper();
    }

    public static class PrintWordTotalCountBolt
    extends BaseRichBolt {
        private static final Logger LOG = LoggerFactory.getLogger(PrintWordTotalCountBolt.class);
        private static final Random RANDOM = new Random();
        private OutputCollector collector;

        public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
            this.collector = collector;
        }

        public void execute(Tuple input) {
            String wordName = input.getStringByField("wordName");
            String countStr = input.getStringByField("count");
            if (RANDOM.nextInt(1000) > 995) {
                int count = 0;
                if (countStr != null) {
                    count = Integer.parseInt(countStr);
                }
                LOG.info("Lookup result - word : " + wordName + " / count : " + count);
            }
            this.collector.ack(input);
        }

        public void declareOutputFields(OutputFieldsDeclarer declarer) {
        }
    }

    private static class WordCountRedisLookupMapper
    implements RedisLookupMapper {
        private RedisDataTypeDescription description = new RedisDataTypeDescription(RedisDataTypeDescription.RedisDataType.HASH, "wordCount");
        private final String hashKey = "wordCount";

        WordCountRedisLookupMapper() {
        }

        @Override
        public List<Values> toTuple(ITuple input, Object value) {
            String member = this.getKeyFromTuple(input);
            ArrayList<Values> values = Lists.newArrayList();
            values.add(new Values(new Object[]{member, value}));
            return values;
        }

        @Override
        public void declareOutputFields(OutputFieldsDeclarer declarer) {
            declarer.declare(new Fields(new String[]{"wordName", "count"}));
        }

        @Override
        public RedisDataTypeDescription getDataTypeDescription() {
            return this.description;
        }

        @Override
        public String getKeyFromTuple(ITuple tuple) {
            return tuple.getStringByField("word");
        }

        @Override
        public String getValueFromTuple(ITuple tuple) {
            return null;
        }
    }
}

