/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics.prometheus;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import io.prometheus.metrics.core.metrics.Gauge;
import io.prometheus.metrics.core.metrics.Histogram;
import io.prometheus.metrics.exporter.pushgateway.PushGateway;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusReporterClient
extends ScheduledReporter {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusReporterClient.class);
    private static final Map<String, Object> CLUSTER_SUMMARY_METRICS = new HashMap<String, Object>();
    private static final TimeUnit DURATION_UNIT = TimeUnit.MILLISECONDS;
    private static final TimeUnit RATE_UNIT = TimeUnit.SECONDS;
    private final PushGateway prometheus;

    protected PrometheusReporterClient(MetricRegistry registry, PushGateway prometheus) {
        super(registry, "prometheus-reporter", MetricFilter.ALL, RATE_UNIT, DURATION_UNIT, null, true, Collections.emptySet());
        this.prometheus = prometheus;
    }

    public void report(SortedMap<String, com.codahale.metrics.Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        try {
            if (CLUSTER_SUMMARY_METRICS.isEmpty()) {
                PrometheusReporterClient.initClusterMetrics();
            }
            for (Map.Entry<String, com.codahale.metrics.Gauge> entry : gauges.entrySet()) {
                Gauge pGauge = (Gauge)CLUSTER_SUMMARY_METRICS.get(entry.getKey());
                if (pGauge == null) continue;
                try {
                    pGauge.set(this.toDouble(entry.getValue().getValue()));
                }
                catch (NumberFormatException ignored) {
                    LOG.warn("Invalid type for Gauge {}: {}", (Object)entry.getKey(), (Object)entry.getValue().getClass().getName());
                }
            }
            for (Map.Entry<String, com.codahale.metrics.Gauge> entry : histograms.entrySet()) {
                io.prometheus.metrics.core.metrics.Histogram pHisto = (io.prometheus.metrics.core.metrics.Histogram)CLUSTER_SUMMARY_METRICS.get(entry.getKey());
                if (pHisto == null) continue;
                Snapshot s = ((Histogram)entry.getValue()).getSnapshot();
                long[] lArray = s.getValues();
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    double d = lArray[i];
                    pHisto.observe(d);
                }
            }
            this.prometheus.push();
        }
        catch (IOException e) {
            LOG.warn("Failed to push metrics to configured Prometheus Pushgateway,", (Throwable)e);
        }
    }

    private double toDouble(Object obj) {
        double value = obj instanceof Number ? ((Number)obj).doubleValue() : (obj instanceof Boolean ? ((Boolean)obj != false ? 1.0 : 0.0) : Double.parseDouble(obj.toString()));
        return value;
    }

    private static void initClusterMetrics() {
        CLUSTER_SUMMARY_METRICS.put("summary.cluster:num-nimbus-leaders", ((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("summary_cluster_num_nimbus_leaders")).help("Number of nimbuses marked as a leader. This should really only ever be 1 in a healthy cluster, or 0 for a short period of time while a fail over happens.")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.cluster:num-nimbuses", ((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("summary_cluster_num_nimbuses")).help("Number of nimbuses, leader or standby.")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.cluster:num-supervisors", ((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("summary_cluster_num_supervisors")).help("Number of supervisors.")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.cluster:num-topologies", ((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("summary_cluster_num_topologies")).help("Number of topologies.")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.cluster:num-total-used-workers", ((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("summary_cluster_num_total_used_workers")).help("Number of used workers/slots.")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.cluster:num-total-workers", ((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("summary_cluster_num_total_workers")).help("Number of workers/slots.")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.cluster:total-fragmented-cpu-non-negative", ((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("summary_cluster_total_fragmented_cpu_non_negative")).help("Total fragmented CPU (% of core). This is CPU that the system thinks it cannot use because other resources on the node are used up.")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.cluster:total-fragmented-memory-non-negative", ((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("summary_cluster_total_fragmented_memory_non_negative")).help("Total fragmented memory (MB). This is memory that the system thinks it cannot use because other resources on the node are used up.")).register());
        CLUSTER_SUMMARY_METRICS.put("nimbus:available-cpu-non-negative", ((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("nimbus_available_cpu_non_negative")).help("Available cpu on the cluster (% of a core).")).register());
        CLUSTER_SUMMARY_METRICS.put("nimbus:total-cpu", ((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("nimbus_total_cpu")).help("total CPU on the cluster (% of a core)")).register());
        CLUSTER_SUMMARY_METRICS.put("nimbus:total-memory", ((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("nimbus_total_memory")).help("total memory on the cluster MB")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.topologies:assigned-cpu", ((Histogram.Builder)((Histogram.Builder)io.prometheus.metrics.core.metrics.Histogram.builder().name("summary_topologies_assigned_cpu")).help("CPU scheduled per topology (% of a core)")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.topologies:assigned-mem-off-heap", ((Histogram.Builder)((Histogram.Builder)io.prometheus.metrics.core.metrics.Histogram.builder().name("summary_topologies_assigned_mem_off_heap")).help("Off heap memory scheduled per topology (MB)")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.topologies:assigned-mem-on-heap", ((Histogram.Builder)((Histogram.Builder)io.prometheus.metrics.core.metrics.Histogram.builder().name("summary_topologies_assigned_mem_on_heap")).help("On heap memory scheduled per topology (MB)")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.topologies:num-executors", ((Histogram.Builder)((Histogram.Builder)io.prometheus.metrics.core.metrics.Histogram.builder().name("summary_topologies_num_executors")).help("Number of executors per topology")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.topologies:num-tasks", ((Histogram.Builder)((Histogram.Builder)io.prometheus.metrics.core.metrics.Histogram.builder().name("summary_topologies_num_tasks")).help("Number of tasks per topology")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.topologies:num-workers", ((Histogram.Builder)((Histogram.Builder)io.prometheus.metrics.core.metrics.Histogram.builder().name("summary_topologies_num_workers")).help("Number of workers per topology")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.topologies:replication-count", ((Histogram.Builder)((Histogram.Builder)io.prometheus.metrics.core.metrics.Histogram.builder().name("summary_topologies_replication_count")).help("Replication count per topology")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.topologies:requested-cpu", ((Histogram.Builder)((Histogram.Builder)io.prometheus.metrics.core.metrics.Histogram.builder().name("summary_topologies_requested_cpu")).help("CPU requested per topology (% of a core)")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.topologies:requested-mem-off-heap", ((Histogram.Builder)((Histogram.Builder)io.prometheus.metrics.core.metrics.Histogram.builder().name("summary_topologies_requested_mem_off_heap")).help("Off heap memory requested per topology (MB)")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.topologies:requested-mem-on-heap", ((Histogram.Builder)((Histogram.Builder)io.prometheus.metrics.core.metrics.Histogram.builder().name("summary_topologies_requested_mem_on_heap")).help("On heap memory requested per topology (MB)")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.topologies:uptime-secs", ((Histogram.Builder)((Histogram.Builder)io.prometheus.metrics.core.metrics.Histogram.builder().name("summary_topologies_uptime_secs")).help("Uptime per topology (seconds)")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.supervisors:fragmented-cpu", ((Histogram.Builder)((Histogram.Builder)io.prometheus.metrics.core.metrics.Histogram.builder().name("supervisors_fragmented_cpu")).help("fragmented CPU per supervisor (% of a core)")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.supervisors:fragmented-mem", ((Histogram.Builder)((Histogram.Builder)io.prometheus.metrics.core.metrics.Histogram.builder().name("supervisors_fragmented_mem")).help("fragmented memory per supervisor (MB)")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.supervisors:num-used-workers", ((Histogram.Builder)((Histogram.Builder)io.prometheus.metrics.core.metrics.Histogram.builder().name("supervisors_num_used_workers")).help("workers used per supervisor")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.supervisors:num-workers", ((Histogram.Builder)((Histogram.Builder)io.prometheus.metrics.core.metrics.Histogram.builder().name("supervisors_num_workers")).help("number of workers per supervisor")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.supervisors:uptime-secs", ((Histogram.Builder)((Histogram.Builder)io.prometheus.metrics.core.metrics.Histogram.builder().name("supervisors_uptime_secs")).help("uptime of supervisors")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.supervisors:used-cpu", ((Histogram.Builder)((Histogram.Builder)io.prometheus.metrics.core.metrics.Histogram.builder().name("supervisors_used_cpu")).help("CPU used per supervisor (% of a core)")).register());
        CLUSTER_SUMMARY_METRICS.put("summary.supervisors:used-mem", ((Histogram.Builder)((Histogram.Builder)io.prometheus.metrics.core.metrics.Histogram.builder().name("supervisors_used_mem")).help("memory used per supervisor (MB)")).register());
    }
}

