/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics.prometheus;

import com.codahale.metrics.MetricRegistry;
import io.prometheus.metrics.exporter.pushgateway.HttpConnectionFactory;
import io.prometheus.metrics.exporter.pushgateway.PushGateway;
import io.prometheus.metrics.exporter.pushgateway.Scheme;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.storm.daemon.metrics.reporters.PreparableReporter;
import org.apache.storm.metrics.prometheus.PrometheusReporterClient;
import org.apache.storm.utils.ObjectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusPreparableReporter
implements PreparableReporter {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusPreparableReporter.class);
    private static final TrustManager INSECURE_TRUST_MANAGER = new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }
    };
    private static final HttpConnectionFactory INSECURE_CONNECTION_FACTORY = url -> {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{INSECURE_TRUST_MANAGER}, null);
            SSLContext.setDefault(sslContext);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setHostnameVerifier((hostname, session) -> true);
            return connection;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    };
    private PrometheusReporterClient reporter;
    private Integer reportingIntervalSecs;

    protected PrometheusReporterClient getReporter() {
        return this.reporter;
    }

    public void prepare(MetricRegistry metricsRegistry, Map<String, Object> daemonConf) {
        if (daemonConf != null) {
            String jobName = (String)daemonConf.getOrDefault("storm.daemon.metrics.reporter.plugin.prometheus.job", "storm");
            String endpoint = (String)daemonConf.getOrDefault("storm.daemon.metrics.reporter.plugin.prometheus.endpoint", "localhost:9091");
            String schemeAsString = (String)daemonConf.getOrDefault("storm.daemon.metrics.reporter.plugin.prometheus.scheme", "http");
            Scheme scheme = Scheme.HTTP;
            try {
                scheme = Scheme.fromString((String)schemeAsString);
            }
            catch (IllegalArgumentException iae) {
                LOG.warn("Unsupported scheme. Expecting 'http' or 'https'. Was: {}", (Object)schemeAsString);
            }
            String basicAuthUser = (String)daemonConf.getOrDefault("storm.daemon.metrics.reporter.plugin.prometheus.basic_auth_user", "");
            String basicAuthPassword = (String)daemonConf.getOrDefault("storm.daemon.metrics.reporter.plugin.prometheus.basic_auth_password", "");
            boolean skipTlsValidation = (Boolean)daemonConf.getOrDefault("storm.daemon.metrics.reporter.plugin.prometheus.skip_tls_validation", false);
            PushGateway.Builder builder = PushGateway.builder();
            builder.address(endpoint).job(jobName);
            if (!basicAuthUser.isBlank() && !basicAuthPassword.isBlank()) {
                builder.basicAuth(basicAuthUser, basicAuthPassword);
            }
            builder.scheme(scheme);
            if (scheme == Scheme.HTTPS && skipTlsValidation) {
                builder.connectionFactory(INSECURE_CONNECTION_FACTORY);
            }
            PushGateway pushGateway = builder.build();
            this.reporter = new PrometheusReporterClient(metricsRegistry, pushGateway);
            this.reportingIntervalSecs = ObjectReader.getInt((Object)daemonConf.get("storm.daemon.metrics.reporter.interval.secs"), (Integer)10);
        } else {
            LOG.warn("No daemonConfiguration was supplied. Don't initialize.");
        }
    }

    public void start() {
        if (this.reporter == null) {
            throw new IllegalStateException("Attempt to start without preparing " + this.getClass().getSimpleName());
        }
        LOG.debug("Starting...");
        this.reporter.start(this.reportingIntervalSecs.intValue(), TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.reporter == null) {
            throw new IllegalStateException("Attempt to stop without preparing " + this.getClass().getSimpleName());
        }
        LOG.debug("Stopping...");
        this.reporter.report();
        this.reporter.stop();
    }
}

