/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.loadgen;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.storm.utils.ObjectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalDistStats
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(NormalDistStats.class);
    public final double mean;
    public final double stddev;
    public final double min;
    public final double max;

    public static NormalDistStats fromConf(Map<String, Object> conf) {
        return NormalDistStats.fromConf(conf, null);
    }

    public static NormalDistStats fromConf(Map<String, Object> conf, Double def) {
        if (conf == null) {
            conf = Collections.emptyMap();
        }
        double mean = ObjectReader.getDouble((Object)conf.get("mean"), (Double)def);
        double stddev = ObjectReader.getDouble((Object)conf.get("stddev"), (Double)(mean / 4.0));
        double min = ObjectReader.getDouble((Object)conf.get("min"), (Double)0.0);
        double max = ObjectReader.getDouble((Object)conf.get("max"), (Double)Double.MAX_VALUE);
        return new NormalDistStats(mean, stddev, min, max);
    }

    public Map<String, Object> toConf() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("mean", this.mean);
        ret.put("stddev", this.stddev);
        ret.put("min", this.min);
        ret.put("max", this.max);
        return ret;
    }

    public NormalDistStats(List<Double> values) {
        double min = values.isEmpty() ? 0.0 : values.get(0);
        double max = values.isEmpty() ? 0.0 : values.get(0);
        double sum = 0.0;
        long count = values.size();
        for (Double v : values) {
            sum += v.doubleValue();
            min = Math.min(min, v);
            max = Math.max(max, v);
        }
        double mean = sum / (double)Math.max(count, 1L);
        double sdPartial = 0.0;
        for (Double v : values) {
            sdPartial += Math.pow(v - mean, 2.0);
        }
        double stddev = 0.0;
        if (count >= 2L) {
            stddev = Math.sqrt(sdPartial / (double)(count - 1L));
        }
        this.min = min;
        this.max = max;
        this.mean = mean;
        this.stddev = stddev;
        LOG.debug("Stats for {} are {}", (Object)values, (Object)this);
    }

    public NormalDistStats(double mean, double stddev, double min, double max) {
        this.mean = mean;
        this.stddev = stddev;
        this.min = min;
        this.max = max;
    }

    public double nextRandom(Random rand) {
        return Math.max(Math.min(rand.nextGaussian() * this.stddev + this.mean, this.max), this.min);
    }

    public String toString() {
        return "mean: " + this.mean + " min: " + this.min + " max: " + this.max + " stddev: " + this.stddev;
    }

    public NormalDistStats scaleBy(double v) {
        double newMean = this.mean * v;
        double shiftAmount = newMean - this.mean;
        return new NormalDistStats(Math.max(0.0, this.mean + shiftAmount), this.stddev, Math.max(0.0, this.min + shiftAmount), Math.max(0.0, this.max + shiftAmount));
    }
}

