/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.loadgen;

import com.esotericsoftware.kryo.io.Input;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.storm.metric.api.IMetricsConsumer;
import org.apache.storm.serialization.KryoValuesDeserializer;
import org.apache.storm.utils.Utils;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.server.Server;

public abstract class HttpForwardingMetricsServer {
    private Map<String, Object> conf;
    private Server server = null;
    private int port = -1;
    private String url = null;
    ThreadLocal<KryoValuesDeserializer> des = new ThreadLocal<KryoValuesDeserializer>(){

        @Override
        protected KryoValuesDeserializer initialValue() {
            return new KryoValuesDeserializer(HttpForwardingMetricsServer.this.conf);
        }
    };

    public HttpForwardingMetricsServer(Map<String, Object> conf) {
        this.conf = Utils.readStormConfig();
        if (conf != null) {
            this.conf.putAll(conf);
        }
    }

    public abstract void handle(IMetricsConsumer.TaskInfo var1, Collection<IMetricsConsumer.DataPoint> var2, String var3);

    public void serve(Integer port) {
        try {
            if (this.server != null) {
                throw new RuntimeException("The server is already running");
            }
            if (port == null || port <= 0) {
                ServerSocket s = new ServerSocket(0);
                port = s.getLocalPort();
                s.close();
            }
            this.server = new Server(port);
            this.port = port;
            this.url = "http://" + InetAddress.getLocalHost().getHostName() + ":" + this.port + "/";
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            this.server.setHandler(context);
            context.addServlet(new ServletHolder(new MetricsCollectionServlet()), "/*");
            this.server.start();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void serve() {
        this.serve(null);
    }

    public int getPort() {
        return this.port;
    }

    public String getUrl() {
        return this.url;
    }

    private class MetricsCollectionServlet
    extends HttpServlet {
        private MetricsCollectionServlet() {
        }

        @Override
        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            Input in = new Input((InputStream)request.getInputStream());
            List metrics = HttpForwardingMetricsServer.this.des.get().deserializeFrom(in);
            HttpForwardingMetricsServer.this.handle((IMetricsConsumer.TaskInfo)metrics.get(0), (Collection)metrics.get(1), (String)metrics.get(2));
            response.setStatus(200);
        }
    }
}

