/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.loadgen;

import java.util.Locale;
import org.apache.storm.loadgen.InputStream;
import org.apache.storm.topology.BoltDeclarer;
import org.apache.storm.tuple.Fields;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum GroupingType {
    SHUFFLE{

        @Override
        public void assign(BoltDeclarer declarer, InputStream stream) {
            declarer.shuffleGrouping(stream.fromComponent, stream.id);
        }
    }
    ,
    FIELDS{

        @Override
        public void assign(BoltDeclarer declarer, InputStream stream) {
            declarer.fieldsGrouping(stream.fromComponent, stream.id, new Fields(new String[]{"key"}));
        }
    }
    ,
    ALL{

        @Override
        public void assign(BoltDeclarer declarer, InputStream stream) {
            declarer.allGrouping(stream.fromComponent, stream.id);
        }
    }
    ,
    GLOBAL{

        @Override
        public void assign(BoltDeclarer declarer, InputStream stream) {
            declarer.globalGrouping(stream.fromComponent, stream.id);
        }
    }
    ,
    LOCAL_OR_SHUFFLE{

        @Override
        public void assign(BoltDeclarer declarer, InputStream stream) {
            declarer.localOrShuffleGrouping(stream.fromComponent, stream.id);
        }
    }
    ,
    NONE{

        @Override
        public void assign(BoltDeclarer declarer, InputStream stream) {
            declarer.noneGrouping(stream.fromComponent, stream.id);
        }
    }
    ,
    PARTIAL_KEY{

        @Override
        public void assign(BoltDeclarer declarer, InputStream stream) {
            declarer.partialKeyGrouping(stream.fromComponent, stream.id, new Fields(new String[]{"key"}));
        }
    };


    public static GroupingType fromConf(String conf) {
        String gt = "SHUFFLE";
        if (conf != null) {
            gt = conf.toUpperCase(Locale.ENGLISH);
        }
        return GroupingType.valueOf(gt);
    }

    public String toConf() {
        return this.toString();
    }

    public abstract void assign(BoltDeclarer var1, InputStream var2);
}

