/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.loadgen;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.loadgen.InputStream;
import org.apache.storm.loadgen.LoadCompConf;
import org.apache.storm.loadgen.OutputStream;
import org.apache.storm.loadgen.SlowExecutorPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class TopologyLoadConf {
    private static final Logger LOG = LoggerFactory.getLogger(TopologyLoadConf.class);
    static final Set<String> IMPORTANT_CONF_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("topology.workers", "topology.acker.executors", "topology.component.cpu.pcore.percent", "topology.component.resources.offheap.memory.mb", "topology.component.resources.onheap.memory.mb", "topology.disable.loadaware.messaging", "topology.debug", "topology.executor.receive.buffer.size", "topology.isolate.machines", "topology.max.spout.pending", "topology.max.task.parallelism", "topology.message.timeout.secs", "topology.priority", "topology.scheduler.strategy", "topology.shellbolt.max.pending", "topology.sleep.spout.wait.strategy.time.ms", "topology.spout.wait.strategy", "topology.worker.childopts", "topology.worker.gc.childopts", "topology.worker.shared.thread.pool.size", "topology.worker.max.heap.size.mb")));
    private static AtomicInteger topoUniquifier = new AtomicInteger(0);
    public final String name;
    public final Map<String, Object> topoConf;
    public final List<LoadCompConf> spouts;
    public final List<LoadCompConf> bolts;
    public final List<InputStream> streams;
    private final AtomicInteger boltUniquifier = new AtomicInteger(0);
    private final AtomicInteger spoutUniquifier = new AtomicInteger(0);
    private final AtomicInteger streamUniquifier = new AtomicInteger(0);

    public static TopologyLoadConf fromConf(File file) throws IOException {
        Yaml yaml = new Yaml(new SafeConstructor(new LoaderOptions()));
        Map yamlConf = (Map)yaml.load(new FileReader(file));
        return TopologyLoadConf.fromConf(yamlConf);
    }

    public static TopologyLoadConf fromConf(Map<String, Object> conf) {
        HashMap<String, Object> topoConf = null;
        if (conf.containsKey("config")) {
            topoConf = new HashMap<String, Object>((Map)conf.get("config"));
        }
        ArrayList<LoadCompConf> spouts = new ArrayList<LoadCompConf>();
        for (Map spoutInfo : (List)conf.get("spouts")) {
            spouts.add(LoadCompConf.fromConf(spoutInfo));
        }
        ArrayList<LoadCompConf> bolts = new ArrayList<LoadCompConf>();
        List boltInfos = (List)conf.get("bolts");
        if (boltInfos != null) {
            for (Map boltInfo : boltInfos) {
                bolts.add(LoadCompConf.fromConf(boltInfo));
            }
        }
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        List streamInfos = (List)conf.get("streams");
        if (streamInfos != null) {
            for (Map streamInfo : streamInfos) {
                streams.add(InputStream.fromConf(streamInfo));
            }
        }
        return new TopologyLoadConf((String)conf.get("name"), topoConf, spouts, bolts, streams);
    }

    public void writeTo(File file) throws IOException {
        Yaml yaml = new Yaml(new SafeConstructor(new LoaderOptions()));
        try (FileWriter writer = new FileWriter(file);){
            yaml.dump(this.toConf(), writer);
        }
    }

    public String toYamlString() {
        Yaml yaml = new Yaml(new SafeConstructor(new LoaderOptions()));
        StringWriter writer = new StringWriter();
        yaml.dump(this.toConf(), writer);
        return writer.toString();
    }

    public Map<String, Object> toConf() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (this.name != null) {
            ret.put("name", this.name);
        }
        if (this.topoConf != null) {
            ret.put("config", this.topoConf);
        }
        if (this.spouts != null && !this.spouts.isEmpty()) {
            ret.put("spouts", this.spouts.stream().map(LoadCompConf::toConf).collect(Collectors.toList()));
        }
        if (this.bolts != null && !this.bolts.isEmpty()) {
            ret.put("bolts", this.bolts.stream().map(LoadCompConf::toConf).collect(Collectors.toList()));
        }
        if (this.streams != null && !this.streams.isEmpty()) {
            ret.put("streams", this.streams.stream().map(InputStream::toConf).collect(Collectors.toList()));
        }
        return ret;
    }

    public TopologyLoadConf(String name, Map<String, Object> topoConf, List<LoadCompConf> spouts, List<LoadCompConf> bolts, List<InputStream> streams) {
        this.name = name;
        this.topoConf = topoConf;
        this.spouts = spouts;
        this.bolts = bolts;
        this.streams = streams;
    }

    private static String getUniqueTopoName() {
        return "topology_" + TopologyLoadConf.asCharString(topoUniquifier.getAndIncrement());
    }

    private String getUniqueBoltName() {
        return "bolt_" + TopologyLoadConf.asCharString(this.boltUniquifier.getAndIncrement());
    }

    private String getUniqueSpoutName() {
        return "spout_" + TopologyLoadConf.asCharString(this.spoutUniquifier.getAndIncrement());
    }

    private String getUniqueStreamName() {
        return "stream_" + TopologyLoadConf.asCharString(this.spoutUniquifier.getAndIncrement());
    }

    private static String asCharString(int value) {
        int div = value / 26;
        int remainder = value % 26;
        Object ret = "";
        if (div > 0) {
            ret = TopologyLoadConf.asCharString(div);
        }
        ret = (String)ret + (char)(97 + remainder);
        return ret;
    }

    public TopologyLoadConf withName(String baseName) {
        return new TopologyLoadConf(baseName, this.topoConf, this.spouts, this.bolts, this.streams);
    }

    static <V> V or(V ... rest) {
        for (V i : rest) {
            if (i == null) continue;
            return i;
        }
        return null;
    }

    LoadCompConf scaleCompParallel(LoadCompConf comp, double v, Map<String, Double> topoSpecificParallel) {
        LoadCompConf ret = comp;
        double scale = TopologyLoadConf.or(topoSpecificParallel.get(this.name + ":" + comp.id), topoSpecificParallel.get(this.name + ":*"), topoSpecificParallel.get("*:" + comp.id), v);
        if (scale != 1.0) {
            ret = ret.scaleParallel(scale);
        }
        return ret;
    }

    LoadCompConf scaleCompThroughput(LoadCompConf comp, double v, Map<String, Double> topoSpecificParallel) {
        LoadCompConf ret = comp;
        double scale = TopologyLoadConf.or(topoSpecificParallel.get(this.name + ":" + comp.id), topoSpecificParallel.get(this.name + ":*"), topoSpecificParallel.get("*:" + comp.id), v);
        if (scale != 1.0) {
            ret = ret.scaleThroughput(scale);
        }
        return ret;
    }

    private LoadCompConf overrideCompSlowExec(LoadCompConf comp, Map<String, SlowExecutorPattern> topoSpecific) {
        LoadCompConf ret = comp;
        SlowExecutorPattern slp = topoSpecific.get(this.name + ":" + comp.id);
        if (slp != null) {
            ret = ret.overrideSlowExecutorPattern(slp);
        }
        return ret;
    }

    public TopologyLoadConf scaleParallel(double v, Map<String, Double> topoSpecific) {
        if (v == 1.0 && (topoSpecific == null || topoSpecific.isEmpty())) {
            return this;
        }
        List<LoadCompConf> scaledSpouts = this.spouts.stream().map(s -> this.scaleCompParallel((LoadCompConf)s, v, topoSpecific)).collect(Collectors.toList());
        List<LoadCompConf> scaledBolts = this.bolts.stream().map(s -> this.scaleCompParallel((LoadCompConf)s, v, topoSpecific)).collect(Collectors.toList());
        return new TopologyLoadConf(this.name, this.topoConf, scaledSpouts, scaledBolts, this.streams);
    }

    public TopologyLoadConf scaleThroughput(double v, Map<String, Double> topoSpecific) {
        if (v == 1.0 && (topoSpecific == null || topoSpecific.isEmpty())) {
            return this;
        }
        List<LoadCompConf> scaledSpouts = this.spouts.stream().map(s -> this.scaleCompThroughput((LoadCompConf)s, v, topoSpecific)).collect(Collectors.toList());
        List<LoadCompConf> scaledBolts = this.bolts.stream().map(s -> this.scaleCompThroughput((LoadCompConf)s, v, topoSpecific)).collect(Collectors.toList());
        return new TopologyLoadConf(this.name, this.topoConf, scaledSpouts, scaledBolts, this.streams);
    }

    public TopologyLoadConf overrideSlowExecs(Map<String, SlowExecutorPattern> topoSpecific) {
        if (topoSpecific == null || topoSpecific.isEmpty()) {
            return this;
        }
        List<LoadCompConf> modedSpouts = this.spouts.stream().map(s -> this.overrideCompSlowExec((LoadCompConf)s, topoSpecific)).collect(Collectors.toList());
        List<LoadCompConf> modedBolts = this.bolts.stream().map(b -> this.overrideCompSlowExec((LoadCompConf)b, topoSpecific)).collect(Collectors.toList());
        return new TopologyLoadConf(this.name, this.topoConf, modedSpouts, modedBolts, this.streams);
    }

    public TopologyLoadConf anonymize() {
        GlobalStreamId remapped;
        GlobalStreamId orig2;
        String newId;
        HashMap<String, String> remappedComponents = new HashMap<String, String>();
        HashMap<GlobalStreamId, GlobalStreamId> remappedStreams = new HashMap<GlobalStreamId, GlobalStreamId>();
        for (LoadCompConf comp : this.bolts) {
            newId = this.getUniqueBoltName();
            remappedComponents.put(comp.id, newId);
            if (comp.streams == null) continue;
            for (OutputStream out : comp.streams) {
                orig2 = new GlobalStreamId(comp.id, out.id);
                remapped = new GlobalStreamId(newId, this.getUniqueStreamName());
                remappedStreams.put(orig2, remapped);
            }
        }
        for (LoadCompConf comp : this.spouts) {
            remappedComponents.put(comp.id, this.getUniqueSpoutName());
            newId = this.getUniqueSpoutName();
            remappedComponents.put(comp.id, newId);
            if (comp.streams == null) continue;
            for (OutputStream out : comp.streams) {
                orig2 = new GlobalStreamId(comp.id, out.id);
                remapped = new GlobalStreamId(newId, this.getUniqueStreamName());
                remappedStreams.put(orig2, remapped);
            }
        }
        for (InputStream in : this.streams) {
            GlobalStreamId orig3;
            if (!remappedComponents.containsKey(in.toComponent)) {
                remappedComponents.put(in.toComponent, this.getUniqueSpoutName());
            }
            if (remappedStreams.containsKey(orig3 = in.gsid())) continue;
            String remappedComp = remappedComponents.computeIfAbsent(in.fromComponent, key -> {
                LOG.warn("stream's {} from is not defined {}", (Object)in.id, (Object)in.fromComponent);
                return this.getUniqueBoltName();
            });
            remappedStreams.put(orig3, new GlobalStreamId(remappedComp, this.getUniqueStreamName()));
        }
        List<LoadCompConf> remappedSpouts = this.spouts.stream().map(orig -> orig.remap(remappedComponents, remappedStreams)).collect(Collectors.toList());
        List<LoadCompConf> remappedBolts = this.bolts.stream().map(orig -> orig.remap(remappedComponents, remappedStreams)).collect(Collectors.toList());
        List<InputStream> remappedInputStreams = this.streams.stream().map(orig -> orig.remap(remappedComponents, remappedStreams)).collect(Collectors.toList());
        return new TopologyLoadConf(TopologyLoadConf.getUniqueTopoName(), TopologyLoadConf.anonymizeTopoConf(this.topoConf), remappedSpouts, remappedBolts, remappedInputStreams);
    }

    private static Map<String, Object> anonymizeTopoConf(Map<String, Object> topoConf) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : topoConf.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!IMPORTANT_CONF_KEYS.contains(key)) continue;
            if ("topology.worker.childopts".equals(key) || "topology.worker.gc.childopts".equals(key)) {
                value = TopologyLoadConf.cleanupChildOpts(value);
            }
            ret.put(key, value);
        }
        return ret;
    }

    private static Object cleanupChildOpts(Object value) {
        if (value instanceof String) {
            String sv = (String)value;
            StringBuffer ret = new StringBuffer();
            for (String part : sv.split("\\s+")) {
                if (!part.startsWith("-X")) continue;
                ret.append(part).append(" ");
            }
            return ret.toString();
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String subValue : (Collection)value) {
            ret.add((String)TopologyLoadConf.cleanupChildOpts(subValue));
        }
        return ret.stream().filter(item -> item != null && !item.isEmpty()).collect(Collectors.toList());
    }

    public boolean looksLikeTrident() {
        for (LoadCompConf spout : this.spouts) {
            if (!spout.id.startsWith("$mastercoord")) continue;
            return true;
        }
        for (LoadCompConf bolt : this.bolts) {
            if (!bolt.id.startsWith("$spoutcoord")) continue;
            return true;
        }
        for (InputStream in : this.streams) {
            if (!in.id.equals("$batch")) continue;
            return true;
        }
        return false;
    }

    public double getAllEmittedAggregate() {
        double ret = this.getSpoutEmittedAggregate();
        for (LoadCompConf bolt : this.bolts) {
            ret += bolt.getAllEmittedAggregate();
        }
        return ret;
    }

    public double getSpoutEmittedAggregate() {
        double ret = 0.0;
        for (LoadCompConf spout : this.spouts) {
            ret += spout.getAllEmittedAggregate();
        }
        return ret;
    }

    public double getTridentEstimatedEmittedAggregate() {
        double ret = 0.0;
        if (this.looksLikeTrident()) {
            ArrayList<LoadCompConf> all = new ArrayList<LoadCompConf>(this.bolts);
            all.addAll(this.spouts);
            for (LoadCompConf comp : all) {
                if (!comp.id.startsWith("spout-") || comp.streams == null) continue;
                for (OutputStream out : comp.streams) {
                    if (out.id.startsWith("$") || out.id.startsWith("__") || out.rate == null) continue;
                    ret += out.rate.mean * (double)comp.parallelism;
                }
            }
        }
        return ret;
    }

    public TopologyLoadConf replaceShuffleWithLocalOrShuffle() {
        List<InputStream> modified = this.streams.stream().map(in -> in.replaceShuffleWithLocalOrShuffle()).collect(Collectors.toList());
        return new TopologyLoadConf(this.name, this.topoConf, this.spouts, this.bolts, modified);
    }
}

