/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.loadgen;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.storm.utils.ObjectReader;

public class SlowExecutorPattern
implements Serializable {
    private static final Pattern PARSER = Pattern.compile("\\s*(?<slowness>[^:]+)\\s*(?::\\s*(?<count>[0-9]+))?\\s*");
    public final double maxSlownessMs;
    public final int count;

    public static SlowExecutorPattern fromString(String strRepresentation) {
        Matcher m = PARSER.matcher(strRepresentation);
        if (!m.matches()) {
            throw new IllegalArgumentException(strRepresentation + " is not in the form <SLOWNESS>(:<COUNT>)?");
        }
        double slownessMs = Double.valueOf(m.group("slowness"));
        String c = m.group("count");
        int count = c == null ? 1 : Integer.valueOf(c);
        return new SlowExecutorPattern(slownessMs, count);
    }

    public static SlowExecutorPattern fromConf(Map<String, Object> conf) {
        double slowness = ObjectReader.getDouble((Object)conf.get("slownessMs"), (Double)0.0);
        int count = ObjectReader.getInt((Object)conf.get("count"), (Integer)1);
        return new SlowExecutorPattern(slowness, count);
    }

    public Map<String, Object> toConf() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("slownessMs", this.maxSlownessMs);
        ret.put("count", this.count);
        return ret;
    }

    public SlowExecutorPattern(double maxSlownessMs, int count) {
        this.count = count;
        this.maxSlownessMs = maxSlownessMs;
    }

    public double getExtraSlowness(int index) {
        return index >= this.count ? 0.0 : this.maxSlownessMs;
    }
}

