/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.loadgen;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.storm.generated.KillOptions;
import org.apache.storm.generated.Nimbus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopedTopologySet
extends HashSet<String>
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ScopedTopologySet.class);
    private static final KillOptions NO_WAIT_KILL = new KillOptions();
    private final Nimbus.Iface client;
    private boolean closed = false;

    public ScopedTopologySet(Nimbus.Iface client) {
        this.client = client;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.close();
            }
            catch (Exception e) {
                LOG.error("Error trying to shutdown topologies on exit", e);
            }
        }));
    }

    @Override
    public boolean remove(Object o) {
        throw new RuntimeException("Unmodifiable Set");
    }

    @Override
    public void clear() {
        throw new RuntimeException("Unmodifiable Set");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new RuntimeException("Unmodifiable Set");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new RuntimeException("Unmodifiable Set");
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        RuntimeException saved = null;
        Iterator it = super.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            try {
                this.client.killTopologyWithOpts(name, NO_WAIT_KILL);
                it.remove();
            }
            catch (Exception e) {
                RuntimeException wrapped = new RuntimeException("Error trying to kill " + name, e);
                if (saved != null) {
                    saved.addSuppressed(wrapped);
                    continue;
                }
                saved = wrapped;
            }
        }
        super.clear();
        if (saved != null) {
            throw saved;
        }
        this.closed = true;
    }

    static {
        NO_WAIT_KILL.set_wait_secs(0);
    }
}

