/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.loadgen;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.storm.loadgen.OutputStream;

public class OutputStreamEngine {
    private static final double NANO_PER_SEC = 1.0E9;
    private static final long UPDATE_RATE_PERIOD_NS = 2000000000L;
    private static final String[] KEYS = new String[2048];
    private long periodNano;
    private long emitAmount;
    private final Random rand;
    private long nextEmitTime;
    private long nextRateRandomizeTime;
    private long emitsLeft;
    private final OutputStream stats;
    public final String streamName;

    public OutputStreamEngine(OutputStream stats) {
        this.stats = stats;
        this.rand = ThreadLocalRandom.current();
        this.selectNewRate();
        this.nextEmitTime = System.nanoTime();
        this.nextRateRandomizeTime = this.nextEmitTime + 2000000000L;
        this.emitsLeft = this.emitAmount;
        this.streamName = stats.id;
    }

    private void selectNewRate() {
        double ratePerSecond = this.stats.rate.nextRandom(this.rand);
        if (ratePerSecond > 0.0) {
            this.periodNano = Math.max(1L, (long)(1.0E9 / ratePerSecond));
            this.emitAmount = Math.max(1L, (long)(ratePerSecond / 1.0E9 * (double)this.periodNano));
        } else {
            this.periodNano = 10000000000L;
            this.emitAmount = 1L;
        }
    }

    public Long shouldEmit() {
        long time = System.nanoTime();
        if (this.emitsLeft <= 0L && this.nextEmitTime <= time) {
            this.emitsLeft = this.emitAmount;
            this.nextEmitTime += this.periodNano;
        }
        if (this.nextRateRandomizeTime <= time) {
            this.selectNewRate();
            this.nextRateRandomizeTime = this.nextEmitTime + 2000000000L;
        }
        if (this.emitsLeft > 0L) {
            --this.emitsLeft;
            return this.nextEmitTime - this.periodNano;
        }
        return null;
    }

    public String nextKey() {
        int keyIndex = this.stats.areKeysSkewed ? Math.min(KEYS.length - 1, Math.abs((int)(this.rand.nextGaussian() * (double)KEYS.length / 5.0))) : this.rand.nextInt(KEYS.length);
        return KEYS[keyIndex];
    }

    public int nextInt(int bound) {
        return this.rand.nextInt(bound);
    }

    static {
        Random r = new Random(KEYS.length);
        for (int i = 0; i < KEYS.length; ++i) {
            OutputStreamEngine.KEYS[i] = String.valueOf(r.nextDouble());
        }
    }
}

