/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.loadgen;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.HdrHistogram.Histogram;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.storm.generated.ExecutorSummary;
import org.apache.storm.generated.Nimbus;
import org.apache.storm.generated.SpoutStats;
import org.apache.storm.generated.TopologyInfo;
import org.apache.storm.generated.TopologyPageInfo;
import org.apache.storm.loadgen.HttpForwardingMetricsServer;
import org.apache.storm.metric.api.IMetricsConsumer;
import org.apache.storm.utils.Utils;
import org.apache.storm.utils.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadMetricsServer
extends HttpForwardingMetricsServer {
    private static final Logger LOG = LoggerFactory.getLogger(LoadMetricsServer.class);
    private static final Map<String, TimeUnit> UNIT_MAP;
    private static final Map<TimeUnit, String> TIME_UNIT_NAME;
    private static final Map<String, MetricExtractor> NAMED_EXTRACTORS;
    public static final long DEFAULT_REPORT_INTERVAL = 30L;
    public static final long DEFAULT_WINDOW_INTERVAL = 30L;
    private static final Pattern REPORTER_PATTERN;
    private final Histogram histo = new Histogram(3600000000000L, 3);
    private final AtomicLong systemCpu = new AtomicLong(0L);
    private final AtomicLong userCpu = new AtomicLong(0L);
    private final AtomicLong gcCount = new AtomicLong(0L);
    private final AtomicLong gcMs = new AtomicLong(0L);
    private final AtomicLong skippedMaxSpoutMs = new AtomicLong(0L);
    private final ConcurrentHashMap<String, MemMeasure> memoryBytes = new ConcurrentHashMap();
    private final AtomicReference<ConcurrentHashMap<String, String>> congested = new AtomicReference(new ConcurrentHashMap());
    private final List<MetricResultsReporter> reporters;
    private long prevAcked = 0L;
    private long prevFailed = 0L;
    private long prevUptime = 0L;
    private int windowLength = 1;
    private long reportIntervalSecs = 30L;
    private final LinkedList<Measurements> allCombined = new LinkedList();

    @VisibleForTesting
    static double convert(double value, TimeUnit from, TimeUnit target) {
        if (target.compareTo(from) > 0) {
            return value / (double)from.convert(1L, target);
        }
        return value * (double)target.convert(1L, from);
    }

    public static void addCommandLineOptions(Options options) {
        options.addOption(Option.builder("r").longOpt("report-interval").hasArg().argName("SECS").desc("How long in between reported metrics.  Will be rounded up to the next 10 sec boundary.\ndefault 30").build());
        options.addOption(Option.builder("w").longOpt("report-window").hasArg().argName("SECS").desc("How long of a rolling window should be in each report.  Will be rounded up to the next report interval boundary.\ndefault 30").build());
        options.addOption(Option.builder().longOpt("reporter").hasArg().argName("TYPE:PATH?OPTIONS").desc("Provide the config for a reporter to run.  Supported types are:\nFIXED - a fixed width format that should be more human readable\nLEGACY - (write things out in the legacy format)\nTSV - tab separated values\nCSV - comma separated values\nPATH and OPTIONS are each optional but must be marked with a ':' or '?' separator respectively.").build());
    }

    LoadMetricsServer(Map<String, Object> conf, CommandLine commandLine, Map<String, Object> parameterMetrics) throws URISyntaxException, FileNotFoundException {
        super(conf);
        MetricResultsReporter rep;
        LinkedHashMap<String, MetricExtractor> allExtractors = new LinkedHashMap<String, MetricExtractor>(NAMED_EXTRACTORS);
        for (Map.Entry<String, Object> entry : parameterMetrics.entrySet()) {
            Object value = entry.getValue();
            allExtractors.put(entry.getKey(), new MetricExtractor((m, unit) -> value, ""));
        }
        if (commandLine.hasOption("r")) {
            this.reportIntervalSecs = Long.parseLong(commandLine.getOptionValue("r"));
            this.reportIntervalSecs = (this.reportIntervalSecs + 1L) / 10L * 10L;
        }
        if (commandLine.hasOption("w")) {
            long window = Long.parseLong(commandLine.getOptionValue("w"));
            this.windowLength = (int)((window + 1L) / this.reportIntervalSecs);
        }
        this.reporters = new ArrayList<MetricResultsReporter>();
        if (commandLine.hasOption("reporter")) {
            block13: for (String reporterString : commandLine.getOptionValues("reporter")) {
                Matcher m2 = REPORTER_PATTERN.matcher(reporterString);
                if (!m2.matches()) {
                    throw new IllegalArgumentException(reporterString + " does not look like it is a reporter");
                }
                String type = m2.group("type");
                String path = m2.group("path");
                HashMap<String, String> query = new HashMap<String, String>();
                String queryString = m2.group("query");
                if (queryString != null) {
                    for (String param : queryString.split("&")) {
                        String[] pair = param.split("=");
                        String key = pair[0];
                        String value = pair.length > 1 ? pair[1] : "true";
                        query.put(key, value);
                    }
                }
                type = type.toUpperCase();
                switch (type) {
                    case "FIXED": {
                        this.reporters.add(new FixedWidthReporter(path, query, allExtractors));
                        continue block13;
                    }
                    case "LEGACY": {
                        this.reporters.add(new LegacyReporter(path, query, allExtractors));
                        continue block13;
                    }
                    case "TSV": {
                        this.reporters.add(new SepValReporter("\t", path, query, allExtractors));
                        continue block13;
                    }
                    case "CSV": {
                        this.reporters.add(new SepValReporter(",", path, query, allExtractors));
                        continue block13;
                    }
                    default: {
                        throw new RuntimeException(type + " is not a supported reporter type");
                    }
                }
            }
        }
        boolean foundStdOutOrErr = false;
        Iterator<MetricResultsReporter> iterator = this.reporters.iterator();
        while (!(!iterator.hasNext() || (rep = iterator.next()) instanceof FileReporter && (foundStdOutOrErr = ((FileReporter)rep).includesSysOutOrError))) {
        }
        if (!foundStdOutOrErr) {
            this.reporters.add(new FixedWidthReporter(allExtractors));
        }
    }

    private long readMemory() {
        long total = 0L;
        for (MemMeasure mem : this.memoryBytes.values()) {
            total += mem.get();
        }
        return total;
    }

    private void startMetricsOutput() {
        for (MetricResultsReporter reporter : this.reporters) {
            reporter.start();
        }
    }

    private void finishMetricsOutput() throws Exception {
        for (MetricResultsReporter reporter : this.reporters) {
            reporter.finish(this.allCombined);
        }
    }

    public void monitorFor(double execTimeMins, Nimbus.Iface client, Collection<String> topoNames) throws Exception {
        this.startMetricsOutput();
        long iterations = (long)(execTimeMins * 60.0 / (double)this.reportIntervalSecs);
        int i = 0;
        while ((long)i < iterations) {
            Thread.sleep(this.reportIntervalSecs * 1000L);
            this.outputMetrics(client, topoNames);
            ++i;
        }
        this.finishMetricsOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputMetrics(Nimbus.Iface client, Collection<String> names) throws Exception {
        Object failedMap;
        HashSet<String> ids = new HashSet<String>();
        HashSet<CallSite> workers = new HashSet<CallSite>();
        HashSet<String> hosts = new HashSet<String>();
        int executors = 0;
        int uptime = 0;
        long acked = 0L;
        long failed = 0L;
        double totalLatMs = 0.0;
        long totalLatCount = 0L;
        for (String name : names) {
            TopologyInfo info = client.getTopologyInfoByName(name);
            ids.add(info.get_id());
            TopologyPageInfo tpi = client.getTopologyPageInfo(info.get_id(), ":all-time", false);
            uptime = Math.max(uptime, info.get_uptime_secs());
            for (ExecutorSummary exec : info.get_executors()) {
                hosts.add(exec.get_host());
                workers.add((CallSite)((Object)(exec.get_host() + exec.get_port())));
                ++executors;
                if (exec.get_stats() == null || exec.get_stats().get_specific() == null || !exec.get_stats().get_specific().is_set_spout()) continue;
                SpoutStats stats = exec.get_stats().get_specific().get_spout();
                failedMap = (Map)stats.get_failed().get(":all-time");
                Map ackedMap = (Map)stats.get_acked().get(":all-time");
                if (ackedMap == null) continue;
                for (String key : ackedMap.keySet()) {
                    Long tmp;
                    if (failedMap != null && (tmp = (Long)failedMap.get(key)) != null) {
                        failed += tmp.longValue();
                    }
                    long ackVal = (Long)ackedMap.get(key);
                    acked += ackVal;
                }
            }
            Double latency = (Double)tpi.get_topology_stats().get_window_to_complete_latencies_ms().get(":all-time");
            Long latAcked = (Long)tpi.get_topology_stats().get_window_to_acked().get(":all-time");
            if (latency == null || latAcked == null) continue;
            totalLatCount += latAcked.longValue();
            totalLatMs += (double)latAcked.longValue() * latency;
        }
        long failedThisTime = failed - this.prevFailed;
        long ackedThisTime = acked - this.prevAcked;
        long thisTime = (long)uptime - this.prevUptime;
        this.prevUptime = uptime;
        this.prevAcked = acked;
        this.prevFailed = failed;
        Histogram copy = new Histogram(3600000000000L, 3);
        failedMap = this.histo;
        synchronized (failedMap) {
            copy.add(this.histo);
            this.histo.reset();
        }
        long user = this.userCpu.getAndSet(0L);
        long sys = this.systemCpu.getAndSet(0L);
        long gc = this.gcMs.getAndSet(0L);
        long skippedMaxSpout = this.skippedMaxSpoutMs.getAndSet(0L);
        long memBytes = this.readMemory();
        this.allCombined.add(new Measurements(uptime, ackedThisTime, thisTime, failedThisTime, copy, user, sys, gc, memBytes, ids, workers.size(), executors, hosts.size(), this.congested.getAndSet(new ConcurrentHashMap()), skippedMaxSpout, totalLatMs / (double)totalLatCount));
        Measurements inWindow = Measurements.combine(this.allCombined, null, this.windowLength);
        for (MetricResultsReporter reporter : this.reporters) {
            reporter.reportWindow(inWindow, this.allCombined);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(IMetricsConsumer.TaskInfo taskInfo, Collection<IMetricsConsumer.DataPoint> dataPoints, String topologyId) {
        String worker = taskInfo.srcWorkerHost + ":" + taskInfo.srcWorkerPort;
        for (IMetricsConsumer.DataPoint dp : dataPoints) {
            if (dp.name.startsWith("comp-lat-histo") && dp.value instanceof Histogram) {
                Histogram histogram = this.histo;
                synchronized (histogram) {
                    this.histo.add((Histogram)dp.value);
                    continue;
                }
            }
            if ("CPU".equals(dp.name) && dp.value instanceof Map) {
                Object user;
                Map m = (Map)dp.value;
                Object sys = m.get("sys-ms");
                if (sys instanceof Number) {
                    this.systemCpu.getAndAdd(((Number)sys).longValue());
                }
                if (!((user = m.get("user-ms")) instanceof Number)) continue;
                this.userCpu.getAndAdd(((Number)user).longValue());
                continue;
            }
            if (dp.name.startsWith("GC/") && dp.value instanceof Map) {
                Object time;
                Map m = (Map)dp.value;
                Object count = m.get("count");
                if (count instanceof Number) {
                    this.gcCount.getAndAdd(((Number)count).longValue());
                }
                if (!((time = m.get("timeMs")) instanceof Number)) continue;
                this.gcMs.getAndAdd(((Number)time).longValue());
                continue;
            }
            if (dp.name.startsWith("memory/") && dp.value instanceof Map) {
                Map m = (Map)dp.value;
                Object val = m.get("usedBytes");
                if (!(val instanceof Number)) continue;
                MemMeasure mm = this.memoryBytes.get(worker);
                if (mm == null) {
                    mm = new MemMeasure();
                    MemMeasure tmp = this.memoryBytes.putIfAbsent(worker, mm);
                    mm = tmp == null ? mm : tmp;
                }
                mm.update(((Number)val).longValue());
                continue;
            }
            if (dp.name.equals("__receive")) {
                double full;
                Map m = (Map)dp.value;
                Object pop = m.get("population");
                Object cap = m.get("capacity");
                if (!(pop instanceof Number) || !(cap instanceof Number) || !((full = ((Number)pop).doubleValue() / ((Number)cap).doubleValue()) >= 0.8)) continue;
                this.congested.get().put(topologyId + ":" + taskInfo.srcComponentId + ":" + taskInfo.srcTaskId, "receive " + String.valueOf(pop) + "/" + String.valueOf(cap));
                continue;
            }
            if (!dp.name.equals("__skipped-max-spout-ms") || !(dp.value instanceof Number)) continue;
            this.skippedMaxSpoutMs.getAndAdd(((Number)dp.value).longValue());
            double full = ((Number)dp.value).doubleValue() / 10000.0;
            if (!(full >= 0.8)) continue;
            this.congested.get().put(topologyId + ":" + taskInfo.srcComponentId + ":" + taskInfo.srcTaskId, "max.spout.pending " + (int)(full * 100.0) + "%");
        }
    }

    static {
        HashMap<Object, Object> tmp = new HashMap<Object, Object>();
        tmp.put("NS", (Object)TimeUnit.NANOSECONDS);
        tmp.put("NANO", (Object)TimeUnit.NANOSECONDS);
        tmp.put("NANOSEC", (Object)TimeUnit.NANOSECONDS);
        tmp.put("NANOSECOND", (Object)TimeUnit.NANOSECONDS);
        tmp.put("NANOSECONDS", (Object)TimeUnit.NANOSECONDS);
        tmp.put("\u03bcS", (Object)TimeUnit.MICROSECONDS);
        tmp.put("US", (Object)TimeUnit.MICROSECONDS);
        tmp.put("MICRO", (Object)TimeUnit.MICROSECONDS);
        tmp.put("MICROSEC", (Object)TimeUnit.MICROSECONDS);
        tmp.put("MICROSECOND", (Object)TimeUnit.MICROSECONDS);
        tmp.put("MICROSECONDS", (Object)TimeUnit.MICROSECONDS);
        tmp.put("MS", (Object)TimeUnit.MILLISECONDS);
        tmp.put("MILLI", (Object)TimeUnit.MILLISECONDS);
        tmp.put("MILLISEC", (Object)TimeUnit.MILLISECONDS);
        tmp.put("MILLISECOND", (Object)TimeUnit.MILLISECONDS);
        tmp.put("MILLISECONDS", (Object)TimeUnit.MILLISECONDS);
        tmp.put("S", (Object)TimeUnit.SECONDS);
        tmp.put("SEC", (Object)TimeUnit.SECONDS);
        tmp.put("SECOND", (Object)TimeUnit.SECONDS);
        tmp.put("SECONDS", (Object)TimeUnit.SECONDS);
        tmp.put("M", (Object)TimeUnit.MINUTES);
        tmp.put("MIN", (Object)TimeUnit.MINUTES);
        tmp.put("MINUTE", (Object)TimeUnit.MINUTES);
        tmp.put("MINUTES", (Object)TimeUnit.MINUTES);
        UNIT_MAP = Collections.unmodifiableMap(tmp);
        tmp = new HashMap();
        tmp.put((Object)TimeUnit.NANOSECONDS, "ns");
        tmp.put((Object)TimeUnit.MICROSECONDS, "\u03bcs");
        tmp.put((Object)TimeUnit.MILLISECONDS, "ms");
        tmp.put((Object)TimeUnit.SECONDS, "s");
        tmp.put((Object)TimeUnit.MINUTES, "m");
        TIME_UNIT_NAME = Collections.unmodifiableMap(tmp);
        tmp = new LinkedHashMap();
        tmp.put("start_time", new MetricExtractor((m, unit) -> m.startTime(), "s"));
        tmp.put("end_time", new MetricExtractor((m, unit) -> m.endTime(), "s"));
        tmp.put("rate", new MetricExtractor((m, unit) -> m.getCompletedPerSec(), "tuple/s"));
        tmp.put("mean", new MetricExtractor((m, unit) -> m.getMeanLatency((TimeUnit)((Object)unit))));
        tmp.put("99%ile", new MetricExtractor((m, unit) -> m.getLatencyAtPercentile(99.0, (TimeUnit)((Object)unit))));
        tmp.put("99.9%ile", new MetricExtractor((m, unit) -> m.getLatencyAtPercentile(99.9, (TimeUnit)((Object)unit))));
        tmp.put("cores", new MetricExtractor((m, unit) -> (m.getSysTime(TimeUnit.SECONDS) + m.getUserTime(TimeUnit.SECONDS)) / m.getTimeWindow(), ""));
        tmp.put("mem", new MetricExtractor((m, unit) -> m.getMemMb(), "MB"));
        tmp.put("failed", new MetricExtractor((m, unit) -> m.getFailed(), ""));
        tmp.put("median", new MetricExtractor((m, unit) -> m.getLatencyAtPercentile(50.0, (TimeUnit)((Object)unit))));
        tmp.put("min", new MetricExtractor((m, unit) -> m.getMinLatency((TimeUnit)((Object)unit))));
        tmp.put("max", new MetricExtractor((m, unit) -> m.getMaxLatency((TimeUnit)((Object)unit))));
        tmp.put("stddev", new MetricExtractor((m, unit) -> m.getLatencyStdDeviation((TimeUnit)((Object)unit))));
        tmp.put("user_cpu", new MetricExtractor((m, unit) -> m.getUserTime((TimeUnit)((Object)unit))));
        tmp.put("sys_cpu", new MetricExtractor((m, unit) -> m.getSysTime((TimeUnit)((Object)unit))));
        tmp.put("gc_cpu", new MetricExtractor((m, unit) -> m.getGc((TimeUnit)((Object)unit))));
        tmp.put("skipped_max_spout", new MetricExtractor((m, unit) -> m.getSkippedMaxSpout((TimeUnit)((Object)unit))));
        tmp.put("acked", new MetricExtractor((m, unit) -> m.getAcked(), ""));
        tmp.put("acked_rate", new MetricExtractor((m, unit) -> m.getAckedPerSec(), "tuple/s"));
        tmp.put("completed", new MetricExtractor((m, unit) -> m.getCompleted(), ""));
        tmp.put("uptime", new MetricExtractor((m, unit) -> m.getUptimeSecs(), "s"));
        tmp.put("time_window", new MetricExtractor((m, unit) -> m.getTimeWindow(), "s"));
        tmp.put("ids", new MetricExtractor((m, unit) -> m.getTopologyIds(), ""));
        tmp.put("congested", new MetricExtractor((m, unit) -> m.getCongested(), ""));
        tmp.put("workers", new MetricExtractor((m, unit) -> m.getWorkers(), ""));
        tmp.put("hosts", new MetricExtractor((m, unit) -> m.getHosts(), ""));
        tmp.put("executors", new MetricExtractor((m, unit) -> m.getExecutors(), ""));
        String buildVersion = VersionInfo.getBuildVersion();
        tmp.put("storm_version", new MetricExtractor((m, unit) -> buildVersion, ""));
        tmp.put("java_version", new MetricExtractor((m, unit) -> System.getProperty("java.vendor") + " " + System.getProperty("java.version"), ""));
        tmp.put("os_arch", new MetricExtractor((m, unit) -> System.getProperty("os.arch"), ""));
        tmp.put("os_name", new MetricExtractor((m, unit) -> System.getProperty("os.name"), ""));
        tmp.put("os_version", new MetricExtractor((m, unit) -> System.getProperty("os.version"), ""));
        tmp.put("config_override", new MetricExtractor((m, unit) -> Utils.readCommandLineOpts(), ""));
        tmp.put("ui_complete_latency", new MetricExtractor((m, unit) -> m.getUiCompleteLatency((TimeUnit)((Object)unit))));
        NAMED_EXTRACTORS = Collections.unmodifiableMap(tmp);
        REPORTER_PATTERN = Pattern.compile("(?<type>[^:?]+)(?::(?<path>[^?]+))?(?:\\?(?<query>.*))?");
    }

    static class MetricExtractor {
        private final String unit;
        private final BiFunction<Measurements, TimeUnit, Object> func;

        MetricExtractor(BiFunction<Measurements, TimeUnit, Object> func) {
            this.func = func;
            this.unit = null;
        }

        MetricExtractor(BiFunction<Measurements, TimeUnit, Object> func, String unit) {
            this.func = func;
            this.unit = unit;
        }

        public Object get(Measurements m, TimeUnit unit) {
            return this.func.apply(m, unit);
        }

        public String formatName(String name, TimeUnit targetUnit) {
            StringBuilder ret = new StringBuilder();
            ret.append(name);
            if (this.unit == null || !this.unit.isEmpty()) {
                ret.append("(");
                if (this.unit == null) {
                    ret.append(TIME_UNIT_NAME.get((Object)targetUnit));
                } else {
                    ret.append(this.unit);
                }
                ret.append(")");
            }
            return ret.toString();
        }
    }

    static class FixedWidthReporter
    extends ColumnsFileReporter {
        public final String longFormat;
        public final String stringFormat;

        FixedWidthReporter(String path, Map<String, String> query, Map<String, MetricExtractor> extractorsMap) throws FileNotFoundException {
            super(path, query, extractorsMap, "3");
            int columnWidth = Integer.parseInt(query.getOrDefault("columnWidth", "15")) - 1;
            this.doubleFormat = "%," + columnWidth + "." + this.precision + "f";
            this.longFormat = "%," + columnWidth + "d";
            this.stringFormat = "%" + columnWidth + "s";
        }

        FixedWidthReporter(Map<String, MetricExtractor> allExtractors) throws FileNotFoundException {
            this(null, Collections.emptyMap(), allExtractors);
        }

        @Override
        protected String format(Object o) {
            if (o instanceof Double || o instanceof Float) {
                return String.format(this.doubleFormat, o);
            }
            if (o instanceof Integer || o instanceof Long) {
                return String.format(this.longFormat, o);
            }
            return String.format(this.stringFormat, o);
        }

        @Override
        public void start() {
            boolean first = true;
            for (String name : this.extractors) {
                if (!first) {
                    this.out.print(" ");
                }
                first = false;
                this.out.print(this.format(((MetricExtractor)this.allExtractors.get(name)).formatName(name, this.targetUnit)));
            }
            if (this.meta != null) {
                this.out.print(" ");
                this.out.print(this.format("meta"));
            }
            this.out.println();
        }

        @Override
        public void reportWindow(Measurements m, List<Measurements> allTime) {
            boolean first = true;
            for (String name : this.extractors) {
                if (!first) {
                    this.out.print(" ");
                }
                first = false;
                this.out.print(this.format(((MetricExtractor)this.allExtractors.get(name)).get(m, this.targetUnit)));
            }
            if (this.meta != null) {
                this.out.print(" ");
                this.out.print(this.format(this.meta));
            }
            this.out.println();
        }
    }

    static class LegacyReporter
    extends FileReporter {
        private final TimeUnit targetUnitOverride;

        LegacyReporter(Map<String, MetricExtractor> allExtractors) throws FileNotFoundException {
            super(allExtractors);
            this.targetUnitOverride = null;
        }

        LegacyReporter(String path, Map<String, String> query, Map<String, MetricExtractor> allExtractors) throws FileNotFoundException {
            super(path, query, allExtractors);
            if (query.containsKey("time")) {
                this.targetUnitOverride = UNIT_MAP.get(query.get("time").toUpperCase());
                if (this.targetUnitOverride == null) {
                    throw new IllegalArgumentException(query.get("time") + " is not a supported time unit");
                }
            } else {
                this.targetUnitOverride = null;
            }
        }

        @Override
        public void reportWindow(Measurements m, List<Measurements> allTime) {
            TimeUnit nsOr = TimeUnit.NANOSECONDS;
            TimeUnit msOr = TimeUnit.MILLISECONDS;
            if (this.targetUnitOverride != null) {
                nsOr = this.targetUnitOverride;
                msOr = this.targetUnitOverride;
            }
            Measurements total = Measurements.combine(allTime, null, null);
            this.out.printf("uptime: %,4d acked: %,9d acked/sec: %,10.2f failed: %,8d 99%%: %,15.0f 99.9%%: %,15.0f min: %,15.0f max: %,15.0f mean: %,15.2f stddev: %,15.2f user: %,10.0f sys: %,10.0f gc: %,10.0f mem: %,10.2f\n", m.getUptimeSecs(), m.getAcked(), m.getAckedPerSec(), total.getFailed(), m.getLatencyAtPercentile(99.0, nsOr), m.getLatencyAtPercentile(99.9, nsOr), m.getMinLatency(nsOr), m.getMaxLatency(nsOr), m.getMeanLatency(nsOr), m.getLatencyStdDeviation(nsOr), m.getUserTime(msOr), m.getSysTime(msOr), m.getGc(msOr), m.getMemMb());
        }
    }

    static class SepValReporter
    extends ColumnsFileReporter {
        private final String separator;

        SepValReporter(String separator, String path, Map<String, String> query, Map<String, MetricExtractor> extractorsMap) throws FileNotFoundException {
            super(path, query, extractorsMap);
            this.separator = separator;
        }

        @Override
        public void start() {
            boolean first = true;
            for (String name : this.extractors) {
                if (!first) {
                    this.out.print(this.separator);
                }
                first = false;
                this.out.print(((MetricExtractor)this.allExtractors.get(name)).formatName(name, this.targetUnit));
            }
            if (this.meta != null) {
                this.out.print(this.separator);
                this.out.print("meta");
            }
            this.out.println();
        }

        @Override
        public void reportWindow(Measurements m, List<Measurements> allTime) {
            boolean first = true;
            for (String name : this.extractors) {
                if (!first) {
                    this.out.print(this.separator);
                }
                first = false;
                Object value = ((MetricExtractor)this.allExtractors.get(name)).get(m, this.targetUnit);
                String svalue = this.format(value);
                this.out.print(this.escape(svalue));
            }
            if (this.meta != null) {
                this.out.print(this.separator);
                this.out.print(this.escape(this.meta));
            }
            this.out.println();
        }

        private String escape(String svalue) {
            return svalue.replace("\\", "\\\\").replace(this.separator, "\\" + this.separator);
        }
    }

    static interface MetricResultsReporter {
        public void start();

        public void reportWindow(Measurements var1, List<Measurements> var2);

        public void finish(List<Measurements> var1) throws Exception;
    }

    static abstract class FileReporter
    implements MetricResultsReporter {
        protected final PrintStream out;
        protected final Map<String, MetricExtractor> allExtractors;
        public final boolean includesSysOutOrError;

        FileReporter(Map<String, MetricExtractor> allExtractors) throws FileNotFoundException {
            this(null, Collections.emptyMap(), allExtractors);
        }

        FileReporter(String path, Map<String, String> query, Map<String, MetricExtractor> allExtractors) throws FileNotFoundException {
            boolean append = Boolean.parseBoolean(query.getOrDefault("append", "false"));
            boolean tee = Boolean.parseBoolean(query.getOrDefault("tee", "false"));
            boolean includesSysOutOrError = false;
            OutputStream out = null;
            if (path == null || "/dev/stdout".equals(path)) {
                out = new NoCloseOutputStream(System.out);
                includesSysOutOrError = true;
                tee = false;
            } else if ("/dev/stderr".equals(path)) {
                out = new NoCloseOutputStream(System.err);
                includesSysOutOrError = true;
                tee = false;
            } else {
                out = new FileOutputStream(path, append);
            }
            if (tee) {
                out = new TeeOutputStream(new NoCloseOutputStream(System.out), out);
                includesSysOutOrError = true;
            }
            this.out = new PrintStream(out);
            this.allExtractors = new LinkedHashMap<String, MetricExtractor>(allExtractors);
            this.includesSysOutOrError = includesSysOutOrError;
        }

        @Override
        public void start() {
        }

        @Override
        public void finish(List<Measurements> allTime) throws Exception {
            if (this.out != null) {
                this.out.close();
            }
        }
    }

    private static class MemMeasure {
        private long mem = 0L;
        private long time = 0L;

        private MemMeasure() {
        }

        synchronized void update(long mem) {
            this.mem = mem;
            this.time = System.currentTimeMillis();
        }

        public synchronized long get() {
            return this.isExpired() ? 0L : this.mem;
        }

        synchronized boolean isExpired() {
            return System.currentTimeMillis() - this.time >= 20000L;
        }
    }

    public static class Measurements {
        private final Histogram histo;
        private double uiCompleteLatency;
        private long skippedMaxSpoutMs;
        private double userMs;
        private double sysMs;
        private double gcMs;
        private long memBytes;
        private long uptimeSecs;
        private long timeWindow;
        private long acked;
        private long failed;
        private Set<String> topologyIds;
        private long workers;
        private long executors;
        private long hosts;
        private Map<String, String> congested;

        public Measurements(long uptimeSecs, long acked, long timeWindow, long failed, Histogram histo, double userMs, double sysMs, double gcMs, long memBytes, Set<String> topologyIds, long workers, long executors, long hosts, Map<String, String> congested, long skippedMaxSpoutMs, double uiCompleteLatency) {
            this.uptimeSecs = uptimeSecs;
            this.acked = acked;
            this.timeWindow = timeWindow;
            this.failed = failed;
            this.userMs = userMs;
            this.sysMs = sysMs;
            this.gcMs = gcMs;
            this.histo = histo;
            this.memBytes = memBytes;
            this.topologyIds = topologyIds;
            this.workers = workers;
            this.executors = executors;
            this.hosts = hosts;
            this.congested = congested;
            this.skippedMaxSpoutMs = skippedMaxSpoutMs;
            this.uiCompleteLatency = uiCompleteLatency;
        }

        public Measurements() {
            this.histo = new Histogram(3600000000000L, 3);
            this.sysMs = 0.0;
            this.userMs = 0.0;
            this.gcMs = 0.0;
            this.memBytes = 0L;
            this.uptimeSecs = 0L;
            this.timeWindow = 0L;
            this.acked = 0L;
            this.failed = 0L;
            this.topologyIds = new HashSet<String>();
            this.workers = 0L;
            this.executors = 0L;
            this.hosts = 0L;
            this.congested = new HashMap<String, String>();
            this.skippedMaxSpoutMs = 0L;
            this.uiCompleteLatency = 0.0;
        }

        public void add(Measurements other) {
            this.histo.add(other.histo);
            this.sysMs += other.sysMs;
            this.userMs += other.userMs;
            this.gcMs += other.gcMs;
            this.memBytes = Math.max(this.memBytes, other.memBytes);
            this.acked += other.acked;
            this.failed += other.failed;
            this.uptimeSecs = Math.max(this.uptimeSecs, other.uptimeSecs);
            this.timeWindow += other.timeWindow;
            this.topologyIds.addAll(other.topologyIds);
            this.workers = Math.max(this.workers, other.workers);
            this.executors = Math.max(this.executors, other.executors);
            this.hosts = Math.max(this.hosts, other.hosts);
            this.congested.putAll(other.congested);
            this.skippedMaxSpoutMs += other.skippedMaxSpoutMs;
            this.uiCompleteLatency = Math.max(this.uiCompleteLatency, other.uiCompleteLatency);
        }

        public double getLatencyAtPercentile(double percential, TimeUnit unit) {
            return LoadMetricsServer.convert(this.histo.getValueAtPercentile(percential), TimeUnit.NANOSECONDS, unit);
        }

        public double getMinLatency(TimeUnit unit) {
            return LoadMetricsServer.convert(this.histo.getMinValue(), TimeUnit.NANOSECONDS, unit);
        }

        public double getMaxLatency(TimeUnit unit) {
            return LoadMetricsServer.convert(this.histo.getMaxValue(), TimeUnit.NANOSECONDS, unit);
        }

        public double getMeanLatency(TimeUnit unit) {
            return LoadMetricsServer.convert(this.histo.getMean(), TimeUnit.NANOSECONDS, unit);
        }

        public double getLatencyStdDeviation(TimeUnit unit) {
            return LoadMetricsServer.convert(this.histo.getStdDeviation(), TimeUnit.NANOSECONDS, unit);
        }

        public double getUiCompleteLatency(TimeUnit unit) {
            return LoadMetricsServer.convert(this.uiCompleteLatency, TimeUnit.MILLISECONDS, unit);
        }

        public double getUserTime(TimeUnit unit) {
            return LoadMetricsServer.convert(this.userMs, TimeUnit.MILLISECONDS, unit);
        }

        public double getSysTime(TimeUnit unit) {
            return LoadMetricsServer.convert(this.sysMs, TimeUnit.MILLISECONDS, unit);
        }

        public double getGc(TimeUnit unit) {
            return LoadMetricsServer.convert(this.gcMs, TimeUnit.MILLISECONDS, unit);
        }

        public double getSkippedMaxSpout(TimeUnit unit) {
            return LoadMetricsServer.convert(this.skippedMaxSpoutMs, TimeUnit.MILLISECONDS, unit);
        }

        public double getMemMb() {
            return (double)this.memBytes / 1048576.0;
        }

        public long getUptimeSecs() {
            return this.uptimeSecs;
        }

        public long getCompleted() {
            return this.histo.getTotalCount();
        }

        public double getCompletedPerSec() {
            return (double)this.getCompleted() / (double)this.timeWindow;
        }

        public long getAcked() {
            return this.acked;
        }

        public double getAckedPerSec() {
            return (double)this.acked / (double)this.timeWindow;
        }

        public long getFailed() {
            return this.failed;
        }

        public long startTime() {
            return this.uptimeSecs - this.timeWindow;
        }

        public long endTime() {
            return this.uptimeSecs;
        }

        public double getTimeWindow() {
            return this.timeWindow;
        }

        public Set<String> getTopologyIds() {
            return this.topologyIds;
        }

        public long getWorkers() {
            return this.workers;
        }

        public long getHosts() {
            return this.hosts;
        }

        public long getExecutors() {
            return this.executors;
        }

        public Map<String, String> getCongested() {
            return this.congested;
        }

        static Measurements combine(List<Measurements> measurements, Integer start, Integer count) {
            if (count == null) {
                count = measurements.size();
            }
            if (start == null) {
                start = measurements.size() - count;
            }
            start = Math.max(0, start);
            count = Math.min(count, measurements.size() - start);
            Measurements ret = new Measurements();
            for (int i = start.intValue(); i < start + count; ++i) {
                ret.add(measurements.get(i));
            }
            return ret;
        }
    }

    static abstract class ColumnsFileReporter
    extends FileReporter {
        protected final TimeUnit targetUnit;
        protected final List<String> extractors;
        protected final String meta;
        protected final int precision;
        protected String doubleFormat;

        ColumnsFileReporter(String path, Map<String, String> query, Map<String, MetricExtractor> extractorsMap) throws FileNotFoundException {
            this(path, query, extractorsMap, null);
        }

        ColumnsFileReporter(String path, Map<String, String> query, Map<String, MetricExtractor> extractorsMap, String defaultPreceision) throws FileNotFoundException {
            super(path, query, extractorsMap);
            String strPrecision;
            this.targetUnit = UNIT_MAP.get(query.getOrDefault("time", "MILLISECONDS").toUpperCase());
            if (this.targetUnit == null) {
                throw new IllegalArgumentException(query.get("time") + " is not a supported time unit");
            }
            if (query.containsKey("columns")) {
                List<String> extractors = this.handleExtractorCleanup(Arrays.asList(query.get("columns").split("\\s*,\\s*")));
                HashSet<String> notFound = new HashSet<String>(extractors);
                notFound.removeAll(this.allExtractors.keySet());
                if (notFound.size() > 0) {
                    throw new IllegalArgumentException(String.valueOf(notFound) + " columns are not supported");
                }
                this.extractors = extractors;
            } else {
                this.extractors = new ArrayList<String>(Arrays.asList("start_time", "end_time", "rate", "mean", "99%ile", "99.9%ile", "cores", "mem", "failed", "ids", "congested"));
            }
            if (query.containsKey("extraColumns")) {
                List<String> moreExtractors = this.handleExtractorCleanup(Arrays.asList(query.get("extraColumns").split("\\s*,\\s*")));
                for (String extractor : moreExtractors) {
                    if (!this.allExtractors.containsKey(extractor)) {
                        throw new IllegalArgumentException(extractor + " is not a supported column");
                    }
                    if (this.extractors.contains(extractor)) continue;
                    this.extractors.add(extractor);
                }
            }
            if ((strPrecision = query.getOrDefault("precision", defaultPreceision)) == null) {
                this.precision = -1;
                this.doubleFormat = "%f";
            } else {
                this.precision = Integer.parseInt(strPrecision);
                this.doubleFormat = "%." + this.precision + "f";
            }
            this.meta = query.get("meta");
        }

        protected List<String> handleExtractorCleanup(List<String> orig) {
            Map stormConfig = Utils.readStormConfig();
            ArrayList<String> ret = new ArrayList<String>(orig.size());
            for (String extractor : orig) {
                if (extractor.startsWith("conf:")) {
                    String confKey = extractor.substring("conf:".length());
                    Object confValue = stormConfig.get(confKey);
                    this.allExtractors.put(extractor, new MetricExtractor((m, t) -> confValue, ""));
                    ret.add(extractor);
                    continue;
                }
                if (extractor.endsWith("%ile")) {
                    double number = Double.valueOf(extractor.substring(0, extractor.length() - "%ile".length()));
                    this.allExtractors.put(extractor, new MetricExtractor((m, t) -> m.getLatencyAtPercentile(number, (TimeUnit)((Object)t))));
                    ret.add(extractor);
                    continue;
                }
                if ("*".equals(extractor)) {
                    ret.addAll(this.allExtractors.keySet());
                    continue;
                }
                ret.add(extractor);
            }
            return ret;
        }

        protected String format(Object o) {
            if (o instanceof Double || o instanceof Float) {
                return String.format(this.doubleFormat, o);
            }
            return o == null ? "" : o.toString();
        }
    }

    private static class NoCloseOutputStream
    extends FilterOutputStream {
        NoCloseOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void close() {
        }
    }
}

