/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.loadgen;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.generated.Grouping;
import org.apache.storm.grouping.PartialKeyGrouping;
import org.apache.storm.loadgen.GroupingType;
import org.apache.storm.loadgen.NormalDistStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStream
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(InputStream.class);
    public final String fromComponent;
    public final String toComponent;
    public final String id;
    public final NormalDistStats execTime;
    public final NormalDistStats processTime;
    public final GroupingType groupingType;
    private GlobalStreamId gsid = null;

    public static InputStream fromConf(Map<String, Object> conf) {
        String component = (String)conf.get("from");
        String toComp = (String)conf.get("to");
        NormalDistStats execTime = NormalDistStats.fromConf((Map)conf.get("execTime"));
        NormalDistStats processTime = NormalDistStats.fromConf((Map)conf.get("processTime"));
        Map grouping = (Map)conf.get("grouping");
        GroupingType groupingType = GroupingType.fromConf((String)grouping.get("type"));
        String streamId = grouping.getOrDefault("streamId", "default");
        return new InputStream(component, toComp, streamId, execTime, processTime, groupingType);
    }

    public Map<String, Object> toConf() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("from", this.fromComponent);
        ret.put("to", this.toComponent);
        ret.put("execTime", this.execTime.toConf());
        ret.put("processTime", this.processTime.toConf());
        HashMap<String, String> grouping = new HashMap<String, String>();
        grouping.put("streamId", this.id);
        grouping.put("type", this.groupingType.toConf());
        ret.put("grouping", grouping);
        return ret;
    }

    public InputStream(String fromComponent, String toComponent, String id, NormalDistStats execTime, NormalDistStats processTime, GroupingType groupingType) {
        this.fromComponent = fromComponent;
        this.toComponent = toComponent;
        if (fromComponent == null) {
            throw new IllegalArgumentException("from cannot be null");
        }
        if (toComponent == null) {
            throw new IllegalArgumentException("to cannot be null");
        }
        this.id = id;
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.execTime = execTime;
        this.processTime = processTime;
        this.groupingType = groupingType;
        if (groupingType == null) {
            throw new IllegalArgumentException("grouping type cannot be null");
        }
    }

    public synchronized GlobalStreamId gsid() {
        if (this.gsid == null) {
            this.gsid = new GlobalStreamId(this.fromComponent, this.id);
        }
        return this.gsid;
    }

    public InputStream remap(Map<String, String> remappedComponents, Map<GlobalStreamId, GlobalStreamId> remappedStreams) {
        String remapTo = remappedComponents.get(this.toComponent);
        String remapFrom = remappedComponents.get(this.fromComponent);
        GlobalStreamId remapStreamId = remappedStreams.get(this.gsid());
        return new InputStream(remapFrom, remapTo, remapStreamId.get_streamId(), this.execTime, this.processTime, this.groupingType);
    }

    public InputStream replaceShuffleWithLocalOrShuffle() {
        if (this.groupingType != GroupingType.SHUFFLE) {
            return this;
        }
        return new InputStream(this.fromComponent, this.toComponent, this.id, this.execTime, this.processTime, GroupingType.LOCAL_OR_SHUFFLE);
    }

    public static class Builder {
        private String fromComponent;
        private String toComponent;
        private String id;
        private NormalDistStats execTime;
        private NormalDistStats processTime;
        private GroupingType groupingType = GroupingType.SHUFFLE;

        public String getFromComponent() {
            return this.fromComponent;
        }

        public Builder withFromComponent(String fromComponent) {
            this.fromComponent = fromComponent;
            return this;
        }

        public String getToComponent() {
            return this.toComponent;
        }

        public Builder withToComponent(String toComponent) {
            this.toComponent = toComponent;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public NormalDistStats getExecTime() {
            return this.execTime;
        }

        public Builder withExecTime(NormalDistStats execTime) {
            this.execTime = execTime;
            return this;
        }

        public NormalDistStats getProcessTime() {
            return this.processTime;
        }

        public Builder withProcessTime(NormalDistStats processTime) {
            this.processTime = processTime;
            return this;
        }

        public GroupingType getGroupingType() {
            return this.groupingType;
        }

        public Builder withGroupingType(GroupingType groupingType) {
            this.groupingType = groupingType;
            return this;
        }

        public Builder withGroupingType(Grouping grouping) {
            GroupingType group = GroupingType.SHUFFLE;
            Grouping._Fields thriftType = (Grouping._Fields)grouping.getSetField();
            switch (thriftType) {
                case FIELDS: {
                    if (grouping.get_fields().isEmpty()) {
                        group = GroupingType.GLOBAL;
                        break;
                    }
                    group = GroupingType.FIELDS;
                    break;
                }
                case ALL: {
                    group = GroupingType.ALL;
                    break;
                }
                case NONE: {
                    group = GroupingType.NONE;
                    break;
                }
                case SHUFFLE: {
                    group = GroupingType.SHUFFLE;
                    break;
                }
                case LOCAL_OR_SHUFFLE: {
                    group = GroupingType.LOCAL_OR_SHUFFLE;
                    break;
                }
                case CUSTOM_SERIALIZED: {
                    byte[] data = grouping.get_custom_serialized();
                    try (ByteArrayInputStream bis = new ByteArrayInputStream(data);
                         ObjectInputStream ois = new ObjectInputStream(bis);){
                        Object cg = ois.readObject();
                        if (cg instanceof PartialKeyGrouping) {
                            group = GroupingType.PARTIAL_KEY;
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                default: {
                    LOG.warn("{} is not supported for replay of a topology.  Using SHUFFLE", (Object)thriftType);
                }
            }
            return this.withGroupingType(group);
        }

        public InputStream build() {
            return new InputStream(this.fromComponent, this.toComponent, this.id, this.execTime, this.processTime, this.groupingType);
        }
    }
}

