/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.loadgen;

import com.esotericsoftware.kryo.io.Output;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.storm.metric.api.IMetricsConsumer;
import org.apache.storm.serialization.KryoValuesSerializer;
import org.apache.storm.task.IErrorReporter;
import org.apache.storm.task.TopologyContext;

public class HttpForwardingMetricsConsumer
implements IMetricsConsumer {
    private transient URL url;
    private transient IErrorReporter errorReporter;
    private transient KryoValuesSerializer serializer;
    private transient String topologyId;

    public void prepare(Map<String, Object> topoConf, Object registrationArgument, TopologyContext context, IErrorReporter errorReporter) {
        try {
            this.url = new URL((String)registrationArgument);
            this.errorReporter = errorReporter;
            this.serializer = new KryoValuesSerializer(topoConf);
            this.topologyId = context.getStormId();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void handleDataPoints(IMetricsConsumer.TaskInfo taskInfo, Collection<IMetricsConsumer.DataPoint> dataPoints) {
        try {
            HttpURLConnection con = (HttpURLConnection)this.url.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            try (Output out = new Output(con.getOutputStream());){
                this.serializer.serializeInto(Arrays.asList(taskInfo, dataPoints, this.topologyId), out);
                out.flush();
            }
            int n = con.getResponseCode();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void cleanup() {
    }
}

