/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.loadgen;

import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.apache.storm.loadgen.InputStream;
import org.apache.storm.loadgen.SlowExecutorPattern;

public class ExecAndProcessLatencyEngine
implements Serializable {
    private static final long NANO_IN_MS = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS);
    private final SlowExecutorPattern skewedPattern;
    private final AtomicLong parkOffset = new AtomicLong(0L);
    private Random rand;
    private ScheduledExecutorService timer;

    public static long toNano(double ms) {
        return (long)(ms * (double)NANO_IN_MS);
    }

    public ExecAndProcessLatencyEngine() {
        this(null);
    }

    public ExecAndProcessLatencyEngine(SlowExecutorPattern skewedPattern) {
        this.skewedPattern = skewedPattern;
    }

    public void prepare() {
        this.rand = ThreadLocalRandom.current();
        this.timer = Executors.newSingleThreadScheduledExecutor();
    }

    public void sleepNano(long start, long sleepAmount) {
        long endTime = start + sleepAmount;
        long newEnd = endTime - this.parkOffset.get();
        long diff = newEnd - start;
        if (diff > 1000L) {
            if (diff < NANO_IN_MS) {
                long sum = 0L;
                while (System.nanoTime() < newEnd) {
                    for (long i = 0L; i < 1000000L; ++i) {
                        sum += i;
                    }
                }
            } else {
                LockSupport.parkNanos(newEnd - System.nanoTime());
            }
        }
        this.parkOffset.addAndGet((System.nanoTime() - endTime) / 2L);
    }

    public void sleepNano(long nano) {
        this.sleepNano(System.nanoTime(), nano);
    }

    public void sleepUntilNano(long endTime) {
        long start = System.nanoTime();
        this.sleepNano(start, endTime - start);
    }

    public void simulateProcessAndExecTime(int executorIndex, long startTimeNs, InputStream in, Runnable r) {
        long endExecNs;
        long extraTimeNs = this.skewedPattern == null ? 0L : ExecAndProcessLatencyEngine.toNano(this.skewedPattern.getExtraSlowness(executorIndex));
        long endProcNs = startTimeNs + extraTimeNs + (in == null ? 0L : ExecAndProcessLatencyEngine.toNano(in.processTime.nextRandom(this.rand)));
        if (endProcNs - 1000000L < (endExecNs = startTimeNs + extraTimeNs + (in == null ? 0L : ExecAndProcessLatencyEngine.toNano(in.execTime.nextRandom(this.rand))))) {
            this.sleepUntilNano(endProcNs);
            r.run();
        } else {
            this.timer.schedule(() -> r.run(), Math.max(0L, endProcNs - System.nanoTime()), TimeUnit.NANOSECONDS);
        }
        this.sleepUntilNano(endExecNs);
    }
}

