/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import java.util.concurrent.Executor;
import org.apache.curator.drivers.OperationTrace;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.api.SyncBuilder;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.curator.framework.imps.Backgrounding;
import org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.curator.framework.imps.CuratorFrameworkBase;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.zookeeper.AsyncCallback;

public class SyncBuilderImpl
implements SyncBuilder,
BackgroundOperation<String>,
ErrorListenerPathable<Void> {
    private final CuratorFrameworkBase client;
    private Backgrounding backgrounding = new Backgrounding();

    public SyncBuilderImpl(CuratorFrameworkBase client) {
        this.client = client;
    }

    public SyncBuilderImpl(CuratorFrameworkBase client, Backgrounding backgrounding) {
        this.client = client;
        this.backgrounding = backgrounding;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground() {
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public Pathable<Void> withUnhandledErrorListener(UnhandledErrorListener listener) {
        this.backgrounding = new Backgrounding(this.backgrounding, listener);
        return this;
    }

    @Override
    public CuratorEventType getBackgroundEventType() {
        return CuratorEventType.SYNC;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        try {
            final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("SyncBuilderImpl-Background");
            String path = operationAndData.getData();
            String adjustedPath = this.client.fixForNamespace(path);
            AsyncCallback.VoidCallback voidCallback = new AsyncCallback.VoidCallback(){
                final /* synthetic */ SyncBuilderImpl this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void processResult(int rc, String path, Object ctx) {
                    trace.setReturnCode(rc).setPath(path).commit();
                    CuratorEventImpl event = new CuratorEventImpl(this.this$0.client, CuratorEventType.SYNC, rc, path, path, ctx, null, null, null, null, null, null);
                    this.this$0.client.processBackgroundOperation(operationAndData, event);
                }
            };
            this.client.getZooKeeper().sync(adjustedPath, voidCallback, this.backgrounding.getContext());
        }
        catch (Throwable e) {
            this.backgrounding.checkError(e, null);
        }
    }

    @Override
    public Void forPath(String path) throws Exception {
        OperationAndData<String> operationAndData = new OperationAndData<String>(this, path, this.backgrounding.getCallback(), null, this.backgrounding.getContext(), null);
        this.client.processBackgroundOperation(operationAndData, null);
        return null;
    }
}

