/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.curator.RetryLoop;
import org.apache.curator.drivers.OperationTrace;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.BackgroundVersionable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.DeleteBuilder;
import org.apache.curator.framework.api.DeleteBuilderMain;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.framework.api.transaction.OperationType;
import org.apache.curator.framework.api.transaction.TransactionDeleteBuilder;
import org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.curator.framework.imps.Backgrounding;
import org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.curator.framework.imps.CuratorFrameworkBase;
import org.apache.curator.framework.imps.CuratorMultiTransactionRecord;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.curator.utils.ThreadUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;

public class DeleteBuilderImpl
implements DeleteBuilder,
BackgroundOperation<String>,
ErrorListenerPathable<Void> {
    private final CuratorFrameworkBase client;
    private int version;
    private Backgrounding backgrounding;
    private boolean deletingChildrenIfNeeded;
    private boolean guaranteed;
    private boolean quietly;
    @VisibleForTesting
    boolean failNextDeleteForTesting = false;
    @VisibleForTesting
    boolean failBeforeNextDeleteForTesting = false;

    DeleteBuilderImpl(CuratorFrameworkBase client) {
        this.client = client;
        this.version = -1;
        this.backgrounding = new Backgrounding();
        this.deletingChildrenIfNeeded = false;
        this.guaranteed = false;
        this.quietly = false;
    }

    public DeleteBuilderImpl(CuratorFrameworkBase client, int version, Backgrounding backgrounding, boolean deletingChildrenIfNeeded, boolean guaranteed, boolean quietly) {
        this.client = client;
        this.version = version;
        this.backgrounding = backgrounding;
        this.deletingChildrenIfNeeded = deletingChildrenIfNeeded;
        this.guaranteed = guaranteed;
        this.quietly = quietly;
    }

    <T> TransactionDeleteBuilder<T> asTransactionDeleteBuilder(final T context, final CuratorMultiTransactionRecord transaction) {
        return new TransactionDeleteBuilder<T>(){
            final /* synthetic */ DeleteBuilderImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public T forPath(String path) throws Exception {
                String fixedPath = this.this$0.client.fixForNamespace(path);
                transaction.add(Op.delete(fixedPath, this.this$0.version), OperationType.DELETE, path);
                return context;
            }

            @Override
            public Pathable<T> withVersion(int version) {
                this.this$0.withVersion(version);
                return this;
            }
        };
    }

    @Override
    public DeleteBuilderMain quietly() {
        this.quietly = true;
        return this;
    }

    @Override
    public DeleteBuilderMain idempotent() {
        return this.quietly();
    }

    @Override
    public ChildrenDeletable guaranteed() {
        this.guaranteed = true;
        return this;
    }

    @Override
    public BackgroundVersionable deletingChildrenIfNeeded() {
        this.deletingChildrenIfNeeded = true;
        return this;
    }

    @Override
    public BackgroundPathable<Void> withVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public Pathable<Void> withUnhandledErrorListener(UnhandledErrorListener listener) {
        this.backgrounding = new Backgrounding(this.backgrounding, listener);
        return this;
    }

    @Override
    public CuratorEventType getBackgroundEventType() {
        return CuratorEventType.DELETE;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        try {
            final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("DeleteBuilderImpl-Background");
            this.client.getZooKeeper().delete(operationAndData.getData(), this.version, new AsyncCallback.VoidCallback(){
                final /* synthetic */ DeleteBuilderImpl this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void processResult(int rc, String path, Object ctx) {
                    trace.setReturnCode(rc).setPath(path).commit();
                    if (rc == KeeperException.Code.OK.intValue() && this.this$0.failNextDeleteForTesting) {
                        this.this$0.failNextDeleteForTesting = false;
                        rc = KeeperException.Code.CONNECTIONLOSS.intValue();
                    }
                    if (rc == KeeperException.Code.NOTEMPTY.intValue() && this.this$0.deletingChildrenIfNeeded) {
                        this.this$0.backgroundDeleteChildrenThenNode(operationAndData);
                    } else {
                        if (rc == KeeperException.Code.NONODE.intValue() && this.this$0.quietly) {
                            rc = KeeperException.Code.OK.intValue();
                        }
                        CuratorEventImpl event = new CuratorEventImpl(this.this$0.client, CuratorEventType.DELETE, rc, path, null, ctx, null, null, null, null, null, null);
                        this.this$0.client.processBackgroundOperation(operationAndData, event);
                    }
                }
            }, this.backgrounding.getContext());
        }
        catch (Throwable e) {
            this.backgrounding.checkError(e, null);
        }
    }

    private void backgroundDeleteChildrenThenNode(final OperationAndData<String> mainOperationAndData) {
        BackgroundOperation<String> operation = new BackgroundOperation<String>(){
            final /* synthetic */ DeleteBuilderImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void performBackgroundOperation(OperationAndData<String> dummy) throws Exception {
                try {
                    ZKPaths.deleteChildren(this.this$0.client.getZooKeeper(), (String)mainOperationAndData.getData(), false);
                }
                catch (KeeperException keeperException) {
                    // empty catch block
                }
                this.this$0.client.queueOperation(mainOperationAndData);
            }

            @Override
            public CuratorEventType getBackgroundEventType() {
                return CuratorEventType.DELETE;
            }
        };
        OperationAndData<String> parentOperation = new OperationAndData<String>(operation, mainOperationAndData);
        this.client.queueOperation(parentOperation);
    }

    @Override
    public Void forPath(String path) throws Exception {
        this.client.getSchemaSet().getSchema(path).validateDelete(path);
        final String unfixedPath = path;
        path = this.client.fixForNamespace(path);
        if (this.backgrounding.inBackground()) {
            OperationAndData.ErrorCallback<String> errorCallback = null;
            if (this.guaranteed) {
                errorCallback = new OperationAndData.ErrorCallback<String>(){
                    final /* synthetic */ DeleteBuilderImpl this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void retriesExhausted(OperationAndData<String> operationAndData) {
                        this.this$0.client.getFailedDeleteManager().addFailedOperation(unfixedPath);
                    }
                };
            }
            OperationAndData<String> operationAndData = new OperationAndData<String>((BackgroundOperation)this, path, this.backgrounding.getCallback(), (OperationAndData.ErrorCallback)errorCallback, this.backgrounding.getContext(), null){

                @Override
                void callPerformBackgroundOperation() throws Exception {
                    if (DeleteBuilderImpl.this.failBeforeNextDeleteForTesting) {
                        DeleteBuilderImpl.this.failBeforeNextDeleteForTesting = false;
                        throw new KeeperException.ConnectionLossException();
                    }
                    super.callPerformBackgroundOperation();
                }
            };
            this.client.processBackgroundOperation(operationAndData, null);
        } else {
            this.pathInForeground(path, unfixedPath);
        }
        return null;
    }

    protected int getVersion() {
        return this.version;
    }

    private void pathInForeground(final String path, String unfixedPath) throws Exception {
        OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("DeleteBuilderImpl-Foreground");
        try {
            RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<Void>(){
                final /* synthetic */ DeleteBuilderImpl this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Void call() throws Exception {
                    if (this.this$0.failBeforeNextDeleteForTesting) {
                        this.this$0.failBeforeNextDeleteForTesting = false;
                        throw new KeeperException.ConnectionLossException();
                    }
                    try {
                        this.this$0.client.getZooKeeper().delete(path, this.this$0.version);
                    }
                    catch (KeeperException.NoNodeException e) {
                        if (!this.this$0.quietly) {
                            throw e;
                        }
                    }
                    catch (KeeperException.NotEmptyException e) {
                        if (this.this$0.deletingChildrenIfNeeded) {
                            ZKPaths.deleteChildren(this.this$0.client.getZooKeeper(), path, true);
                        }
                        throw e;
                    }
                    if (this.this$0.failNextDeleteForTesting) {
                        this.this$0.failNextDeleteForTesting = false;
                        throw new KeeperException.ConnectionLossException();
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted(e);
            if ((this.client.getZookeeperClient().getRetryPolicy().allowRetry(e) || e instanceof InterruptedException) && this.guaranteed) {
                this.client.getFailedDeleteManager().addFailedOperation(unfixedPath);
            }
            throw e;
        }
        trace.setPath(path).commit();
    }
}

