/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.io.Serializable;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;

public class KafkaSpoutMessageId
implements Serializable {
    private final TopicPartition topicPart;
    private final long offset;
    private int numFails = 0;
    private boolean nullTuple;

    public KafkaSpoutMessageId(ConsumerRecord<?, ?> consumerRecord) {
        this(consumerRecord, false);
    }

    public KafkaSpoutMessageId(ConsumerRecord<?, ?> consumerRecord, boolean nullTuple) {
        this(new TopicPartition(consumerRecord.topic(), consumerRecord.partition()), consumerRecord.offset(), nullTuple);
    }

    public KafkaSpoutMessageId(TopicPartition topicPart, long offset) {
        this(topicPart, offset, false);
    }

    public KafkaSpoutMessageId(TopicPartition topicPart, long offset, boolean nullTuple) {
        this.topicPart = topicPart;
        this.offset = offset;
        this.nullTuple = nullTuple;
    }

    public int partition() {
        return this.topicPart.partition();
    }

    public String topic() {
        return this.topicPart.topic();
    }

    public long offset() {
        return this.offset;
    }

    public int numFails() {
        return this.numFails;
    }

    public void incrementNumFails() {
        ++this.numFails;
    }

    public TopicPartition getTopicPartition() {
        return this.topicPart;
    }

    public boolean isNullTuple() {
        return this.nullTuple;
    }

    public void setNullTuple(boolean nullTuple) {
        this.nullTuple = nullTuple;
    }

    public String toString() {
        return "{topic-partition=" + String.valueOf(this.topicPart) + ", offset=" + this.offset + ", numFails=" + this.numFails + ", nullTuple=" + this.nullTuple + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaSpoutMessageId messageId = (KafkaSpoutMessageId)o;
        if (this.offset != messageId.offset) {
            return false;
        }
        return this.topicPart.equals((Object)messageId.topicPart);
    }

    public int hashCode() {
        int result = this.topicPart.hashCode();
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        return result;
    }
}

