/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout.trident;

import java.util.List;
import java.util.Map;
import org.apache.storm.kafka.spout.trident.KafkaTridentOpaqueSpoutEmitter;
import org.apache.storm.kafka.spout.trident.KafkaTridentSpoutConfig;
import org.apache.storm.kafka.spout.trident.KafkaTridentSpoutCoordinator;
import org.apache.storm.kafka.spout.trident.KafkaTridentSpoutEmitter;
import org.apache.storm.kafka.spout.trident.KafkaTridentSpoutTopicPartition;
import org.apache.storm.kafka.spout.trident.internal.OutputFieldsExtractor;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.trident.spout.IOpaquePartitionedTridentSpout;
import org.apache.storm.tuple.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTridentSpoutOpaque<K, V>
implements IOpaquePartitionedTridentSpout<List<Map<String, Object>>, KafkaTridentSpoutTopicPartition, Map<String, Object>> {
    private static final long serialVersionUID = -8003272486566259640L;
    private static final Logger LOG = LoggerFactory.getLogger(KafkaTridentSpoutOpaque.class);
    private final KafkaTridentSpoutConfig<K, V> kafkaSpoutConfig;
    private final OutputFieldsExtractor outputFieldsExtractor;

    public KafkaTridentSpoutOpaque(KafkaTridentSpoutConfig<K, V> kafkaSpoutConfig) {
        this.kafkaSpoutConfig = kafkaSpoutConfig;
        this.outputFieldsExtractor = new OutputFieldsExtractor();
        LOG.debug("Created {}", (Object)this.toString());
    }

    public IOpaquePartitionedTridentSpout.Emitter<List<Map<String, Object>>, KafkaTridentSpoutTopicPartition, Map<String, Object>> getEmitter(Map<String, Object> conf, TopologyContext context) {
        return new KafkaTridentOpaqueSpoutEmitter<K, V>(new KafkaTridentSpoutEmitter<K, V>(this.kafkaSpoutConfig, context));
    }

    public IOpaquePartitionedTridentSpout.Coordinator<List<Map<String, Object>>> getCoordinator(Map<String, Object> conf, TopologyContext context) {
        return new KafkaTridentSpoutCoordinator<K, V>(this.kafkaSpoutConfig);
    }

    public Map<String, Object> getComponentConfiguration() {
        return null;
    }

    public Fields getOutputFields() {
        Fields outputFields = this.outputFieldsExtractor.getOutputFields(this.kafkaSpoutConfig);
        LOG.debug("OutputFields = {}", (Object)outputFields);
        return outputFields;
    }

    public final String toString() {
        return super.toString() + "{kafkaSpoutConfig=" + String.valueOf(this.kafkaSpoutConfig) + "}";
    }
}

