/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.bolt.rotation;

import org.apache.storm.hdfs.bolt.rotation.FileRotationPolicy;
import org.apache.storm.tuple.Tuple;

public class TimedRotationPolicy
implements FileRotationPolicy {
    private long interval;

    public TimedRotationPolicy(float count, TimeUnit units) {
        this.interval = (long)(count * (float)units.getMilliSeconds());
    }

    protected TimedRotationPolicy(long interval) {
        this.interval = interval;
    }

    @Override
    public boolean mark(Tuple tuple, long offset) {
        return false;
    }

    @Override
    public void reset() {
    }

    @Override
    public FileRotationPolicy copy() {
        return new TimedRotationPolicy(this.interval);
    }

    public long getInterval() {
        return this.interval;
    }

    public static enum TimeUnit {
        SECONDS(1000L),
        MINUTES(60000L),
        HOURS(3600000L),
        DAYS(86400000L);

        private long milliSeconds;

        private TimeUnit(long milliSeconds) {
            this.milliSeconds = milliSeconds;
        }

        public long getMilliSeconds() {
            return this.milliSeconds;
        }
    }
}

