/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.ontologymanager.servicesapi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.stanbol.commons.owl.util.URIUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class OntologyUtils {
    private static String[] preferredFormats = new String[]{"application/rdf+xml", "text/turtle", "application/x-turtle", "application/rdf+json", "text/rdf+n3", "text/rdf+nt", "text/owl-manchester", "text/owl-functional", "application/owl+xml"};

    public static OWLOntologyID decode(String stringForm) {
        if (stringForm == null || stringForm.isEmpty()) {
            throw new IllegalArgumentException("Supplied string form must be non-null and non-empty.");
        }
        String[] split = stringForm.split(":::");
        if (split.length >= 1) {
            IRI oiri = URIUtils.desanitize((IRI)IRI.create((String)split[0].replace("%3A%3A%3A", ":::")));
            IRI viri = split.length > 1 ? URIUtils.desanitize((IRI)IRI.create((String)split[1].replace("%3A%3A%3A", ":::"))) : null;
            return viri != null ? new OWLOntologyID(oiri, viri) : new OWLOntologyID(oiri);
        }
        return null;
    }

    public static String encode(OWLOntologyID id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot encode a null OWLOntologyID.");
        }
        if (id.getOntologyIRI() == null) {
            throw new IllegalArgumentException("Cannot encode an OWLOntologyID that is missing an ontologyIRI.");
        }
        String s = "";
        s = s + URIUtils.sanitize((IRI)id.getOntologyIRI()).toString().replace(":::", "%3A%3A%3A");
        if (id.getVersionIRI() != null) {
            s = s + ":::" + URIUtils.sanitize((IRI)id.getVersionIRI()).toString().replace(":::", "%3A%3A%3A");
        }
        return s;
    }

    public static List<String> getPreferredFormats() {
        ArrayList<String> result = new ArrayList<String>();
        for (String f : preferredFormats) {
            result.add(f);
        }
        return result;
    }

    public static List<String> getPreferredSupportedFormats(Collection<String> supported) {
        ArrayList<String> result = new ArrayList<String>();
        for (String f : preferredFormats) {
            if (!supported.contains(f)) continue;
            result.add(f);
        }
        for (String f : supported) {
            if (result.contains(f)) continue;
            result.add(f);
        }
        return result;
    }
}

