/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.putty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.config.keys.loader.putty.AbstractPuttyKeyDecoder;
import org.apache.sshd.common.config.keys.loader.putty.DSSPuttyKeyDecoder;
import org.apache.sshd.common.config.keys.loader.putty.ECDSAPuttyKeyDecoder;
import org.apache.sshd.common.config.keys.loader.putty.EdDSAPuttyKeyDecoder;
import org.apache.sshd.common.config.keys.loader.putty.PuttyKeyPairResourceParser;
import org.apache.sshd.common.config.keys.loader.putty.RSAPuttyKeyDecoder;
import org.apache.sshd.common.util.security.SecurityUtils;

public final class PuttyKeyUtils {
    public static final List<PuttyKeyPairResourceParser<?, ?>> DEFAULT_PARSERS;
    public static final NavigableMap<String, PuttyKeyPairResourceParser<?, ?>> BY_KEY_TYPE;
    public static final KeyPairResourceParser DEFAULT_INSTANCE;

    private PuttyKeyUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    static {
        ArrayList<AbstractPuttyKeyDecoder> parsers = new ArrayList<AbstractPuttyKeyDecoder>();
        parsers.add(RSAPuttyKeyDecoder.INSTANCE);
        parsers.add(DSSPuttyKeyDecoder.INSTANCE);
        if (SecurityUtils.isECCSupported()) {
            parsers.add(ECDSAPuttyKeyDecoder.INSTANCE);
        }
        if (SecurityUtils.isEDDSACurveSupported()) {
            parsers.add(EdDSAPuttyKeyDecoder.INSTANCE);
        }
        TreeMap<String, PuttyKeyPairResourceParser> map = new TreeMap<String, PuttyKeyPairResourceParser>(String.CASE_INSENSITIVE_ORDER);
        for (PuttyKeyPairResourceParser puttyKeyPairResourceParser : parsers) {
            Collection supported = puttyKeyPairResourceParser.getSupportedTypeNames();
            for (String k : supported) {
                map.put(k, puttyKeyPairResourceParser);
            }
        }
        DEFAULT_PARSERS = Collections.unmodifiableList(parsers);
        BY_KEY_TYPE = Collections.unmodifiableNavigableMap(map);
        DEFAULT_INSTANCE = KeyPairResourceParser.aggregate(parsers);
    }
}

