/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.git.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.future.ConnectFuture;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;

public class GitSshdSessionFactory
extends SshSessionFactory {
    public RemoteSession getSession(URIish uri, CredentialsProvider credentialsProvider, FS fs, int tms) throws TransportException {
        try {
            return new SshdSession(uri, credentialsProvider, fs, tms);
        }
        catch (Exception e) {
            throw new TransportException("Unable to connect", (Throwable)e);
        }
    }

    protected SshClient createClient() {
        return SshClient.setUpDefaultClient();
    }

    public class SshdSession
    implements RemoteSession {
        private final SshClient client;
        private final ClientSession session;

        public SshdSession(URIish uri, CredentialsProvider credentialsProvider, FS fs, int tms) throws IOException, InterruptedException {
            String user = uri.getUser();
            String pass = uri.getPass();
            String host = uri.getHost();
            int port = uri.getPort();
            char[] pass2 = null;
            if (!credentialsProvider.isInteractive()) {
                CredentialItem.Username usrItem = new CredentialItem.Username();
                CredentialItem.Password pwdItem = new CredentialItem.Password();
                if (credentialsProvider.get(uri, new CredentialItem[]{usrItem, pwdItem})) {
                    if (user == null) {
                        user = usrItem.getValue();
                    } else if (user.equals(usrItem.getValue())) {
                        pass2 = pwdItem.getValue();
                    }
                }
            }
            this.client = GitSshdSessionFactory.this.createClient();
            this.client.start();
            this.session = ((ConnectFuture)this.client.connect(user, host, port).await()).getSession();
            if (pass != null) {
                this.session.addPasswordIdentity(pass);
            }
            if (pass2 != null) {
                this.session.addPasswordIdentity(new String(pass2));
            }
            this.session.auth().verify();
        }

        public Process exec(String commandName, int timeout) throws IOException {
            final ChannelExec channel = this.session.createExecChannel(commandName);
            channel.open().verify();
            return new Process(){

                public OutputStream getOutputStream() {
                    return channel.getInvertedIn();
                }

                public InputStream getInputStream() {
                    return channel.getInvertedOut();
                }

                public InputStream getErrorStream() {
                    return channel.getInvertedErr();
                }

                public int waitFor() throws InterruptedException {
                    return channel.waitFor(2, 0L);
                }

                public int exitValue() {
                    return channel.getExitStatus();
                }

                public void destroy() {
                    channel.close(true);
                }
            };
        }

        public void disconnect() {
            this.client.close(true);
        }
    }
}

