/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.git.pack;

import org.apache.sshd.git.pack.GitPackCommand;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.command.UnknownCommand;

public class GitPackCommandFactory
implements CommandFactory {
    private final String rootDir;
    private final CommandFactory delegate;

    public GitPackCommandFactory(String rootDir) {
        this(rootDir, null);
    }

    public GitPackCommandFactory(String rootDir, CommandFactory delegate) {
        this.rootDir = rootDir;
        this.delegate = delegate;
    }

    public Command createCommand(String command) {
        if (command.startsWith("git-")) {
            return new GitPackCommand(this.rootDir, command);
        }
        if (this.delegate != null) {
            return this.delegate.createCommand(command);
        }
        return new UnknownCommand(command);
    }
}

