/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.subsystem.sftp;

import java.nio.file.FileSystemException;
import java.util.Objects;
import org.apache.sshd.common.subsystem.sftp.SftpException;
import org.apache.sshd.server.subsystem.sftp.SftpErrorStatusDataHandler;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemEnvironment;

public class DetailedSftpErrorStatusDataHandler
implements SftpErrorStatusDataHandler {
    public static final DetailedSftpErrorStatusDataHandler INSTANCE = new DetailedSftpErrorStatusDataHandler();

    public String resolveErrorMessage(SftpSubsystemEnvironment sftpSubsystem, int id, Throwable e, int subStatus, int cmd, Object ... args) {
        if (e instanceof FileSystemException) {
            FileSystemException fse = (FileSystemException)e;
            String file = fse.getFile();
            String otherFile = fse.getOtherFile();
            String message = fse.getReason();
            return e.getClass().getSimpleName() + "[file=" + file + "]" + (Objects.equals(file, otherFile) ? "" : "[other=" + otherFile + "]") + ": " + message;
        }
        if (e instanceof SftpException) {
            return e.toString();
        }
        return "Internal " + e.getClass().getSimpleName() + ": " + e.getMessage();
    }
}

