/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.config.LogLevelValue;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.io.BuiltinIoServiceFactoryFactories;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.util.GenericUtils;

public abstract class CliSupport {
    public static final BuiltinIoServiceFactoryFactories DEFAULT_IO_SERVICE_FACTORY = BuiltinIoServiceFactoryFactories.NIO2;

    protected CliSupport() {
    }

    public static boolean showError(PrintStream stderr, String message) {
        stderr.println(message);
        return true;
    }

    public static BuiltinIoServiceFactoryFactories resolveIoServiceFactory(PrintStream stderr, String ... args) {
        int numArgs = GenericUtils.length((Object[])args);
        BuiltinIoServiceFactoryFactories factory = null;
        for (int index = 0; index < numArgs; ++index) {
            String argName = args[index];
            if (!"-io".equals(argName)) continue;
            if (factory != null) {
                stderr.println("I/O factory re-specified - already set as " + factory);
                return null;
            }
            if (++index >= numArgs) {
                stderr.println("option requires an argument: " + argName);
                return null;
            }
            String provider = args[index];
            factory = BuiltinIoServiceFactoryFactories.fromFactoryName((String)provider);
            if (factory != null) continue;
            System.err.println("provider (" + argName + ") should be one of " + BuiltinIoServiceFactoryFactories.VALUES);
            return null;
        }
        if (factory == null) {
            factory = DEFAULT_IO_SERVICE_FACTORY;
        }
        System.setProperty(IoServiceFactoryFactory.class.getName(), factory.getFactoryClassName());
        return factory;
    }

    public static <M extends AbstractFactoryManager> M setupIoServiceFactory(M manager, Map<String, ?> options, final PrintStream stdout, final PrintStream stderr, String ... args) {
        String levelValue;
        BuiltinIoServiceFactoryFactories factory = CliSupport.resolveIoServiceFactory(stderr, args);
        if (factory == null) {
            return null;
        }
        manager.setIoServiceFactoryFactory(factory.create());
        String string = levelValue = options == null ? null : Objects.toString(options.get("LogLevel"), null);
        if (GenericUtils.isEmpty(levelValue)) {
            return manager;
        }
        final LogLevelValue level = LogLevelValue.fromName((String)levelValue);
        if (level == null) {
            throw new IllegalArgumentException("Unknown LogLevel option value: " + levelValue);
        }
        if (level != LogLevelValue.FATAL && level != LogLevelValue.ERROR && level != LogLevelValue.INFO) {
            return manager;
        }
        manager.setIoServiceEventListener(new IoServiceEventListener(){
            private final PrintStream out;
            {
                this.out = level == LogLevelValue.INFO ? stdout : stderr;
            }

            public void connectionEstablished(IoConnector connector, SocketAddress local, SocketAddress remote) throws IOException {
                this.out.append("Connection established via ").append(Objects.toString(connector)).append("- local=").append(Objects.toString(local)).append(", remote=").append(Objects.toString(remote)).println();
            }

            public void abortEstablishedConnection(IoConnector connector, SocketAddress local, SocketAddress remote, Throwable reason) throws IOException {
                this.out.append("Abort established connection ").append(Objects.toString(connector)).append(" - local=").append(Objects.toString(local)).append(", remote=").append(Objects.toString(remote)).append(": (").append(reason.getClass().getSimpleName()).append(')').append(" ").println(reason.getMessage());
                reason.printStackTrace(this.out);
            }

            public void connectionAccepted(IoAcceptor acceptor, SocketAddress local, SocketAddress remote) throws IOException {
                this.out.append("Connection accepted via ").append(Objects.toString(acceptor)).append(" - local=").append(Objects.toString(local)).append(", remote=").append(Objects.toString(remote)).println();
            }

            public void abortAcceptedConnection(IoAcceptor acceptor, SocketAddress local, SocketAddress remote, Throwable reason) throws IOException {
                this.out.append("Abort accepted connection ").append(Objects.toString(acceptor)).append(" - local=").append(Objects.toString(local)).append(", remote=").append(Objects.toString(remote)).append(": (").append(reason.getClass().getSimpleName()).append(')').append(" ").println(reason.getMessage());
                reason.printStackTrace(this.out);
            }
        });
        return manager;
    }
}

