/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import java.io.Serializable;
import java.util.Date;
import org.apache.spark.streaming.kinesis.KinesisInitialPosition;

public class KinesisInitialPositions {
    public static KinesisInitialPosition fromKinesisInitialPosition(InitialPositionInStream initialPositionInStream) throws UnsupportedOperationException {
        if (initialPositionInStream == InitialPositionInStream.LATEST) {
            return new Latest();
        }
        if (initialPositionInStream == InitialPositionInStream.TRIM_HORIZON) {
            return new TrimHorizon();
        }
        throw new UnsupportedOperationException("Only InitialPositionInStream.LATEST and InitialPositionInStream.TRIM_HORIZON supported in initialPositionInStream(). Please use the initialPosition() from builder API in KinesisInputDStream for using InitialPositionInStream.AT_TIMESTAMP");
    }

    public static class Latest
    implements KinesisInitialPosition,
    Serializable {
        @Override
        public InitialPositionInStream getPosition() {
            return InitialPositionInStream.LATEST;
        }
    }

    public static class TrimHorizon
    implements KinesisInitialPosition,
    Serializable {
        @Override
        public InitialPositionInStream getPosition() {
            return InitialPositionInStream.TRIM_HORIZON;
        }
    }

    public static class AtTimestamp
    implements KinesisInitialPosition,
    Serializable {
        private Date timestamp;

        public AtTimestamp(Date timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public InitialPositionInStream getPosition() {
            return InitialPositionInStream.AT_TIMESTAMP;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }
    }
}

