/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShutdownReason;
import com.amazonaws.services.kinesis.model.Record;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.streaming.kinesis.KinesisReceiver;
import org.apache.spark.streaming.kinesis.KinesisRecordProcessor$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005}c!\u0002\b\u0010\u0001=I\u0002\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u00111\u0003!\u0011!Q\u0001\n5CQ\u0001\u0017\u0001\u0005\u0002eC\u0011\"\u0018\u0001A\u0002\u0003\u0007I\u0011\u00020\t\u0013}\u0003\u0001\u0019!a\u0001\n\u0013\u0001\u0007\"\u00034\u0001\u0001\u0004\u0005\t\u0015)\u0003N\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u0015q\u0007\u0001\"\u0011p\u0011\u001d\t9\u0001\u0001C!\u0003\u00139\u0001\"!\t\u0010\u0011\u0003y\u00111\u0005\u0004\b\u001d=A\taDA\u0013\u0011\u0019A6\u0002\"\u0001\u0002.!9\u0011qF\u0006\u0005\u0002\u0005E\"AF&j]\u0016\u001c\u0018n\u001d*fG>\u0014H\r\u0015:pG\u0016\u001c8o\u001c:\u000b\u0005A\t\u0012aB6j]\u0016\u001c\u0018n\u001d\u0006\u0003%M\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005Q)\u0012!B:qCJ\\'B\u0001\f\u0018\u0003\u0019\t\u0007/Y2iK*\t\u0001$A\u0002pe\u001e,\"A\u0007!\u0014\t\u0001Y2E\r\t\u00039\u0005j\u0011!\b\u0006\u0003=}\tA\u0001\\1oO*\t\u0001%\u0001\u0003kCZ\f\u0017B\u0001\u0012\u001e\u0005\u0019y%M[3diB\u0011A\u0005M\u0007\u0002K)\u0011aeJ\u0001\u000bS:$XM\u001d4bG\u0016\u001c(B\u0001\u0015*\u00035\u0019G.[3oi2L'M]1ss*\u0011\u0001C\u000b\u0006\u0003W1\n\u0001b]3sm&\u001cWm\u001d\u0006\u0003[9\n\u0011\"Y7bu>t\u0017m^:\u000b\u0003=\n1aY8n\u0013\t\tTE\u0001\tJ%\u0016\u001cwN\u001d3Qe>\u001cWm]:peB\u00111GN\u0007\u0002i)\u0011QgE\u0001\tS:$XM\u001d8bY&\u0011q\u0007\u000e\u0002\b\u0019><w-\u001b8h\u0003!\u0011XmY3jm\u0016\u00148\u0001\u0001\t\u0004wqrT\"A\b\n\u0005uz!aD&j]\u0016\u001c\u0018n\u001d*fG\u0016Lg/\u001a:\u0011\u0005}\u0002E\u0002\u0001\u0003\u0006\u0003\u0002\u0011\rA\u0011\u0002\u0002)F\u00111)\u0013\t\u0003\t\u001ek\u0011!\u0012\u0006\u0002\r\u0006)1oY1mC&\u0011\u0001*\u0012\u0002\b\u001d>$\b.\u001b8h!\t!%*\u0003\u0002L\u000b\n\u0019\u0011I\\=\u0002\u0011]|'o[3s\u0013\u0012\u0004\"AT+\u000f\u0005=\u001b\u0006C\u0001)F\u001b\u0005\t&B\u0001*:\u0003\u0019a$o\\8u}%\u0011A+R\u0001\u0007!J,G-\u001a4\n\u0005Y;&AB*ue&twM\u0003\u0002U\u000b\u00061A(\u001b8jiz\"2AW.]!\rY\u0004A\u0010\u0005\u0006q\r\u0001\rA\u000f\u0005\u0006\u0019\u000e\u0001\r!T\u0001\bg\"\f'\u000fZ%e+\u0005i\u0015aC:iCJ$\u0017\nZ0%KF$\"!\u00193\u0011\u0005\u0011\u0013\u0017BA2F\u0005\u0011)f.\u001b;\t\u000f\u0015,\u0011\u0011!a\u0001\u001b\u0006\u0019\u0001\u0010J\u0019\u0002\u0011MD\u0017M\u001d3JI\u0002B#A\u00025\u0011\u0005\u0011K\u0017B\u00016F\u0005!1x\u000e\\1uS2,\u0017AC5oSRL\u0017\r\\5{KR\u0011\u0011-\u001c\u0005\u0006;\u001e\u0001\r!T\u0001\u000faJ|7-Z:t%\u0016\u001cwN\u001d3t)\r\t\u0007O \u0005\u0006c\"\u0001\rA]\u0001\u0006E\u0006$8\r\u001b\t\u0004gZDX\"\u0001;\u000b\u0005U|\u0012\u0001B;uS2L!a\u001e;\u0003\t1K7\u000f\u001e\t\u0003srl\u0011A\u001f\u0006\u0003w&\nQ!\\8eK2L!! >\u0003\rI+7m\u001c:e\u0011\u0019y\b\u00021\u0001\u0002\u0002\u0005a1\r[3dWB|\u0017N\u001c;feB\u0019A%a\u0001\n\u0007\u0005\u0015QE\u0001\u000fJ%\u0016\u001cwN\u001d3Qe>\u001cWm]:pe\u000eCWmY6q_&tG/\u001a:\u0002\u0011MDW\u000f\u001e3po:$R!YA\u0006\u0003\u001bAaa`\u0005A\u0002\u0005\u0005\u0001bBA\b\u0013\u0001\u0007\u0011\u0011C\u0001\u0007e\u0016\f7o\u001c8\u0011\t\u0005M\u0011QD\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u00051qo\u001c:lKJT1!a\u0007(\u0003\ra\u0017NY\u0005\u0005\u0003?\t)B\u0001\bTQV$Hm\\<o%\u0016\f7o\u001c8\u0002--Kg.Z:jgJ+7m\u001c:e!J|7-Z:t_J\u0004\"aO\u0006\u0014\t-\t9C\r\t\u0004\t\u0006%\u0012bAA\u0016\u000b\n1\u0011I\\=SK\u001a$\"!a\t\u0002\u0017I,GO]=SC:$w.\\\u000b\u0005\u0003g\t9\u0004\u0006\u0005\u00026\u0005e\u00121IA'!\ry\u0014q\u0007\u0003\u0006\u00036\u0011\rA\u0011\u0005\t\u0003wiA\u00111\u0001\u0002>\u0005QQ\r\u001f9sKN\u001c\u0018n\u001c8\u0011\u000b\u0011\u000by$!\u000e\n\u0007\u0005\u0005SI\u0001\u0005=Eft\u0017-\\3?\u0011\u001d\t)%\u0004a\u0001\u0003\u000f\naB\\;n%\u0016$(/[3t\u0019\u00164G\u000fE\u0002E\u0003\u0013J1!a\u0013F\u0005\rIe\u000e\u001e\u0005\b\u0003\u001fj\u0001\u0019AA$\u0003Ai\u0017\r\u001f\"bG.|eMZ'jY2L7\u000fK\u0002\u000e\u0003'\u0002B!!\u0016\u0002\\5\u0011\u0011q\u000b\u0006\u0004\u00033*\u0015AC1o]>$\u0018\r^5p]&!\u0011QLA,\u0005\u001d!\u0018-\u001b7sK\u000e\u0004")
public class KinesisRecordProcessor<T>
implements IRecordProcessor,
Logging {
    private final KinesisReceiver<T> receiver;
    private final String workerId;
    private volatile String shardId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <T> T retryRandom(Function0<T> expression, int numRetriesLeft, int maxBackOffMillis) {
        return KinesisRecordProcessor$.MODULE$.retryRandom(expression, numRetriesLeft, maxBackOffMillis);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String shardId() {
        return this.shardId;
    }

    private void shardId_$eq(String x$1) {
        this.shardId = x$1;
    }

    public void initialize(String shardId) {
        this.shardId_$eq(shardId);
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Initialized workerId ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.WORKER_URL$.MODULE$, (Object)$this.workerId)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"with shardId ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SHARD_ID$.MODULE$, (Object)shardId)})))));
    }

    public void processRecords(List<Record> batch, IRecordProcessorCheckpointer checkpointer) {
        if (!this.receiver.isStopped()) {
            try {
                int maxRecords = this.receiver.getCurrentLimit();
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), batch.size()).by(maxRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)start -> {
                    List<Record> miniBatch = batch.subList(start, package$.MODULE$.min(start + maxRecords, batch.size()));
                    $this.receiver.addRecords(this.shardId(), miniBatch);
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Stored: Worker " + $this.workerId + " stored " + miniBatch.size() + " records for shardId " + this.shardId());
                });
                this.receiver.setCheckpointer(this.shardId(), checkpointer);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Exception: WorkerId ", " encountered and "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.WORKER_URL$.MODULE$, (Object)$this.workerId)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"exception while storing or checkpointing a batch for workerId "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " and shardId ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.WORKER_URL$.MODULE$, (Object)$this.workerId), new MDC((LogKey)LogKeys.SHARD_ID$.MODULE$, (Object)this.shardId())})))), throwable2);
                    throw throwable2;
                }
                throw throwable;
            }
            return;
        }
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Stopped: KinesisReceiver has stopped for workerId ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.WORKER_URL$.MODULE$, (Object)$this.workerId)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" and shardId ", ". No more records will be processed."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SHARD_ID$.MODULE$, (Object)this.shardId())})))));
    }

    public void shutdown(IRecordProcessorCheckpointer checkpointer, ShutdownReason reason) {
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Shutdown: Shutting down workerId ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.WORKER_URL$.MODULE$, (Object)$this.workerId)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"with reason ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.KINESIS_REASON$.MODULE$, (Object)reason)})))));
        if (this.shardId() == null) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"No shardId for workerId ", "?"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.WORKER_URL$.MODULE$, (Object)$this.workerId)}))));
            return;
        }
        ShutdownReason shutdownReason = reason;
        if (ShutdownReason.TERMINATE.equals(shutdownReason)) {
            this.receiver.removeCheckpointer(this.shardId(), checkpointer);
            return;
        }
        this.receiver.removeCheckpointer(this.shardId(), null);
    }

    public KinesisRecordProcessor(KinesisReceiver<T> receiver, String workerId) {
        this.receiver = receiver;
        this.workerId = workerId;
        Logging.$init$((Logging)this);
    }
}

