/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import java.io.Serializable;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.kinesis.KinesisReadConfigurations;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class KinesisReadConfigurations$
implements Serializable {
    public static final KinesisReadConfigurations$ MODULE$ = new KinesisReadConfigurations$();
    private static final String RETRY_MAX_ATTEMPTS_KEY = "spark.streaming.kinesis.retry.maxAttempts";
    private static final String RETRY_WAIT_TIME_KEY = "spark.streaming.kinesis.retry.waitTime";
    private static final int DEFAULT_MAX_RETRIES = 3;
    private static final String DEFAULT_RETRY_WAIT_TIME = "100ms";
    private static final int DEFAULT_RETRY_TIMEOUT = 10000;

    public KinesisReadConfigurations apply() {
        return new KinesisReadConfigurations(this.DEFAULT_MAX_RETRIES(), JavaUtils.timeStringAsMs((String)this.DEFAULT_RETRY_WAIT_TIME()), this.DEFAULT_RETRY_TIMEOUT());
    }

    public KinesisReadConfigurations apply(StreamingContext ssc) {
        return new KinesisReadConfigurations(ssc.sc().getConf().getInt(this.RETRY_MAX_ATTEMPTS_KEY(), this.DEFAULT_MAX_RETRIES()), JavaUtils.timeStringAsMs((String)ssc.sc().getConf().get(this.RETRY_WAIT_TIME_KEY(), this.DEFAULT_RETRY_WAIT_TIME())), ssc.graph().batchDuration().milliseconds());
    }

    public String RETRY_MAX_ATTEMPTS_KEY() {
        return RETRY_MAX_ATTEMPTS_KEY;
    }

    public String RETRY_WAIT_TIME_KEY() {
        return RETRY_WAIT_TIME_KEY;
    }

    public int DEFAULT_MAX_RETRIES() {
        return DEFAULT_MAX_RETRIES;
    }

    public String DEFAULT_RETRY_WAIT_TIME() {
        return DEFAULT_RETRY_WAIT_TIME;
    }

    public int DEFAULT_RETRY_TIMEOUT() {
        return DEFAULT_RETRY_TIMEOUT;
    }

    public KinesisReadConfigurations apply(int maxRetries, long retryWaitTimeMs, long retryTimeoutMs) {
        return new KinesisReadConfigurations(maxRetries, retryWaitTimeMs, retryTimeoutMs);
    }

    public Option<Tuple3<Object, Object, Object>> unapply(KinesisReadConfigurations x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)x$0.maxRetries()), (Object)BoxesRunTime.boxToLong((long)x$0.retryWaitTimeMs()), (Object)BoxesRunTime.boxToLong((long)x$0.retryTimeoutMs())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(KinesisReadConfigurations$.class);
    }

    private KinesisReadConfigurations$() {
    }
}

