/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminUtils$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignmentCompleted$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.ReassignmentInProgress$;
import kafka.admin.ReassignmentStatus;
import kafka.common.AdminCommandFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.ReassignedPartitionsContext;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ReassignPartitionsCommand$
implements Logging {
    public static final ReassignPartitionsCommand$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ReassignPartitionsCommand$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReassignPartitionsCommand$ reassignPartitionsCommand$ = this;
        synchronized (reassignPartitionsCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = new ReassignPartitionsCommand.ReassignPartitionsCommandOptions(args);
        int actions = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.generateOpt(), opts.executeOpt(), opts.verifyOpt()}))).count((Function1)new Serializable(opts){
            public static final long serialVersionUID = 0L;
            private final ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts$1;

            public final boolean apply(OptionSpec<?> x$1) {
                return this.opts$1.options().has(x$1);
            }
            {
                this.opts$1 = opts$1;
            }
        });
        if (actions != 1) {
            CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --generate, --execute or --verify");
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(opts.parser(), opts.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.zkConnectOpt()}));
        String zkConnect = (String)opts.options().valueOf(opts.zkConnectOpt());
        ZkClient zkClient = new ZkClient(zkConnect, 30000, 30000, ZKStringSerializer$.MODULE$);
        try {
            try {
                if (opts.options().has((OptionSpec)opts.verifyOpt())) {
                    this.verifyAssignment(zkClient, opts);
                } else if (opts.options().has((OptionSpec)opts.generateOpt())) {
                    this.generateAssignment(zkClient, opts);
                } else if (opts.options().has((OptionSpec)opts.executeOpt())) {
                    this.executeAssignment(zkClient, opts);
                }
            }
            catch (Throwable throwable) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Partitions reassignment failed due to ").append((Object)throwable.getMessage()).toString());
                Predef$.MODULE$.println((Object)Utils$.MODULE$.stackTrace(throwable));
            }
        }
        finally {
            if (zkClient != null) {
                zkClient.close();
            }
        }
    }

    public void verifyAssignment(ZkClient zkClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        if (!opts.options().has(opts.reassignmentJsonFileOpt())) {
            CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --verify option is used, command must include --reassignment-json-file that was used during the --execute option");
        }
        String jsonFile = (String)opts.options().valueOf(opts.reassignmentJsonFileOpt());
        String jsonString = Utils$.MODULE$.readFileAsString(jsonFile, Utils$.MODULE$.readFileAsString$default$2());
        Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned = ZkUtils$.MODULE$.parsePartitionReassignmentData(jsonString);
        Predef$.MODULE$.println((Object)"Status of partition reassignment:");
        Map<TopicAndPartition, ReassignmentStatus> reassignedPartitionsStatus = this.checkIfReassignmentSucceeded(zkClient, partitionsToBeReassigned);
        reassignedPartitionsStatus.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<TopicAndPartition, ReassignmentStatus> partition) {
                ReassignmentStatus reassignmentStatus;
                block5: {
                    block3: {
                        block4: {
                            block2: {
                                reassignmentStatus = (ReassignmentStatus)partition._2();
                                if (!ReassignmentCompleted$.MODULE$.equals(reassignmentStatus)) break block2;
                                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s completed successfully")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition._1()})));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!ReassignmentFailed$.MODULE$.equals(reassignmentStatus)) break block4;
                            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition._1()})));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!ReassignmentInProgress$.MODULE$.equals(reassignmentStatus)) break block5;
                        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s is still in progress")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition._1()})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError((Object)reassignmentStatus);
            }
        });
    }

    public void generateAssignment(ZkClient zkClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        if (!opts.options().has(opts.topicsToMoveJsonFileOpt()) || !opts.options().has(opts.brokerListOpt())) {
            CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options");
        }
        String topicsToMoveJsonFile = (String)opts.options().valueOf(opts.topicsToMoveJsonFileOpt());
        int[] brokerListToReassign = (int[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString((String)opts.options().valueOf(opts.brokerListOpt()))).split(',')).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        Iterable duplicateReassignments = Utils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray(brokerListToReassign));
        if (duplicateReassignments.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Broker list contains duplicate entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateReassignments.mkString(",")})));
        }
        String topicsToMoveJsonString = Utils$.MODULE$.readFileAsString(topicsToMoveJsonFile, Utils$.MODULE$.readFileAsString$default$2());
        Seq<String> topicsToReassign = ZkUtils$.MODULE$.parseTopicsData(topicsToMoveJsonString);
        Iterable<String> duplicateTopicsToReassign = Utils$.MODULE$.duplicates(topicsToReassign);
        if (duplicateTopicsToReassign.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("List of topics to reassign contains duplicate entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateTopicsToReassign.mkString(",")})));
        }
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> topicPartitionsToReassign = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(zkClient, topicsToReassign);
        ObjectRef partitionsToBeReassigned = ObjectRef.create((Object)new HashMap());
        scala.collection.immutable.Map groupedByTopic = topicPartitionsToReassign.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TopicAndPartition, Seq<Object>> tp) {
                return ((TopicAndPartition)tp._1()).topic();
            }
        });
        groupedByTopic.foreach((Function1)new Serializable(brokerListToReassign, partitionsToBeReassigned){
            public static final long serialVersionUID = 0L;
            private final int[] brokerListToReassign$1;
            private final ObjectRef partitionsToBeReassigned$2;

            public final void apply(Tuple2<String, scala.collection.mutable.Map<TopicAndPartition, Seq<Object>>> topicInfo) {
                Map<Object, Seq<Object>> assignedReplicas = AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(this.brokerListToReassign$1), ((TraversableOnce)topicInfo._2()).size(), ((SeqLike)((Tuple2)((IterableLike)topicInfo._2()).head())._2()).size(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
                this.partitionsToBeReassigned$2.elem = ((Map)this.partitionsToBeReassigned$2.elem).$plus$plus((GenTraversableOnce)assignedReplicas.map((Function1)new Serializable(this, topicInfo){
                    public static final long serialVersionUID = 0L;
                    private final Tuple2 topicInfo$1;

                    public final Tuple2<TopicAndPartition, Seq<Object>> apply(Tuple2<Object, Seq<Object>> replicaInfo) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition((String)this.topicInfo$1._1(), replicaInfo._1$mcI$sp())), replicaInfo._2());
                    }
                    {
                        this.topicInfo$1 = topicInfo$1;
                    }
                }, Map$.MODULE$.canBuildFrom()));
            }
            {
                this.brokerListToReassign$1 = brokerListToReassign$1;
                this.partitionsToBeReassigned$2 = partitionsToBeReassigned$2;
            }
        });
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> currentPartitionReplicaAssignment = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(zkClient, (Seq<String>)((TraversableOnce)((Map)partitionsToBeReassigned.elem).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TopicAndPartition, Seq<Object>> x$2) {
                return ((TopicAndPartition)x$2._1()).topic();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq());
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Current partition replica assignment\n\n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.getPartitionReassignmentZkData((Map<TopicAndPartition, Seq<Object>>)currentPartitionReplicaAssignment)})));
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Proposed partition reassignment configuration\n\n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.getPartitionReassignmentZkData((Map<TopicAndPartition, Seq<Object>>)((Map)partitionsToBeReassigned.elem))})));
    }

    public void executeAssignment(ZkClient zkClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String reassignmentJsonFile;
        String reassignmentJsonString;
        Seq<Tuple2<TopicAndPartition, Seq<Object>>> partitionsToBeReassigned;
        if (!opts.options().has(opts.reassignmentJsonFileOpt())) {
            CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --execute option is used, command must include --reassignment-json-file that was output during the --generate option");
        }
        if ((partitionsToBeReassigned = ZkUtils$.MODULE$.parsePartitionReassignmentDataWithoutDedup(reassignmentJsonString = Utils$.MODULE$.readFileAsString(reassignmentJsonFile = (String)opts.options().valueOf(opts.reassignmentJsonFileOpt()), Utils$.MODULE$.readFileAsString$default$2()))).isEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition reassignment data file %s is empty")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{reassignmentJsonFile})));
        }
        Iterable duplicateReassignedPartitions = Utils$.MODULE$.duplicates((Traversable)partitionsToBeReassigned.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TopicAndPartition apply(Tuple2<TopicAndPartition, Seq<Object>> x0$1) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicAndPartition tp;
                    TopicAndPartition topicAndPartition = tp = (TopicAndPartition)tuple2._1();
                    return topicAndPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom()));
        if (duplicateReassignedPartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition reassignment contains duplicate topic partitions: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateReassignedPartitions.mkString(",")})));
        }
        Seq duplicateEntries = (Seq)((TraversableLike)partitionsToBeReassigned.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicAndPartition, Iterable<Object>> apply(Tuple2<TopicAndPartition, Seq<Object>> x0$2) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)tp, Utils$.MODULE$.duplicates(replicas));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, Iterable<Object>> x0$3) {
                Tuple2<TopicAndPartition, Iterable<Object>> tuple2 = x0$3;
                if (tuple2 != null) {
                    Iterable duplicatedReplicas = (Iterable)tuple2._2();
                    boolean bl = duplicatedReplicas.nonEmpty();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        if (duplicateEntries.nonEmpty()) {
            String duplicatesMsg = ((TraversableOnce)duplicateEntries.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<TopicAndPartition, Iterable<Object>> x0$4) {
                    Tuple2<TopicAndPartition, Iterable<Object>> tuple2 = x0$4;
                    if (tuple2 != null) {
                        TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                        Iterable duplicateReplicas = (Iterable)tuple2._2();
                        String string2 = new StringOps(Predef$.MODULE$.augmentString("%s contains multiple entries for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, duplicateReplicas.mkString(",")}));
                        return string2;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(". ");
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition replica lists may not contain duplicate entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicatesMsg})));
        }
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(zkClient, (Map<TopicAndPartition, Seq<Object>>)partitionsToBeReassigned.toMap(Predef$.MODULE$.$conforms()));
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> currentPartitionReplicaAssignment = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(zkClient, (Seq<String>)((SeqLike)partitionsToBeReassigned.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TopicAndPartition, Seq<Object>> x$3) {
                return ((TopicAndPartition)x$3._1()).topic();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSeq());
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Current partition replica assignment\n\n%s\n\nSave this to use as the --reassignment-json-file option during rollback")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.getPartitionReassignmentZkData((Map<TopicAndPartition, Seq<Object>>)currentPartitionReplicaAssignment)})));
        if (reassignPartitionsCommand.reassignPartitions()) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Successfully started reassignment of partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.getPartitionReassignmentZkData((Map<TopicAndPartition, Seq<Object>>)partitionsToBeReassigned.toMap(Predef$.MODULE$.$conforms()))})));
        } else {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Failed to reassign partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsToBeReassigned})));
        }
    }

    private Map<TopicAndPartition, ReassignmentStatus> checkIfReassignmentSucceeded(ZkClient zkClient, Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned) {
        Map partitionsBeingReassigned = ZkUtils$.MODULE$.getPartitionsBeingReassigned(zkClient).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReassignedPartitionsContext x$4) {
                return x$4.newReplicas();
            }
        });
        return (Map)partitionsToBeReassigned.map((Function1)new Serializable(zkClient, partitionsToBeReassigned, partitionsBeingReassigned){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$1;
            private final Map partitionsToBeReassigned$1;
            private final Map partitionsBeingReassigned$1;

            public final Tuple2<TopicAndPartition, ReassignmentStatus> apply(Tuple2<TopicAndPartition, Seq<Object>> topicAndPartition) {
                return new Tuple2(topicAndPartition._1(), (Object)ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.zkClient$1, (TopicAndPartition)topicAndPartition._1(), (Seq<Object>)((Seq)topicAndPartition._2()), (Map<TopicAndPartition, Seq<Object>>)this.partitionsToBeReassigned$1, (Map<TopicAndPartition, Seq<Object>>)this.partitionsBeingReassigned$1));
            }
            {
                this.zkClient$1 = zkClient$1;
                this.partitionsToBeReassigned$1 = partitionsToBeReassigned$1;
                this.partitionsBeingReassigned$1 = partitionsBeingReassigned$1;
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public ReassignmentStatus checkIfPartitionReassignmentSucceeded(ZkClient zkClient, TopicAndPartition topicAndPartition, Seq<Object> reassignedReplicas, Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned, Map<TopicAndPartition, Seq<Object>> partitionsBeingReassigned) {
        Option option;
        block7: {
            Product product;
            block6: {
                Product product2;
                Seq<Object> assignedReplicas;
                Seq newReplicas;
                block5: {
                    newReplicas = (Seq)partitionsToBeReassigned.apply((Object)topicAndPartition);
                    option = partitionsBeingReassigned.get((Object)topicAndPartition);
                    if (!(option instanceof Some)) break block5;
                    product = ReassignmentInProgress$.MODULE$;
                    break block6;
                }
                if (!None$.MODULE$.equals(option)) break block7;
                Seq<Object> seq = assignedReplicas = ZkUtils$.MODULE$.getReplicasForPartition(zkClient, topicAndPartition.topic(), topicAndPartition.partition());
                Seq seq2 = newReplicas;
                if (!(seq != null ? !seq.equals((Object)seq2) : seq2 != null)) {
                    product2 = ReassignmentCompleted$.MODULE$;
                } else {
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("ERROR: Assigned replicas (%s) don't match the list of replicas for reassignment (%s) for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{assignedReplicas.mkString(","), newReplicas.mkString(","), topicAndPartition})));
                    product2 = ReassignmentFailed$.MODULE$;
                }
                product = product2;
            }
            return product;
        }
        throw new MatchError((Object)option);
    }

    private ReassignPartitionsCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

