/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.api.java.JavaInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.kafka010.ConsumerStrategy;
import org.apache.spark.streaming.kafka010.DefaultPerPartitionConfig;
import org.apache.spark.streaming.kafka010.DirectKafkaInputDStream;
import org.apache.spark.streaming.kafka010.KafkaRDD;
import org.apache.spark.streaming.kafka010.LocationStrategy;
import org.apache.spark.streaming.kafka010.OffsetRange;
import org.apache.spark.streaming.kafka010.PerPartitionConfig;
import org.apache.spark.streaming.kafka010.PreferBrokers$;
import org.apache.spark.streaming.kafka010.PreferConsistent$;
import org.apache.spark.streaming.kafka010.PreferFixed;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class KafkaUtils$
implements Logging {
    public static final KafkaUtils$ MODULE$ = new KafkaUtils$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public <K, V> RDD<ConsumerRecord<K, V>> createRDD(SparkContext sc, Map<String, Object> kafkaParams, OffsetRange[] offsetRanges, LocationStrategy locationStrategy) {
        Map<TopicPartition, String> map;
        LocationStrategy locationStrategy2 = locationStrategy;
        if (PreferBrokers$.MODULE$.equals(locationStrategy2)) {
            throw new IllegalArgumentException("If you want to prefer brokers, you must provide a mapping using PreferFixed A single KafkaRDD does not have a driver consumer and cannot look up brokers for you.");
        }
        if (PreferConsistent$.MODULE$.equals(locationStrategy2)) {
            map = Collections.emptyMap();
        } else if (locationStrategy2 instanceof PreferFixed) {
            PreferFixed preferFixed = (PreferFixed)locationStrategy2;
            Map<TopicPartition, String> hostMap = preferFixed.hostMap();
            map = hostMap;
        } else {
            throw new MatchError((Object)locationStrategy2);
        }
        Map<TopicPartition, String> preferredHosts = map;
        HashMap<String, Object> kp = new HashMap<String, Object>(kafkaParams);
        this.fixKafkaParams(kp);
        OffsetRange[] osr = (OffsetRange[])offsetRanges.clone();
        return new KafkaRDD(sc, kp, osr, preferredHosts, true);
    }

    public <K, V> JavaRDD<ConsumerRecord<K, V>> createRDD(JavaSparkContext jsc, Map<String, Object> kafkaParams, OffsetRange[] offsetRanges, LocationStrategy locationStrategy) {
        return new JavaRDD(this.createRDD(jsc.sc(), kafkaParams, offsetRanges, locationStrategy), ClassTag$.MODULE$.apply(ConsumerRecord.class));
    }

    public <K, V> InputDStream<ConsumerRecord<K, V>> createDirectStream(StreamingContext ssc, LocationStrategy locationStrategy, ConsumerStrategy<K, V> consumerStrategy) {
        DefaultPerPartitionConfig ppc = new DefaultPerPartitionConfig(ssc.sparkContext().getReadOnlyConf());
        return this.createDirectStream(ssc, locationStrategy, consumerStrategy, (PerPartitionConfig)ppc);
    }

    public <K, V> InputDStream<ConsumerRecord<K, V>> createDirectStream(StreamingContext ssc, LocationStrategy locationStrategy, ConsumerStrategy<K, V> consumerStrategy, PerPartitionConfig perPartitionConfig) {
        return new DirectKafkaInputDStream<K, V>(ssc, locationStrategy, consumerStrategy, perPartitionConfig);
    }

    public <K, V> JavaInputDStream<ConsumerRecord<K, V>> createDirectStream(JavaStreamingContext jssc, LocationStrategy locationStrategy, ConsumerStrategy<K, V> consumerStrategy) {
        return new JavaInputDStream(this.createDirectStream(jssc.ssc(), locationStrategy, consumerStrategy), ClassTag$.MODULE$.apply(ConsumerRecord.class));
    }

    public <K, V> JavaInputDStream<ConsumerRecord<K, V>> createDirectStream(JavaStreamingContext jssc, LocationStrategy locationStrategy, ConsumerStrategy<K, V> consumerStrategy, PerPartitionConfig perPartitionConfig) {
        return new JavaInputDStream(this.createDirectStream(jssc.ssc(), locationStrategy, consumerStrategy, perPartitionConfig), ClassTag$.MODULE$.apply(ConsumerRecord.class));
    }

    public void fixKafkaParams(HashMap<String, Object> kafkaParams) {
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"overriding ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.CONFIG, "enable.auto.commit")})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to false for executor"}))).log((Seq)Nil$.MODULE$))));
        kafkaParams.put("enable.auto.commit", Predef$.MODULE$.boolean2Boolean(false));
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"overriding ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.CONFIG, "auto.offset.reset")})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to none for executor"}))).log((Seq)Nil$.MODULE$))));
        kafkaParams.put("auto.offset.reset", "none");
        Object originalGroupId = kafkaParams.get("group.id");
        if (originalGroupId == null) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " is null, "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.CONFIG, "group.id")})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"you should probably set it"}))).log((Seq)Nil$.MODULE$))));
        }
        String groupId = "spark-executor-" + originalGroupId;
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"overriding executor ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.CONFIG, "group.id")})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.GROUP_ID, groupId)})))));
        kafkaParams.put("group.id", groupId);
        Object rbb = kafkaParams.get("receive.buffer.bytes");
        if (rbb == null || Predef$.MODULE$.Integer2int((Integer)rbb) < 65536) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"overriding ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.CONFIG, "receive.buffer.bytes")})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to 65536 see KAFKA-3135"}))).log((Seq)Nil$.MODULE$))));
            kafkaParams.put("receive.buffer.bytes", Predef$.MODULE$.int2Integer(65536));
            return;
        }
    }

    private KafkaUtils$() {
    }
}

