/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ReadShareGroupStateRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class ReadShareGroupStateRequestDataJsonConverter {
    public static ReadShareGroupStateRequestData read(JsonNode _node, short _version) {
        ReadShareGroupStateRequestData _object = new ReadShareGroupStateRequestData();
        JsonNode _groupIdNode = _node.get("groupId");
        if (_groupIdNode == null) {
            throw new RuntimeException("ReadShareGroupStateRequestData: unable to locate field 'groupId', which is mandatory in version " + _version);
        }
        if (!_groupIdNode.isTextual()) {
            throw new RuntimeException("ReadShareGroupStateRequestData expected a string type, but got " + (Object)((Object)_node.getNodeType()));
        }
        _object.groupId = _groupIdNode.asText();
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("ReadShareGroupStateRequestData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("ReadShareGroupStateRequestData expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
        }
        ArrayList<ReadShareGroupStateRequestData.ReadStateData> _collection = new ArrayList<ReadShareGroupStateRequestData.ReadStateData>(_topicsNode.size());
        _object.topics = _collection;
        for (JsonNode _element : _topicsNode) {
            _collection.add(ReadStateDataJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(ReadShareGroupStateRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("groupId", new TextNode(_object.groupId));
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (ReadShareGroupStateRequestData.ReadStateData _element : _object.topics) {
            _topicsArray.add(ReadStateDataJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("topics", _topicsArray);
        return _node;
    }

    public static JsonNode write(ReadShareGroupStateRequestData _object, short _version) {
        return ReadShareGroupStateRequestDataJsonConverter.write(_object, _version, true);
    }

    public static class ReadStateDataJsonConverter {
        public static ReadShareGroupStateRequestData.ReadStateData read(JsonNode _node, short _version) {
            ReadShareGroupStateRequestData.ReadStateData _object = new ReadShareGroupStateRequestData.ReadStateData();
            JsonNode _topicIdNode = _node.get("topicId");
            if (_topicIdNode == null) {
                throw new RuntimeException("ReadStateData: unable to locate field 'topicId', which is mandatory in version " + _version);
            }
            if (!_topicIdNode.isTextual()) {
                throw new RuntimeException("ReadStateData expected a JSON string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            _object.topicId = Uuid.fromString(_topicIdNode.asText());
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("ReadStateData: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("ReadStateData expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
            }
            ArrayList<ReadShareGroupStateRequestData.PartitionData> _collection = new ArrayList<ReadShareGroupStateRequestData.PartitionData>(_partitionsNode.size());
            _object.partitions = _collection;
            for (JsonNode _element : _partitionsNode) {
                _collection.add(PartitionDataJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(ReadShareGroupStateRequestData.ReadStateData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicId", new TextNode(_object.topicId.toString()));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (ReadShareGroupStateRequestData.PartitionData _element : _object.partitions) {
                _partitionsArray.add(PartitionDataJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("partitions", _partitionsArray);
            return _node;
        }

        public static JsonNode write(ReadShareGroupStateRequestData.ReadStateData _object, short _version) {
            return ReadStateDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class PartitionDataJsonConverter {
        public static ReadShareGroupStateRequestData.PartitionData read(JsonNode _node, short _version) {
            ReadShareGroupStateRequestData.PartitionData _object = new ReadShareGroupStateRequestData.PartitionData();
            JsonNode _partitionNode = _node.get("partition");
            if (_partitionNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'partition', which is mandatory in version " + _version);
            }
            _object.partition = MessageUtil.jsonNodeToInt(_partitionNode, "PartitionData");
            JsonNode _leaderEpochNode = _node.get("leaderEpoch");
            if (_leaderEpochNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'leaderEpoch', which is mandatory in version " + _version);
            }
            _object.leaderEpoch = MessageUtil.jsonNodeToInt(_leaderEpochNode, "PartitionData");
            return _object;
        }

        public static JsonNode write(ReadShareGroupStateRequestData.PartitionData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partition", new IntNode(_object.partition));
            _node.set("leaderEpoch", new IntNode(_object.leaderEpoch));
            return _node;
        }

        public static JsonNode write(ReadShareGroupStateRequestData.PartitionData _object, short _version) {
            return PartitionDataJsonConverter.write(_object, _version, true);
        }
    }
}

