/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.sql.Observation$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.util.SparkThreadUtils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005%d\u0001B\f\u0019\u0001\u0005B\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\tk\u0001\u0011\t\u0011)A\u0005U!)a\u0007\u0001C\u0001o!)a\u0007\u0001C\u0001w!9A\b\u0001b\u0001\n\u0013i\u0004B\u0002&\u0001A\u0003%a\bC\u0004L\u0001\t\u0007I\u0011\u0002'\t\rU\u0003\u0001\u0015!\u0003N\u0011\u001d1\u0006A1A\u0005\u0002]Caa\u0017\u0001!\u0002\u0013A\u0006\"\u0002/\u0001\t\u0003i\u0006bBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003O\u0001A\u0011\u0001\r^\u0011!\t)\u0004\u0001C\u00011\u0005]\u0002\u0002CA \u0001\u0011\u0005\u0001$!\u0011\t\u0011\u00055\u0003\u0001\"\u0001\u0019\u0003\u001fB\u0001\"a\u0016\u0001\t\u0003A\u0012\u0011L\u0004\b\u00037B\u0002\u0012AA/\r\u00199\u0002\u0004#\u0001\u0002`!1ag\u0005C\u0001\u0003CBa!a\u0019\u0014\t\u0003Y\u0004bBA2'\u0011\u0005\u0011Q\r\u0002\f\u001f\n\u001cXM\u001d<bi&|gN\u0003\u0002\u001a5\u0005\u00191/\u001d7\u000b\u0005ma\u0012!B:qCJ\\'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001EA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\fAA\\1nKV\t!\u0006\u0005\u0002,e9\u0011A\u0006\r\t\u0003[\u0011j\u0011A\f\u0006\u0003_\u0001\na\u0001\u0010:p_Rt\u0014BA\u0019%\u0003\u0019\u0001&/\u001a3fM&\u00111\u0007\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005E\"\u0013!\u00028b[\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u00029uA\u0011\u0011\bA\u0007\u00021!)\u0001f\u0001a\u0001UQ\t\u0001(\u0001\u0007jgJ+w-[:uKJ,G-F\u0001?!\ty\u0004*D\u0001A\u0015\t\t%)\u0001\u0004bi>l\u0017n\u0019\u0006\u0003\u0007\u0012\u000b!bY8oGV\u0014(/\u001a8u\u0015\t)e)\u0001\u0003vi&d'\"A$\u0002\t)\fg/Y\u0005\u0003\u0013\u0002\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017!D5t%\u0016<\u0017n\u001d;fe\u0016$\u0007%A\u0004qe>l\u0017n]3\u0016\u00035\u00032A\u0014)S\u001b\u0005y%BA\"%\u0013\t\tvJA\u0004Qe>l\u0017n]3\u0011\u0005e\u001a\u0016B\u0001+\u0019\u0005\r\u0011vn^\u0001\taJ|W.[:fA\u00051a-\u001e;ve\u0016,\u0012\u0001\u0017\t\u0004\u001df\u0013\u0016B\u0001.P\u0005\u00191U\u000f^;sK\u00069a-\u001e;ve\u0016\u0004\u0013aA4fiV\ta\f\u0005\u0003,?*\n\u0017B\u000115\u0005\ri\u0015\r\u001d\t\u0003G\tL!a\u0019\u0013\u0003\u0007\u0005s\u0017\u0010K\u0002\fKF\u00042a\t4i\u0013\t9GE\u0001\u0004uQJ|wo\u001d\t\u0003S:t!A\u001b7\u000f\u00055Z\u0017\"A\u0013\n\u00055$\u0013a\u00029bG.\fw-Z\u0005\u0003_B\u0014A#\u00138uKJ\u0014X\u000f\u001d;fI\u0016C8-\u001a9uS>t'BA7%c\u0015q\"F]A\bc\u0019\u00193O^A\u0003oV\u0011\u0011\u0006\u001e\u0003\u0006k\u0002\u0012\rA\u001f\u0002\u0002)&\u0011q\u000f_\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u000b\u0005e$\u0013A\u0002;ie><8/\u0005\u0002|}B\u00111\u0005`\u0005\u0003{\u0012\u0012qAT8uQ&tw\rE\u0002\u0000\u0003\u0003q!a\t7\n\u0007\u0005\r\u0001OA\u0005UQJ|w/\u00192mKFB1%a\u0002\u0002\n\u0005-\u0011PD\u0002$\u0003\u0013I!!\u001f\u00132\u000b\t\u001aC%!\u0004\u0003\u000bM\u001c\u0017\r\\12\u0005\u0019B\u0017!C4fi\u0006\u001b(*\u0019<b+\t\t)\u0002\u0005\u0004\u0002\u0018\u0005e!&Y\u0007\u0002\t&\u0011\u0001\r\u0012\u0015\u0005\u0019\u0015\fi\"\r\u0004\u001fU\u0005}\u0011QE\u0019\u0007GM4\u0018\u0011E<2\u0011\r\n9!!\u0003\u0002$e\fTAI\u0012%\u0003\u001b\t$A\n5\u0002\u0015\u001d,Go\u0014:F[B$\u0018\u0010\u000b\u0003\u000eK\u0006-\u0012G\u0002\u0010+\u0003[\t\u0019$\r\u0004$gZ\fyc^\u0019\tG\u0005\u001d\u0011\u0011BA\u0019sF*!e\t\u0013\u0002\u000eE\u0012a\u0005[\u0001\u000f[\u0006\u00148NU3hSN$XM]3e)\t\tI\u0004E\u0002$\u0003wI1!!\u0010%\u0005\u0011)f.\u001b;\u0002'M,G/T3ue&\u001c7/\u00118e\u001d>$\u0018NZ=\u0015\t\u0005\r\u0013\u0011\n\t\u0004G\u0005\u0015\u0013bAA$I\t9!i\\8mK\u0006t\u0007BBA&\u001f\u0001\u0007!+A\u0004nKR\u0014\u0018nY:\u0002\u001b\u001d,GOU8x\u001fJ,U\u000e\u001d;z+\t\t\t\u0006\u0005\u0003$\u0003'\u0012\u0016bAA+I\t1q\n\u001d;j_:\faaZ3u%><X#\u0001*\u0002\u0017=\u00137/\u001a:wCRLwN\u001c\t\u0003sM\u0019\"a\u0005\u0012\u0015\u0005\u0005u\u0013!B1qa2LHc\u0001\u001d\u0002h!)\u0001F\u0006a\u0001U\u0001")
public class Observation {
    private final String name;
    private final AtomicBoolean isRegistered;
    private final Promise<Row> promise;
    private final Future<Row> future;

    public static Observation apply(String name) {
        return Observation$.MODULE$.apply(name);
    }

    public static Observation apply() {
        return Observation$.MODULE$.apply();
    }

    public String name() {
        return this.name;
    }

    private AtomicBoolean isRegistered() {
        return this.isRegistered;
    }

    private Promise<Row> promise() {
        return this.promise;
    }

    public Future<Row> future() {
        return this.future;
    }

    public Map<String, Object> get() throws InterruptedException {
        Row row = this.getRow();
        return row.getValuesMap((Seq<String>)((Seq)row.schema().map((Function1 & Serializable)x$1 -> x$1.name())));
    }

    public java.util.Map<String, Object> getAsJava() throws InterruptedException {
        return CollectionConverters$.MODULE$.MapHasAsJava(this.get()).asJava();
    }

    public Map<String, Object> getOrEmpty() throws InterruptedException {
        Row row = (Row)this.getRowOrEmpty().getOrElse((Function0 & Serializable)() -> Row$.MODULE$.empty());
        return row.getValuesMap((Seq<String>)((Seq)row.schema().map((Function1 & Serializable)x$2 -> x$2.name())));
    }

    public void markRegistered() {
        if (!this.isRegistered().compareAndSet(false, true)) {
            throw new IllegalArgumentException("An Observation can be used with a Dataset only once");
        }
    }

    public boolean setMetricsAndNotify(Row metrics) {
        return this.promise().trySuccess((Object)metrics);
    }

    public Option<Row> getRowOrEmpty() {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> (Row)SparkThreadUtils$.MODULE$.awaitResult(this.future(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(100)).millis())).toOption();
    }

    public Row getRow() {
        return (Row)SparkThreadUtils$.MODULE$.awaitResult(this.future(), (Duration)Duration$.MODULE$.Inf());
    }

    public Observation(String name) {
        this.name = name;
        Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(name)), (Function0 & Serializable)() -> "Name must not be empty");
        this.isRegistered = new AtomicBoolean();
        this.promise = Promise$.MODULE$.apply();
        this.future = this.promise().future();
    }

    public Observation() {
        this(UUID.randomUUID().toString());
    }
}

