/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.Serializable;
import org.apache.spark.annotation.Stable;
import org.apache.spark.sql.errors.DataTypeErrors$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.util.ArrayImplicits$;
import org.json4s.AsJsonInput$;
import org.json4s.JArray;
import org.json4s.JBool;
import org.json4s.JBool$;
import org.json4s.JDouble;
import org.json4s.JInt;
import org.json4s.JLong;
import org.json4s.JNull$;
import org.json4s.JObject;
import org.json4s.JString;
import org.json4s.JValue;
import org.json4s.jackson.JsonMethods$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Stable
public final class Metadata$
implements Serializable {
    public static final Metadata$ MODULE$ = new Metadata$();
    private static final Metadata _empty = new Metadata((Map<String, Object>)Predef$.MODULE$.Map().empty(), (Map<String, Object>)Predef$.MODULE$.Map().empty());

    public Metadata empty() {
        return _empty;
    }

    public Metadata fromJson(String json) {
        return this.fromJObject((JObject)JsonMethods$.MODULE$.parse((Object)json, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput()));
    }

    public Metadata fromJObject(JObject jObj) {
        MetadataBuilder builder = new MetadataBuilder();
        jObj.obj().foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                JValue jValue = (JValue)tuple2._2();
                if (jValue instanceof JInt) {
                    JInt jInt = (JInt)jValue;
                    BigInt value = jInt.num();
                    return builder.putLong(key, value.toLong());
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                JValue jValue = (JValue)tuple2._2();
                if (jValue instanceof JLong) {
                    JLong jLong = (JLong)jValue;
                    long value = jLong.num();
                    return builder.putLong(key, value);
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                JValue jValue = (JValue)tuple2._2();
                if (jValue instanceof JDouble) {
                    JDouble jDouble = (JDouble)jValue;
                    double value = jDouble.num();
                    return builder.putDouble(key, value);
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                JValue jValue = (JValue)tuple2._2();
                if (jValue instanceof JBool) {
                    JBool jBool = (JBool)jValue;
                    boolean value = jBool.value();
                    return builder.putBoolean(key, value);
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                JValue jValue = (JValue)tuple2._2();
                if (jValue instanceof JString) {
                    JString jString = (JString)jValue;
                    String value = jString.s();
                    return builder.putString(key, value);
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                JValue o = (JValue)tuple2._2();
                if (o instanceof JObject) {
                    JObject jObject = (JObject)o;
                    return builder.putMetadata(key, MODULE$.fromJObject(jObject));
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                JValue jValue = (JValue)tuple2._2();
                if (jValue instanceof JArray) {
                    JArray jArray = (JArray)jValue;
                    List value = jArray.arr();
                    if (value.isEmpty()) {
                        return builder.putLongArray(key, (long[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Long()));
                    }
                    JValue jValue2 = (JValue)value.head();
                    if (jValue2 instanceof JInt) {
                        return builder.putLongArray(key, (long[])value.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)Metadata$.$anonfun$fromJObject$2(x$3))).toArray((ClassTag)ClassTag$.MODULE$.Long()));
                    }
                    if (jValue2 instanceof JLong) {
                        return builder.putLongArray(key, (long[])value.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.num())).toArray((ClassTag)ClassTag$.MODULE$.Long()));
                    }
                    if (jValue2 instanceof JDouble) {
                        return builder.putDoubleArray(key, (double[])value.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToDouble((double)x$5.num())).toArray((ClassTag)ClassTag$.MODULE$.Double()));
                    }
                    if (jValue2 instanceof JBool) {
                        return builder.putBooleanArray(key, (boolean[])value.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.value())).toArray((ClassTag)ClassTag$.MODULE$.Boolean()));
                    }
                    if (jValue2 instanceof JString) {
                        return builder.putStringArray(key, (String[])value.map((Function1 & Serializable)x$7 -> x$7.s()).toArray(ClassTag$.MODULE$.apply(String.class)));
                    }
                    if (jValue2 instanceof JObject) {
                        return builder.putMetadataArray(key, (Metadata[])value.map((Function1 & Serializable)jObj -> MODULE$.fromJObject((JObject)jObj)).toArray(ClassTag$.MODULE$.apply(Metadata.class)));
                    }
                    throw DataTypeErrors$.MODULE$.unsupportedArrayTypeError(jValue2.getClass());
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                JValue jValue = (JValue)tuple2._2();
                if (JNull$.MODULE$.equals(jValue)) {
                    return builder.putNull(key);
                }
            }
            if (tuple2 != null) {
                JValue other = (JValue)tuple2._2();
                throw DataTypeErrors$.MODULE$.unsupportedJavaTypeError(other.getClass());
            }
            throw new MatchError((Object)tuple2);
        });
        return builder.build();
    }

    public JValue org$apache$spark$sql$types$Metadata$$toJsonValue(Object obj2) {
        Map<String, Object> map;
        while (true) {
            if ((map = obj2) instanceof Map) {
                Map map2 = (Map)map;
                List fields = map2.toList().map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        return new Tuple2((Object)k.toString(), (Object)MODULE$.org$apache$spark$sql$types$Metadata$$toJsonValue(v));
                    }
                    throw new MatchError((Object)tuple2);
                });
                return new JObject(fields);
            }
            if (ScalaRunTime$.MODULE$.isArray((Object)map, 1)) {
                Map<String, Object> map3 = map;
                List values = Predef$.MODULE$.genericWrapArray((Object)map3).toList().map((Function1 & Serializable)obj -> MODULE$.org$apache$spark$sql$types$Metadata$$toJsonValue(obj));
                return new JArray(values);
            }
            if (map instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)map);
                return new JInt(BigInt$.MODULE$.long2bigInt(l));
            }
            if (map instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)map);
                return new JDouble(d);
            }
            if (map instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)map);
                return JBool$.MODULE$.apply(bl);
            }
            if (map instanceof String) {
                String string = (String)map;
                return new JString(string);
            }
            if (map == null) {
                return JNull$.MODULE$;
            }
            if (!(map instanceof Metadata)) break;
            Metadata metadata = (Metadata)map;
            obj2 = metadata.map();
        }
        throw DataTypeErrors$.MODULE$.unsupportedJavaTypeError(map.getClass());
    }

    public int org$apache$spark$sql$types$Metadata$$hash(Object obj2) {
        Map<String, Object> map;
        while (true) {
            if ((map = obj2) instanceof Map) {
                Map map2 = (Map)map;
                return Statics.anyHash((Object)map2.transform((Function2 & Serializable)(x$8, v) -> BoxesRunTime.boxToInteger((int)Metadata$.MODULE$.org$apache$spark$sql$types$Metadata$$hash(v))));
            }
            if (ScalaRunTime$.MODULE$.isArray((Object)map, 1)) {
                Map<String, Object> map3 = map;
                return Statics.anyHash((Object)ArrayImplicits$.MODULE$.SparkArrayOps((Object)map3).toImmutableArraySeq().map((Function1 & Serializable)obj -> BoxesRunTime.boxToInteger((int)Metadata$.MODULE$.org$apache$spark$sql$types$Metadata$$hash(obj))));
            }
            if (map instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)map);
                return Statics.longHash((long)l);
            }
            if (map instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)map);
                return Statics.doubleHash((double)d);
            }
            if (map instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)map);
                if (bl) {
                    return 1231;
                }
                return 1237;
            }
            if (map instanceof String) {
                String string = (String)map;
                return Statics.anyHash((Object)string);
            }
            if (!(map instanceof Metadata)) break;
            Metadata metadata = (Metadata)map;
            obj2 = metadata.map();
        }
        if (map == null) {
            return 0;
        }
        throw DataTypeErrors$.MODULE$.unsupportedJavaTypeError(map.getClass());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Metadata$.class);
    }

    public static final /* synthetic */ long $anonfun$fromJObject$2(JInt x$3) {
        return x$3.num().toLong();
    }

    private Metadata$() {
    }
}

