/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.logging;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.GraphIdentifierManager$;
import org.apache.spark.sql.pipelines.graph.PipelineUpdateContext;
import org.apache.spark.sql.pipelines.graph.ResolvedFlow;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.StringContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001B\u0006\r\u0001eA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!)\u0011\u0007\u0001C\u0001e!9q\u0007\u0001b\u0001\n\u0013A\u0004B\u0002&\u0001A\u0003%\u0011\bC\u0003\u0014\u0001\u0011%1\nC\u0003U\u0001\u0011\u0005S\u000bC\u0003f\u0001\u0011\u0005c\rC\u0003l\u0001\u0011\u0005C\u000eC\u0003r\u0001\u0011%!O\u0001\bTiJ,\u0017-\u001c'jgR,g.\u001a:\u000b\u00055q\u0011a\u00027pO\u001eLgn\u001a\u0006\u0003\u001fA\t\u0011\u0002]5qK2Lg.Z:\u000b\u0005E\u0011\u0012aA:rY*\u00111\u0003F\u0001\u0006gB\f'o\u001b\u0006\u0003+Y\ta!\u00199bG\",'\"A\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Q\u0002\u0005\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e!\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0003?q\u0011ac\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010T5ti\u0016tWM\u001d\t\u0003C\u0011j\u0011A\t\u0006\u0003GI\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003K\t\u0012q\u0001T8hO&tw-A\u0002f]Z\u0004\"\u0001K\u0016\u000e\u0003%R!A\u000b\b\u0002\u000b\u001d\u0014\u0018\r\u001d5\n\u00051J#!\u0006)ja\u0016d\u0017N\\3Va\u0012\fG/Z\"p]R,\u0007\u0010^\u0001\u0012OJ\f\u0007\u000f\u001b$pe\u0016CXmY;uS>t\u0007C\u0001\u00150\u0013\t\u0001\u0014FA\u0007ECR\fg\r\\8x\u000fJ\f\u0007\u000f[\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007M*d\u0007\u0005\u00025\u00015\tA\u0002C\u0003'\u0007\u0001\u0007q\u0005C\u0003.\u0007\u0001\u0007a&A\u0004rk\u0016\u0014\u0018.Z:\u0016\u0003e\u0002BAO!D\u000f6\t1H\u0003\u0002={\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005yz\u0014\u0001B;uS2T\u0011\u0001Q\u0001\u0005U\u00064\u0018-\u0003\u0002Cw\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0005\u0011+U\"A\u001f\n\u0005\u0019k$\u0001B+V\u0013\u0012\u0003\"a\u0007%\n\u0005%c\"AD*ue\u0016\fW.\u001b8h#V,'/_\u0001\tcV,'/[3tAU\tA\n\u0005\u0002N#:\u0011ajT\u0007\u0002!%\u0011\u0001\u000bE\u0001\r'B\f'o[*fgNLwN\\\u0005\u0003%N\u0013qaU3tg&|gN\u0003\u0002Q!\u0005qqN\\)vKJL8\u000b^1si\u0016$GC\u0001,]!\t9&,D\u0001Y\u0015\u0005I\u0016!B:dC2\f\u0017BA.Y\u0005\u0011)f.\u001b;\t\u000bu;\u0001\u0019\u00010\u0002\u000b\u00154XM\u001c;\u0011\u0005}\u0013gBA\u000ea\u0013\t\tG$\u0001\fTiJ,\u0017-\\5oOF+XM]=MSN$XM\\3s\u0013\t\u0019GMA\tRk\u0016\u0014\u0018p\u0015;beR,G-\u0012<f]RT!!\u0019\u000f\u0002\u001f=t\u0017+^3ssB\u0013xn\u001a:fgN$\"AV4\t\u000buC\u0001\u0019\u00015\u0011\u0005}K\u0017B\u00016e\u0005I\tV/\u001a:z!J|wM]3tg\u00163XM\u001c;\u0002#=t\u0017+^3ssR+'/\\5oCR,G\r\u0006\u0002W[\")Q,\u0003a\u0001]B\u0011ql\\\u0005\u0003a\u0012\u0014A#U;fef$VM]7j]\u0006$X\rZ#wK:$\u0018!F4fi\u001acwn\u001e$s_6\u001cFO]3b[:\u000bW.\u001a\u000b\u0003gZ\u0004\"\u0001\u000b;\n\u0005UL#\u0001\u0004*fg>dg/\u001a3GY><\b\"B<\u000b\u0001\u0004A\u0018AC:ue\u0016\fWNT1nKB\u0019\u00110!\u0001\u000f\u0005it\bCA>Y\u001b\u0005a(BA?\u0019\u0003\u0019a$o\\8u}%\u0011q\u0010W\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0011Q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}D\u0006")
public class StreamListener
extends StreamingQueryListener
implements Logging {
    private final PipelineUpdateContext env;
    private final DataflowGraph graphForExecution;
    private final ConcurrentHashMap<UUID, StreamingQuery> queries;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentHashMap<UUID, StreamingQuery> queries() {
        return this.queries;
    }

    private SparkSession spark() {
        return SparkSession$.MODULE$.active();
    }

    public void onQueryStarted(StreamingQueryListener.QueryStartedEvent event) {
        StreamingQuery stream = this.spark().streams().get(event.id());
        this.queries().put(event.runId(), stream);
        this.env.flowProgressEventLogger().recordRunning(this.getFlowFromStreamName(stream.name()));
    }

    public void onQueryProgress(StreamingQueryListener.QueryProgressEvent event) {
    }

    public void onQueryTerminated(StreamingQueryListener.QueryTerminatedEvent event) {
        if (!this.queries().containsKey(event.runId())) {
            return;
        }
        StreamingQuery stream = this.queries().remove(event.runId());
        this.env.flowProgressEventLogger().recordCompletion(this.getFlowFromStreamName(stream.name()));
    }

    private ResolvedFlow getFlowFromStreamName(String streamName) {
        TableIdentifier flowIdentifier = GraphIdentifierManager$.MODULE$.parseTableIdentifier(streamName, this.env.spark());
        return (ResolvedFlow)this.graphForExecution.resolvedFlow().apply((Object)flowIdentifier);
    }

    public StreamListener(PipelineUpdateContext env, DataflowGraph graphForExecution) {
        this.env = env;
        this.graphForExecution = graphForExecution;
        Logging.$init$((Logging)this);
        this.queries = new ConcurrentHashMap();
    }
}

