/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.logging;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.pipelines.common.FlowStatus;
import org.apache.spark.sql.pipelines.common.FlowStatus$COMPLETED$;
import org.apache.spark.sql.pipelines.common.FlowStatus$EXCLUDED$;
import org.apache.spark.sql.pipelines.common.FlowStatus$FAILED$;
import org.apache.spark.sql.pipelines.common.FlowStatus$IDLE$;
import org.apache.spark.sql.pipelines.common.FlowStatus$PLANNING$;
import org.apache.spark.sql.pipelines.common.FlowStatus$QUEUED$;
import org.apache.spark.sql.pipelines.common.FlowStatus$RUNNING$;
import org.apache.spark.sql.pipelines.common.FlowStatus$SKIPPED$;
import org.apache.spark.sql.pipelines.common.FlowStatus$STARTING$;
import org.apache.spark.sql.pipelines.common.FlowStatus$STOPPED$;
import org.apache.spark.sql.pipelines.graph.FlowExecution;
import org.apache.spark.sql.pipelines.graph.QueryOrigin;
import org.apache.spark.sql.pipelines.graph.ResolutionCompletedFlow;
import org.apache.spark.sql.pipelines.graph.ResolvedFlow;
import org.apache.spark.sql.pipelines.logging.ConstructPipelineEvent$;
import org.apache.spark.sql.pipelines.logging.EventLevel;
import org.apache.spark.sql.pipelines.logging.EventLevel$ERROR$;
import org.apache.spark.sql.pipelines.logging.EventLevel$INFO$;
import org.apache.spark.sql.pipelines.logging.EventLevel$WARN$;
import org.apache.spark.sql.pipelines.logging.FlowProgress;
import org.apache.spark.sql.pipelines.logging.PipelineEventOrigin;
import org.apache.spark.sql.pipelines.logging.PipelineRunEventBuffer;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.StringContext;
import scala.collection.concurrent.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ed\u0001B\u000b\u0017\u0001\rB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\u0006k\u0001!\tA\u000e\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019a\u0005\u0001)A\u0005w!9Q\n\u0001b\u0001\n\u0013q\u0005B\u0002,\u0001A\u0003%q\nC\u0003X\u0001\u0011\u0005\u0001\fC\u0003e\u0001\u0011\u0005Q\rC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003p\u0001\u0011\u0005\u0001\u000fC\u0003s\u0001\u0011\u00051\u000fC\u0005\u0002,\u0001\t\n\u0011\"\u0001\u0002.!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003bBA%\u0001\u0011\u0005\u00111\n\u0005\b\u0003\u001f\u0002A\u0011AA)\u0011\u001d\t)\u0006\u0001C\u0001\u0003/B\u0011\"!\u001a\u0001#\u0003%\t!!\f\t\u0013\u0005\u001d\u0004!%A\u0005\u0002\u0005%\u0004bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003g\u0002A\u0011AA;\u0005]1En\\<Qe><'/Z:t\u000bZ,g\u000e\u001e'pO\u001e,'O\u0003\u0002\u00181\u00059An\\4hS:<'BA\r\u001b\u0003%\u0001\u0018\u000e]3mS:,7O\u0003\u0002\u001c9\u0005\u00191/\u001d7\u000b\u0005uq\u0012!B:qCJ\\'BA\u0010!\u0003\u0019\t\u0007/Y2iK*\t\u0011%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001I)\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0007CA\u0016/\u001b\u0005a#BA\u0017\u001d\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0018-\u0005\u001daunZ4j]\u001e\f1\"\u001a<f]R\u0014UO\u001a4feB\u0011!gM\u0007\u0002-%\u0011AG\u0006\u0002\u0017!&\u0004X\r\\5oKJ+h.\u0012<f]R\u0014UO\u001a4fe\u00061A(\u001b8jiz\"\"a\u000e\u001d\u0011\u0005I\u0002\u0001\"\u0002\u0019\u0003\u0001\u0004\t\u0014\u0001\u0004:v]:Lgn\u001a$m_^\u001cX#A\u001e\u0011\tq\n5)S\u0007\u0002{)\u0011ahP\u0001\u000bG>t7-\u001e:sK:$(B\u0001!'\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0005v\u00121!T1q!\t!u)D\u0001F\u0015\t1%$\u0001\u0005dCR\fG._:u\u0013\tAUIA\bUC\ndW-\u00133f]RLg-[3s!\t)#*\u0003\u0002LM\t9!i\\8mK\u0006t\u0017!\u0004:v]:Lgn\u001a$m_^\u001c\b%\u0001\bl]><h.\u00133mK\u001acwn^:\u0016\u0003=\u0003B\u0001P!D!B\u0011\u0011\u000bV\u0007\u0002%*\u00111\u000bG\u0001\u0007G>lWn\u001c8\n\u0005U\u0013&A\u0003$m_^\u001cF/\u0019;vg\u0006y1N\\8x]&#G.\u001a$m_^\u001c\b%\u0001\u0007sK\u000e|'\u000fZ)vKV,G\r\u0006\u0002Z9B\u0011QEW\u0005\u00037\u001a\u0012A!\u00168ji\")Ql\u0002a\u0001=\u0006!a\r\\8x!\ty&-D\u0001a\u0015\t\t\u0007$A\u0003he\u0006\u0004\b.\u0003\u0002dA\na!+Z:pYZ,GM\u00127po\u0006Q\"/Z2pe\u0012\u0004F.\u00198oS:<gi\u001c:CCR\u001c\u0007N\u00127poR\u0011\u0011L\u001a\u0005\u0006O\"\u0001\rAX\u0001\nE\u0006$8\r\u001b$m_^\f1B]3d_J$7\u000b^1siR\u0011\u0011L\u001b\u0005\u0006W&\u0001\r\u0001\\\u0001\u000eM2|w/\u0012=fGV$\u0018n\u001c8\u0011\u0005}k\u0017B\u00018a\u000551En\\<Fq\u0016\u001cW\u000f^5p]\u0006i!/Z2pe\u0012\u0014VO\u001c8j]\u001e$\"!W9\t\u000buS\u0001\u0019\u00010\u0002\u0019I,7m\u001c:e\r\u0006LG.\u001a3\u0015\u000fe#\b0!\u0004\u0002\u0012!)Ql\u0003a\u0001kB\u0011qL^\u0005\u0003o\u0002\u0014qCU3t_2,H/[8o\u0007>l\u0007\u000f\\3uK\u00124En\\<\t\u000be\\\u0001\u0019\u0001>\u0002\u0013\u0015D8-\u001a9uS>t\u0007cA>\u0002\b9\u0019A0a\u0001\u000f\u0007u\f\t!D\u0001\u007f\u0015\ty(%\u0001\u0004=e>|GOP\u0005\u0002O%\u0019\u0011Q\u0001\u0014\u0002\u000fA\f7m[1hK&!\u0011\u0011BA\u0006\u0005%!\u0006N]8xC\ndWMC\u0002\u0002\u0006\u0019Ba!a\u0004\f\u0001\u0004I\u0015!\u00037pO\u0006\u001bx+\u0019:o\u0011%\t\u0019b\u0003I\u0001\u0002\u0004\t)\"\u0001\u0006nKN\u001c\u0018mZ3PaR\u0004R!JA\f\u00037I1!!\u0007'\u0005\u0019y\u0005\u000f^5p]B!\u0011QDA\u0013\u001d\u0011\ty\"!\t\u0011\u0005u4\u0013bAA\u0012M\u00051\u0001K]3eK\u001aLA!a\n\u0002*\t11\u000b\u001e:j]\u001eT1!a\t'\u0003Y\u0011XmY8sI\u001a\u000b\u0017\u000e\\3eI\u0011,g-Y;mi\u0012\"TCAA\u0018U\u0011\t)\"!\r,\u0005\u0005M\u0002\u0003BA\u001b\u0003\u007fi!!a\u000e\u000b\t\u0005e\u00121H\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0010'\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0003\n9DA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\faD]3d_J$7k[5qa\u0016$wJ\\+q'R\u0014X-Y7GC&dWO]3\u0015\u0007e\u000b9\u0005C\u0003^\u001b\u0001\u0007a,A\u0007sK\u000e|'\u000fZ*lSB\u0004X\r\u001a\u000b\u00043\u00065\u0003\"B/\u000f\u0001\u0004q\u0016A\u0004:fG>\u0014H-\u0012=dYV$W\r\u001a\u000b\u00043\u0006M\u0003\"B/\u0010\u0001\u0004q\u0016A\u0003:fG>\u0014Hm\u0015;paR9\u0011,!\u0017\u0002\\\u0005}\u0003\"B/\u0011\u0001\u0004q\u0006\"CA/!A\u0005\t\u0019AA\u000b\u0003\u001diWm]:bO\u0016D\u0011\"!\u0019\u0011!\u0003\u0005\r!a\u0019\u0002\u000b\r\fWo]3\u0011\t\u0015\n9B_\u0001\u0015e\u0016\u001cwN\u001d3Ti>\u0004H\u0005Z3gCVdG\u000f\n\u001a\u0002)I,7m\u001c:e'R|\u0007\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tYG\u000b\u0003\u0002d\u0005E\u0012A\u0003:fG>\u0014H-\u00133mKR\u0019\u0011,!\u001d\t\u000bu\u001b\u0002\u0019\u00010\u0002!I,7m\u001c:e\u0007>l\u0007\u000f\\3uS>tGcA-\u0002x!)Q\f\u0006a\u0001=\u0002")
public class FlowProgressEventLogger
implements Logging {
    private final PipelineRunEventBuffer eventBuffer;
    private final Map<TableIdentifier, Object> runningFlows;
    private final Map<TableIdentifier, FlowStatus> knownIdleFlows;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Map<TableIdentifier, Object> runningFlows() {
        return this.runningFlows;
    }

    private Map<TableIdentifier, FlowStatus> knownIdleFlows() {
        return this.knownIdleFlows;
    }

    public synchronized void recordQueued(ResolvedFlow flow) {
        Option x$1 = Option$.MODULE$.apply((Object)flow.displayName());
        None$ x$2 = None$.MODULE$;
        Option x$3 = Option$.MODULE$.apply((Object)flow.origin());
        this.eventBuffer.addEvent(ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$INFO$.MODULE$, "Flow " + flow.displayName() + " is QUEUED.", new FlowProgress(FlowStatus$QUEUED$.MODULE$), ConstructPipelineEvent$.MODULE$.apply$default$5(), ConstructPipelineEvent$.MODULE$.apply$default$6()));
    }

    public void recordPlanningForBatchFlow(ResolvedFlow batchFlow) {
        block4: {
            FlowProgressEventLogger flowProgressEventLogger = this;
            synchronized (flowProgressEventLogger) {
                block3: {
                    if (batchFlow.df().isStreaming()) break block3;
                    Option x$1 = Option$.MODULE$.apply((Object)batchFlow.displayName());
                    None$ x$2 = None$.MODULE$;
                    Option x$3 = Option$.MODULE$.apply((Object)batchFlow.origin());
                    this.eventBuffer.addEvent(ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$INFO$.MODULE$, "Flow " + batchFlow.displayName() + " is PLANNING.", new FlowProgress(FlowStatus$PLANNING$.MODULE$), ConstructPipelineEvent$.MODULE$.apply$default$5(), ConstructPipelineEvent$.MODULE$.apply$default$6()));
                    this.knownIdleFlows().remove((Object)batchFlow.identifier());
                    break block4;
                }
                return;
            }
        }
    }

    public void recordStart(FlowExecution flowExecution) {
        FlowProgressEventLogger flowProgressEventLogger = this;
        synchronized (flowProgressEventLogger) {
            Option x$1 = Option$.MODULE$.apply((Object)flowExecution.displayName());
            None$ x$2 = None$.MODULE$;
            Option x$3 = Option$.MODULE$.apply((Object)flowExecution.getOrigin());
            this.eventBuffer.addEvent(ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$INFO$.MODULE$, "Flow " + flowExecution.displayName() + " is STARTING.", new FlowProgress(FlowStatus$STARTING$.MODULE$), ConstructPipelineEvent$.MODULE$.apply$default$5(), ConstructPipelineEvent$.MODULE$.apply$default$6()));
            this.knownIdleFlows().remove((Object)flowExecution.identifier());
        }
    }

    public void recordRunning(ResolvedFlow flow) {
        FlowProgressEventLogger flowProgressEventLogger = this;
        synchronized (flowProgressEventLogger) {
            Option x$1 = Option$.MODULE$.apply((Object)flow.displayName());
            None$ x$2 = None$.MODULE$;
            Option x$3 = Option$.MODULE$.apply((Object)flow.origin());
            this.eventBuffer.addEvent(ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$INFO$.MODULE$, "Flow " + flow.displayName() + " is RUNNING.", new FlowProgress(FlowStatus$RUNNING$.MODULE$), ConstructPipelineEvent$.MODULE$.apply$default$5(), ConstructPipelineEvent$.MODULE$.apply$default$6()));
            this.runningFlows().put((Object)flow.identifier(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.knownIdleFlows().remove((Object)flow.identifier());
        }
    }

    public void recordFailed(ResolutionCompletedFlow flow, Throwable exception, boolean logAsWarn, Option<String> messageOpt) {
        FlowProgressEventLogger flowProgressEventLogger = this;
        synchronized (flowProgressEventLogger) {
            String eventLogMessage = (String)messageOpt.getOrElse((Function0 & Serializable)() -> "Flow '" + flow.displayName() + "' has FAILED.");
            Option x$1 = Option$.MODULE$.apply((Object)flow.displayName());
            None$ x$2 = None$.MODULE$;
            Option x$3 = Option$.MODULE$.apply((Object)flow.origin());
            this.eventBuffer.addEvent(ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), (EventLevel)(logAsWarn ? EventLevel$WARN$.MODULE$ : EventLevel$ERROR$.MODULE$), eventLogMessage, new FlowProgress(FlowStatus$FAILED$.MODULE$), (Option<Throwable>)Option$.MODULE$.apply((Object)exception), ConstructPipelineEvent$.MODULE$.apply$default$6()));
            this.runningFlows().remove((Object)flow.identifier());
            this.knownIdleFlows().remove((Object)flow.identifier());
        }
    }

    public Option<String> recordFailed$default$4() {
        return None$.MODULE$;
    }

    public void recordSkippedOnUpStreamFailure(ResolvedFlow flow) {
        FlowProgressEventLogger flowProgressEventLogger = this;
        synchronized (flowProgressEventLogger) {
            Option x$1 = Option$.MODULE$.apply((Object)flow.displayName());
            None$ x$2 = None$.MODULE$;
            Option x$3 = Option$.MODULE$.apply((Object)flow.origin());
            this.eventBuffer.addEvent(ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$WARN$.MODULE$, "Flow '" + flow.displayName() + "' SKIPPED due to upstream failure(s).", new FlowProgress(FlowStatus$SKIPPED$.MODULE$), ConstructPipelineEvent$.MODULE$.apply$default$5(), ConstructPipelineEvent$.MODULE$.apply$default$6()));
            this.runningFlows().remove((Object)flow.identifier());
            this.knownIdleFlows().remove((Object)flow.identifier());
        }
    }

    public void recordSkipped(ResolvedFlow flow) {
        FlowProgressEventLogger flowProgressEventLogger = this;
        synchronized (flowProgressEventLogger) {
            Option x$1 = Option$.MODULE$.apply((Object)flow.displayName());
            None$ x$2 = None$.MODULE$;
            Option x$3 = Option$.MODULE$.apply((Object)flow.origin());
            this.eventBuffer.addEvent(ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$INFO$.MODULE$, "Flow '" + flow.displayName() + "' has been processed by a previous iteration and will not be rerun.", new FlowProgress(FlowStatus$SKIPPED$.MODULE$), ConstructPipelineEvent$.MODULE$.apply$default$5(), ConstructPipelineEvent$.MODULE$.apply$default$6()));
            this.knownIdleFlows().put((Object)flow.identifier(), (Object)FlowStatus$SKIPPED$.MODULE$);
        }
    }

    public void recordExcluded(ResolvedFlow flow) {
        FlowProgressEventLogger flowProgressEventLogger = this;
        synchronized (flowProgressEventLogger) {
            Option x$1 = Option$.MODULE$.apply((Object)flow.displayName());
            None$ x$2 = None$.MODULE$;
            Option x$3 = Option$.MODULE$.apply((Object)flow.origin());
            this.eventBuffer.addEvent(ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$INFO$.MODULE$, "Flow '" + flow.displayName() + "' is EXCLUDED.", new FlowProgress(FlowStatus$EXCLUDED$.MODULE$), ConstructPipelineEvent$.MODULE$.apply$default$5(), ConstructPipelineEvent$.MODULE$.apply$default$6()));
            this.knownIdleFlows().remove((Object)flow.identifier());
        }
    }

    public void recordStop(ResolvedFlow flow, Option<String> message, Option<Throwable> cause) {
        FlowProgressEventLogger flowProgressEventLogger = this;
        synchronized (flowProgressEventLogger) {
            Option x$1 = Option$.MODULE$.apply((Object)flow.displayName());
            None$ x$2 = None$.MODULE$;
            Option x$3 = Option$.MODULE$.apply((Object)flow.origin());
            this.eventBuffer.addEvent(ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$INFO$.MODULE$, (String)message.getOrElse((Function0 & Serializable)() -> "Flow '" + flow.displayName() + "' has STOPPED."), new FlowProgress(FlowStatus$STOPPED$.MODULE$), cause, ConstructPipelineEvent$.MODULE$.apply$default$6()));
            this.runningFlows().remove((Object)flow.identifier());
            this.knownIdleFlows().remove((Object)flow.identifier());
        }
    }

    public Option<String> recordStop$default$2() {
        return None$.MODULE$;
    }

    public Option<Throwable> recordStop$default$3() {
        return None$.MODULE$;
    }

    public void recordIdle(ResolvedFlow flow) {
        FlowProgressEventLogger flowProgressEventLogger = this;
        synchronized (flowProgressEventLogger) {
            Option x$1 = Option$.MODULE$.apply((Object)flow.displayName());
            None$ x$2 = None$.MODULE$;
            Option x$3 = Option$.MODULE$.apply((Object)flow.origin());
            this.eventBuffer.addEvent(ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$INFO$.MODULE$, "Flow '" + flow.displayName() + "' is IDLE, waiting for new data.", new FlowProgress(FlowStatus$IDLE$.MODULE$), ConstructPipelineEvent$.MODULE$.apply$default$5(), ConstructPipelineEvent$.MODULE$.apply$default$6()));
            this.knownIdleFlows().put((Object)flow.identifier(), (Object)FlowStatus$IDLE$.MODULE$);
        }
    }

    public void recordCompletion(ResolvedFlow flow) {
        FlowProgressEventLogger flowProgressEventLogger = this;
        synchronized (flowProgressEventLogger) {
            Option x$1 = Option$.MODULE$.apply((Object)flow.displayName());
            None$ x$2 = None$.MODULE$;
            Option x$3 = Option$.MODULE$.apply((Object)flow.origin());
            this.eventBuffer.addEvent(ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$INFO$.MODULE$, "Flow " + flow.displayName() + " has COMPLETED.", new FlowProgress(FlowStatus$COMPLETED$.MODULE$), ConstructPipelineEvent$.MODULE$.apply$default$5(), ConstructPipelineEvent$.MODULE$.apply$default$6()));
            this.knownIdleFlows().remove((Object)flow.identifier());
        }
    }

    public FlowProgressEventLogger(PipelineRunEventBuffer eventBuffer) {
        this.eventBuffer = eventBuffer;
        Logging.$init$((Logging)this);
        this.runningFlows = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        this.knownIdleFlows = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
    }
}

