/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.pipelines.common.RunState$FAILED$;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.DatasetManager$;
import org.apache.spark.sql.pipelines.graph.PipelineUpdateContext;
import org.apache.spark.sql.pipelines.graph.QueryOrigin;
import org.apache.spark.sql.pipelines.graph.ResolutionFailedFlow;
import org.apache.spark.sql.pipelines.graph.RunTerminationReason;
import org.apache.spark.sql.pipelines.graph.TriggeredGraphExecution;
import org.apache.spark.sql.pipelines.graph.TriggeredGraphExecution$;
import org.apache.spark.sql.pipelines.graph.UnresolvedPipelineException;
import org.apache.spark.sql.pipelines.logging.ConstructPipelineEvent$;
import org.apache.spark.sql.pipelines.logging.EventLevel$ERROR$;
import org.apache.spark.sql.pipelines.logging.EventLevel$INFO$;
import org.apache.spark.sql.pipelines.logging.PipelineEventOrigin;
import org.apache.spark.sql.pipelines.logging.RunProgress;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005E3A!\u0004\b\u00017!A!\u0005\u0001B\u0001B\u0003%1\u0005C\u0003(\u0001\u0011\u0005\u0001\u0006\u0003\u0005,\u0001\u0001\u0007I\u0011\u0001\t-\u0011!\u0019\u0004\u00011A\u0005\u0002A!\u0004B\u0002\u001e\u0001A\u0003&Q\u0006C\u0003<\u0001\u0011\u0005A\bC\u0003A\u0001\u0011\u0005\u0011\tC\u0003C\u0001\u0011\u0005\u0011\tC\u0003D\u0001\u0011%A\t\u0003\u0004I\u0001\u0011\u0005!#\u0011\u0005\u0006\u0013\u0002!IA\u0013\u0005\u0006!\u0002!\t!\u0011\u0002\u0012!&\u0004X\r\\5oK\u0016CXmY;uS>t'BA\b\u0011\u0003\u00159'/\u00199i\u0015\t\t\"#A\u0005qSB,G.\u001b8fg*\u00111\u0003F\u0001\u0004gFd'BA\u000b\u0017\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0002$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00023\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0002\u000f\r|g\u000e^3yiB\u0011A%J\u0007\u0002\u001d%\u0011aE\u0004\u0002\u0016!&\u0004X\r\\5oKV\u0003H-\u0019;f\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0011\u0011F\u000b\t\u0003I\u0001AQA\t\u0002A\u0002\r\nab\u001a:ba\",\u00050Z2vi&|g.F\u0001.!\rib\u0006M\u0005\u0003_y\u0011aa\u00149uS>t\u0007C\u0001\u00132\u0013\t\u0011dBA\fUe&<w-\u001a:fI\u001e\u0013\u0018\r\u001d5Fq\u0016\u001cW\u000f^5p]\u0006\u0011rM]1qQ\u0016CXmY;uS>tw\fJ3r)\t)\u0004\b\u0005\u0002\u001em%\u0011qG\b\u0002\u0005+:LG\u000fC\u0004:\t\u0005\u0005\t\u0019A\u0017\u0002\u0007a$\u0013'A\bhe\u0006\u0004\b.\u0012=fGV$\u0018n\u001c8!\u0003A)\u00070Z2vi&|gn\u0015;beR,G-F\u0001>!\tib(\u0003\u0002@=\t9!i\\8mK\u0006t\u0017!D:uCJ$\b+\u001b9fY&tW\rF\u00016\u0003-\u0011XO\u001c)ja\u0016d\u0017N\\3\u0002\u001f%t\u0017\u000e^5bY&TXm\u0012:ba\"$\u0012!\u0012\t\u0003I\u0019K!a\u0012\b\u0003\u001b\u0011\u000bG/\u00194m_^<%/\u00199i\u0003=\tw/Y5u\u0007>l\u0007\u000f\\3uS>t\u0017!\u00065b]\u0012dW-\u00138wC2LG\rU5qK2Lg.\u001a\u000b\u0003k-CQ\u0001T\u0006A\u00025\u000b\u0011!\u001a\t\u0003I9K!a\u0014\b\u00037Us'/Z:pYZ,G\rU5qK2Lg.Z#yG\u0016\u0004H/[8o\u00031\u0019Ho\u001c9QSB,G.\u001b8f\u0001")
public class PipelineExecution {
    private final PipelineUpdateContext context;
    private Option<TriggeredGraphExecution> graphExecution;

    public Option<TriggeredGraphExecution> graphExecution() {
        return this.graphExecution;
    }

    public void graphExecution_$eq(Option<TriggeredGraphExecution> x$1) {
        this.graphExecution = x$1;
    }

    public synchronized boolean executionStarted() {
        return this.graphExecution().nonEmpty();
    }

    public synchronized void startPipeline() {
        DataflowGraph initializedGraph = this.initializeGraph();
        this.graphExecution_$eq((Option<TriggeredGraphExecution>)Option$.MODULE$.apply((Object)new TriggeredGraphExecution(initializedGraph, this.context, (Function1<RunTerminationReason, BoxedUnit>)(Function1 & Serializable)terminationReason -> {
            PipelineExecution.$anonfun$startPipeline$1(this, terminationReason);
            return BoxedUnit.UNIT;
        }, TriggeredGraphExecution$.MODULE$.$lessinit$greater$default$4())));
        this.graphExecution().foreach((Function1 & Serializable)x$1 -> {
            x$1.start();
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void runPipeline() {
        try {
            this.startPipeline();
            this.context.pipelineExecution().awaitCompletion();
        }
        catch (Throwable e) {
            None$ x$1 = None$.MODULE$;
            None$ x$2 = None$.MODULE$;
            None$ x$3 = None$.MODULE$;
            PipelineEventOrigin x$4 = new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3);
            String x$5 = "Pipeline execution failed.";
            RunProgress x$6 = new RunProgress(RunState$FAILED$.MODULE$);
            Option x$7 = Option$.MODULE$.apply((Object)e);
            EventLevel$ERROR$ x$8 = EventLevel$ERROR$.MODULE$;
            Option<Timestamp> x$9 = ConstructPipelineEvent$.MODULE$.apply$default$6();
            this.context.eventBuffer().addEvent(ConstructPipelineEvent$.MODULE$.apply(x$4, x$8, "Pipeline execution failed.", x$6, (Option<Throwable>)x$7, x$9));
        }
    }

    private DataflowGraph initializeGraph() {
        DataflowGraph dataflowGraph;
        try {
            dataflowGraph = this.context.unresolvedGraph().resolve().validate();
        }
        catch (UnresolvedPipelineException e) {
            this.handleInvalidPipeline(e);
            throw e;
        }
        DataflowGraph resolvedGraph = dataflowGraph;
        return DatasetManager$.MODULE$.materializeDatasets(resolvedGraph, this.context);
    }

    public void awaitCompletion() {
        this.graphExecution().foreach((Function1 & Serializable)x$2 -> {
            x$2.awaitCompletion();
            return BoxedUnit.UNIT;
        });
    }

    private void handleInvalidPipeline(UnresolvedPipelineException e) {
        e.downstreamFailures().foreach((Function1 & Serializable)failure -> {
            PipelineExecution.$anonfun$handleInvalidPipeline$1(this, e, failure);
            return BoxedUnit.UNIT;
        });
        e.directFailures().foreach((Function1 & Serializable)failure -> {
            PipelineExecution.$anonfun$handleInvalidPipeline$2(this, e, failure);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void stopPipeline() {
        ((TriggeredGraphExecution)this.graphExecution().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Pipeline execution has not started yet.");
        })).stop();
    }

    public static final /* synthetic */ void $anonfun$startPipeline$1(PipelineExecution $this, RunTerminationReason terminationReason) {
        None$ x$1 = None$.MODULE$;
        None$ x$2 = None$.MODULE$;
        None$ x$3 = None$.MODULE$;
        $this.context.eventBuffer().addEvent(ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$INFO$.MODULE$, terminationReason.message(), new RunProgress(terminationReason.terminalState()), terminationReason.cause(), ConstructPipelineEvent$.MODULE$.apply$default$6()));
    }

    public static final /* synthetic */ void $anonfun$handleInvalidPipeline$1(PipelineExecution $this, UnresolvedPipelineException e$1, Tuple2 failure) {
        Tuple2 tuple2 = failure;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TableIdentifier flowIdentifier = (TableIdentifier)tuple2._1();
        Throwable ex = (Throwable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)flowIdentifier, (Object)ex);
        TableIdentifier flowIdentifier2 = (TableIdentifier)tuple22._1();
        Throwable ex2 = (Throwable)tuple22._2();
        ResolutionFailedFlow flow = (ResolutionFailedFlow)e$1.graph().resolutionFailedFlow().apply((Object)flowIdentifier2);
        $this.context.flowProgressEventLogger().recordFailed(flow, ex2, true, (Option<String>)Option$.MODULE$.apply((Object)("Failed to resolve flow due to upstream failure: '" + flow.displayName() + "'.")));
    }

    public static final /* synthetic */ void $anonfun$handleInvalidPipeline$2(PipelineExecution $this, UnresolvedPipelineException e$1, Tuple2 failure) {
        Tuple2 tuple2 = failure;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TableIdentifier flowIdentifier = (TableIdentifier)tuple2._1();
        Throwable ex = (Throwable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)flowIdentifier, (Object)ex);
        TableIdentifier flowIdentifier2 = (TableIdentifier)tuple22._1();
        Throwable ex2 = (Throwable)tuple22._2();
        ResolutionFailedFlow flow = (ResolutionFailedFlow)e$1.graph().resolutionFailedFlow().apply((Object)flowIdentifier2);
        $this.context.flowProgressEventLogger().recordFailed(flow, ex2, true, (Option<String>)Option$.MODULE$.apply((Object)("Failed to resolve flow: '" + flow.displayName() + "'.")));
    }

    public PipelineExecution(PipelineUpdateContext context) {
        this.context = context;
        this.graphExecution = None$.MODULE$;
    }
}

