/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.pipelines.common.DatasetType;
import org.apache.spark.sql.pipelines.graph.CircularDependencyException;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.DataflowGraph$;
import org.apache.spark.sql.pipelines.graph.Flow;
import org.apache.spark.sql.pipelines.graph.FlowFunctionResult;
import org.apache.spark.sql.pipelines.graph.GraphElement;
import org.apache.spark.sql.pipelines.graph.GraphElementTypeUtils$;
import org.apache.spark.sql.pipelines.graph.GraphErrors$;
import org.apache.spark.sql.pipelines.graph.GraphOperations;
import org.apache.spark.sql.pipelines.graph.GraphValidations$;
import org.apache.spark.sql.pipelines.graph.PersistedView;
import org.apache.spark.sql.pipelines.graph.PipelinesTableProperties$;
import org.apache.spark.sql.pipelines.graph.ResolutionCompletedFlow;
import org.apache.spark.sql.pipelines.graph.ResolutionFailedFlow;
import org.apache.spark.sql.pipelines.graph.ResolvedFlow;
import org.apache.spark.sql.pipelines.graph.Table;
import org.apache.spark.sql.pipelines.graph.TableInput;
import org.apache.spark.sql.pipelines.graph.TemporaryView;
import org.apache.spark.sql.pipelines.graph.UnresolvedPipelineException;
import org.apache.spark.sql.pipelines.graph.UnresolvedPipelineException$;
import org.apache.spark.sql.pipelines.graph.View;
import org.apache.spark.sql.pipelines.graph.ViewHelpers$;
import org.apache.spark.sql.pipelines.util.SchemaInferenceUtils$;
import org.apache.spark.sql.types.StructType;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u001d4\u0001b\u0003\u0007\u0011\u0002\u0007\u0005\u0011\u0004\u001a\u0005\u0006M\u0001!\ta\n\u0005\u0007W\u0001!\tB\u0004\u0017\t\r-\u0003A\u0011\u0003\u0007(\u0011\u0019a\u0005\u0001\"\u0005\rO!)Q\n\u0001C\tO!)Q\n\u0001C\t\u001d\")Q\u000b\u0001C\tO!)a\u000b\u0001C\tO!)q\u000b\u0001C\u00051\"11\r\u0001C\t\u0019\u001d\u0012\u0001c\u0012:ba\"4\u0016\r\\5eCRLwN\\:\u000b\u00055q\u0011!B4sCBD'BA\b\u0011\u0003%\u0001\u0018\u000e]3mS:,7O\u0003\u0002\u0012%\u0005\u00191/\u001d7\u000b\u0005M!\u0012!B:qCJ\\'BA\u000b\u0017\u0003\u0019\t\u0007/Y2iK*\tq#A\u0002pe\u001e\u001c\u0001aE\u0002\u00015\u0001\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a!\u00118z%\u00164\u0007CA\u0011%\u001b\u0005\u0011#BA\u0012\u0013\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0013#\u0005\u001daunZ4j]\u001e\fa\u0001J5oSR$C#\u0001\u0015\u0011\u0005mI\u0013B\u0001\u0016\u001d\u0005\u0011)f.\u001b;\u00021Y\fG.\u001b3bi\u0016lU\u000f\u001c;j#V,'/\u001f+bE2,7\u000fF\u0001.!\u0011qS\u0007\u000f \u000f\u0005=\u001a\u0004C\u0001\u0019\u001d\u001b\u0005\t$B\u0001\u001a\u0019\u0003\u0019a$o\\8u}%\u0011A\u0007H\u0001\u0007!J,G-\u001a4\n\u0005Y:$aA'ba*\u0011A\u0007\b\t\u0003sqj\u0011A\u000f\u0006\u0003wA\t\u0001bY1uC2L8\u000f^\u0005\u0003{i\u0012q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM\u001d\t\u0004\u007f\u0011;eB\u0001!C\u001d\t\u0001\u0014)C\u0001\u001e\u0013\t\u0019E$A\u0004qC\u000e\\\u0017mZ3\n\u0005\u00153%aA*fc*\u00111\t\b\t\u0003\u0011&k\u0011\u0001D\u0005\u0003\u00152\u0011AA\u00127po\u0006Ib/\u00197jI\u0006$XM\u00127poN#(/Z1nS:<g.Z:t\u0003\t2\u0018\r\\5eCR,wI]1qQ&\u001bHk\u001c9pY><\u0017nY1mYf\u001cvN\u001d;fI\u0006Yb/\u00197jI\u0006$X\rV1cY\u0016\u001c\u0018I]3SKN,G\u000f^1cY\u0016$\"\u0001K(\t\u000bA3\u0001\u0019A)\u0002\rQ\f'\r\\3t!\ryDI\u0015\t\u0003\u0011NK!\u0001\u0016\u0007\u0003\u000bQ\u000b'\r\\3\u00029Y\fG.\u001b3bi\u0016,6/\u001a:Ta\u0016\u001c\u0017NZ5fIN\u001b\u0007.Z7bg\u0006qb/\u00197jI\u0006$XmU;dG\u0016\u001c8OZ;m\r2|w/\u00118bYf\u001c\u0018n]\u0001\fI\u0016$Xm\u0019;Ds\u000edW\r\u0006\u0002Z?B\u00191D\u0017/\n\u0005mc\"AB(qi&|g\u000e\u0005\u0003\u001c;bB\u0014B\u00010\u001d\u0005\u0019!V\u000f\u001d7fe!)\u0001-\u0003a\u0001C\u0006I\u0011M\\2fgR|'o\u001d\t\u0005]UB$\rE\u0002@\tb\nAD^1mS\u0012\fG/\u001a)feNL7\u000f^3e-&,woU8ve\u000e,7\u000f\u0005\u0002IK&\u0011a\r\u0004\u0002\u000e\t\u0006$\u0018M\u001a7po\u001e\u0013\u0018\r\u001d5")
public interface GraphValidations
extends Logging {
    public static /* synthetic */ Map validateMultiQueryTables$(GraphValidations $this) {
        return $this.validateMultiQueryTables();
    }

    default public Map<TableIdentifier, Seq<Flow>> validateMultiQueryTables() {
        Map multiQueryTables = (Map)((DataflowGraph)this).flowsTo().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GraphValidations.$anonfun$validateMultiQueryTables$1(x$1)));
        multiQueryTables.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)GraphValidations.$anonfun$validateMultiQueryTables$2(this, x0$1))).foreach((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                TableIdentifier dest = (TableIdentifier)tuple2._1();
                Seq flows = (Seq)tuple2._2();
                throw new AnalysisException("MATERIALIZED_VIEW_WITH_MULTIPLE_QUERIES", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)dest.unquotedString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"queries"), (Object)((IterableOnceOps)flows.map((Function1 & Serializable)x$2 -> x$2.identifier())).mkString(","))})));
            }
            throw new MatchError((Object)tuple2);
        });
        return multiQueryTables;
    }

    public static /* synthetic */ void validateFlowStreamingness$(GraphValidations $this) {
        $this.validateFlowStreamingness();
    }

    default public void validateFlowStreamingness() {
        ((DataflowGraph)this).flowsTo().foreach((Function1 & Serializable)x0$1 -> {
            GraphValidations.$anonfun$validateFlowStreamingness$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void validateGraphIsTopologicallySorted$(GraphValidations $this) {
        $this.validateGraphIsTopologicallySorted();
    }

    default public void validateGraphIsTopologicallySorted() {
        scala.collection.mutable.Set visitedNodes = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        scala.collection.mutable.Set visitedEdges = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        ((DataflowGraph)this).flows().foreach((Function1 & Serializable)f -> {
            scala.collection.immutable.Set unvisitedInputNodes = (scala.collection.immutable.Set)((ResolvedFlow)((DataflowGraph)this).resolvedFlow().apply((Object)f.identifier())).inputs().$minus$minus((IterableOnce)visitedNodes);
            Option option = unvisitedInputNodes.headOption();
            if (None$.MODULE$.equals(option)) {
                visitedEdges.add((Object)f.identifier());
                if (((IterableOnceOps)((IterableOps)((DataflowGraph)this).flowsTo().apply((Object)f.destinationIdentifier())).map((Function1 & Serializable)x$3 -> x$3.identifier())).forall((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)visitedEdges.contains((Object)elem)))) {
                    return BoxesRunTime.boxToBoolean((boolean)visitedNodes.add((Object)f.destinationIdentifier()));
                }
                return BoxedUnit.UNIT;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                TableIdentifier unvisitedInput = (TableIdentifier)some.value();
                throw new AnalysisException("PIPELINE_GRAPH_NOT_TOPOLOGICALLY_SORTED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flowName"), (Object)f.identifier().unquotedString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)unvisitedInput.unquotedString())})));
            }
            throw new MatchError((Object)option);
        });
    }

    public static /* synthetic */ void validateTablesAreResettable$(GraphValidations $this) {
        $this.validateTablesAreResettable();
    }

    default public void validateTablesAreResettable() {
        this.validateTablesAreResettable(((DataflowGraph)this).tables());
    }

    public static /* synthetic */ void validateTablesAreResettable$(GraphValidations $this, Seq tables) {
        $this.validateTablesAreResettable((Seq<Table>)tables);
    }

    default public void validateTablesAreResettable(Seq<Table> tables) {
        Map tableLookup = DataflowGraph$.MODULE$.mapUnique(tables, "table", (Function1 & Serializable)x$4 -> x$4.identifier());
        Seq nonResettableTables = (Seq)tables.filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)GraphValidations.$anonfun$validateTablesAreResettable$2(t)));
        Seq upstreamResettableTables = (Seq)((IterableOnceOps)((IterableOps)((GraphOperations)((Object)this)).upstreamDatasets((Seq<TableIdentifier>)((Seq)nonResettableTables.map((Function1 & Serializable)x$5 -> x$5.identifier()))).collect((PartialFunction)new Serializable((DataflowGraph)this, tableLookup){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ DataflowGraph $outer;
            private final Map tableLookup$1;

            public final <A1 extends Tuple2<TableIdentifier, scala.collection.immutable.Set<TableIdentifier>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    TableIdentifier upstreamDataset = (TableIdentifier)A1._1();
                    scala.collection.immutable.Set nonResettableDownstreams = (scala.collection.immutable.Set)A1._2();
                    if (this.$outer.table().contains((Object)upstreamDataset)) {
                        return (B1)((IterableOps)nonResettableDownstreams.filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)$anonfun$2.$anonfun$applyOrElse$1(this, t)))).map((Function1 & Serializable)id -> new Tuple2($this.tableLookup$1.apply((Object)upstreamDataset), (Object)((GraphElement)$this.tableLookup$1.apply(id)).displayName()));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<TableIdentifier, scala.collection.immutable.Set<TableIdentifier>> x1) {
                Tuple2<TableIdentifier, scala.collection.immutable.Set<TableIdentifier>> tuple2 = x1;
                if (tuple2 != null) {
                    TableIdentifier upstreamDataset = (TableIdentifier)tuple2._1();
                    if (this.$outer.table().contains((Object)upstreamDataset)) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$2($anonfun$2 $this, Flow f) {
                return ((ResolvedFlow)$this.$outer.resolvedFlow().apply((Object)f.identifier())).df().isStreaming();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$1($anonfun$2 $this, TableIdentifier t) {
                return ((IterableOnceOps)$this.$outer.flowsTo().apply((Object)t)).exists((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)$anonfun$2.$anonfun$applyOrElse$2($this, f)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableLookup$1 = tableLookup$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.pipelines.graph.GraphValidations$$anonfun$2 org.apache.spark.sql.catalyst.TableIdentifier ), $anonfun$applyOrElse$2$adapted(org.apache.spark.sql.pipelines.graph.GraphValidations$$anonfun$2 org.apache.spark.sql.pipelines.graph.Flow ), $anonfun$applyOrElse$3(org.apache.spark.sql.pipelines.graph.GraphValidations$$anonfun$2 org.apache.spark.sql.catalyst.TableIdentifier org.apache.spark.sql.catalyst.TableIdentifier )}, serializedLambda);
            }
        })).flatten(Predef$.MODULE$.$conforms())).toSeq().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)GraphValidations.$anonfun$validateTablesAreResettable$4(x0$1)));
        ((IterableOps)((SeqOps)upstreamResettableTables.groupBy((Function1 & Serializable)x$6 -> (String)x$6._2()).view().mapValues((Function1 & Serializable)x$7 -> (Seq)x$7.map((Function1 & Serializable)x$8 -> (Table)x$8._1())).toSeq().sortBy((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)GraphValidations.$anonfun$validateTablesAreResettable$8(x$9)), (Ordering)Ordering.Int$.MODULE$)).reverse()).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String nameForEvent = (String)tuple2._1();
                Seq tables = (Seq)tuple2._2();
                throw new AnalysisException("INVALID_RESETTABLE_DEPENDENCY", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"downstreamTable"), (Object)nameForEvent), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"upstreamResettableTables"), (Object)((IterableOnceOps)((IterableOps)((SeqOps)tables.map((Function1 & Serializable)x$10 -> x$10.displayName())).sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)t -> "'" + t + "'")).mkString(", ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resetAllowedKey"), (Object)PipelinesTableProperties$.MODULE$.resetAllowed().key())})));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static /* synthetic */ void validateUserSpecifiedSchemas$(GraphValidations $this) {
        $this.validateUserSpecifiedSchemas();
    }

    default public void validateUserSpecifiedSchemas() {
        ((IterableOnceOps)((DataflowGraph)this).flows().flatMap((Function1 & Serializable)f -> ((DataflowGraph)this).table().get((Object)f.identifier()))).foreach((Function1 & Serializable)t -> {
            GraphValidations.$anonfun$validateUserSpecifiedSchemas$2(this, t);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void validateSuccessfulFlowAnalysis$(GraphValidations $this) {
        $this.validateSuccessfulFlowAnalysis();
    }

    default public void validateSuccessfulFlowAnalysis() {
        Seq flowAnalysisFailures = (Seq)((DataflowGraph)this).resolutionFailedFlows().flatMap((Function1 & Serializable)f -> f.failure().headOption().map((Function1 & Serializable)err -> new Tuple2((Object)f.identifier(), err)));
        if (flowAnalysisFailures.nonEmpty()) {
            scala.collection.mutable.Map failedFlowsSubgraph;
            scala.collection.immutable.Set failedFlowIdentifiers = ((IterableOnceOps)flowAnalysisFailures.map((Function1 & Serializable)x$11 -> (TableIdentifier)x$11._1())).toSet();
            Tuple2 tuple2 = flowAnalysisFailures.partition(arg_0 -> GraphValidations.$anonfun$validateSuccessfulFlowAnalysis$4$adapted(this, failedFlowIdentifiers, failedFlowsSubgraph = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), arg_0));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq downstreamFailures = (Seq)tuple2._1();
            Seq directFailures = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)downstreamFailures, (Object)directFailures);
            Seq downstreamFailures2 = (Seq)tuple22._1();
            Seq directFailures2 = (Seq)tuple22._2();
            if (failedFlowsSubgraph.nonEmpty()) {
                this.detectCycle((Map<TableIdentifier, Seq<TableIdentifier>>)failedFlowsSubgraph.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).foreach((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        TableIdentifier upstream = (TableIdentifier)tuple2._1();
                        TableIdentifier downstream = (TableIdentifier)tuple2._2();
                        TableIdentifier upstreamDataset = ((Flow)((DataflowGraph)this).flow().apply((Object)upstream)).destinationIdentifier();
                        TableIdentifier downstreamDataset = ((Flow)((DataflowGraph)this).flow().apply((Object)downstream)).destinationIdentifier();
                        throw new CircularDependencyException(downstreamDataset, upstreamDataset);
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new UnresolvedPipelineException((DataflowGraph)this, (Map<TableIdentifier, Throwable>)((IterableOnceOps)directFailures2.map((Function1 & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    TableIdentifier id = (TableIdentifier)tuple2._1();
                    Throwable value = (Throwable)tuple2._2();
                    return new Tuple2((Object)id, (Object)value);
                }
                throw new MatchError((Object)tuple2);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Map<TableIdentifier, Throwable>)((IterableOnceOps)downstreamFailures2.map((Function1 & Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 != null) {
                    TableIdentifier id = (TableIdentifier)tuple2._1();
                    Throwable value = (Throwable)tuple2._2();
                    return new Tuple2((Object)id, (Object)value);
                }
                throw new MatchError((Object)tuple2);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), UnresolvedPipelineException$.MODULE$.apply$default$4());
        }
    }

    private Option<Tuple2<TableIdentifier, TableIdentifier>> detectCycle(Map<TableIdentifier, Seq<TableIdentifier>> ancestors) {
        ObjectRef cycle = ObjectRef.create((Object)None$.MODULE$);
        scala.collection.mutable.Set visited = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        ancestors.keys().foreach((Function1 & Serializable)x$15 -> {
            GraphValidations.visit$1(x$15, (List)Nil$.MODULE$, cycle, visited, ancestors);
            return BoxedUnit.UNIT;
        });
        return (Option)cycle.elem;
    }

    public static /* synthetic */ void validatePersistedViewSources$(GraphValidations $this) {
        $this.validatePersistedViewSources();
    }

    default public void validatePersistedViewSources() {
        Map<TableIdentifier, Flow> viewToFlowMap = ViewHelpers$.MODULE$.persistedViewIdentifierToFlow((DataflowGraph)this);
        ((DataflowGraph)this).persistedViews().foreach((Function1 & Serializable)persistedView -> {
            GraphValidations.$anonfun$validatePersistedViewSources$1(this, viewToFlowMap, persistedView);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ boolean $anonfun$validateMultiQueryTables$1(Tuple2 x$1) {
        return ((SeqOps)x$1._2()).size() > 1;
    }

    public static /* synthetic */ boolean $anonfun$validateMultiQueryTables$3(GraphValidations $this, Flow f) {
        return !((ResolvedFlow)((DataflowGraph)$this).resolvedFlow().apply((Object)f.identifier())).df().isStreaming();
    }

    public static /* synthetic */ boolean $anonfun$validateMultiQueryTables$2(GraphValidations $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TableIdentifier dest = (TableIdentifier)tuple2._1();
            Seq flows = (Seq)tuple2._2();
            return flows.exists((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)GraphValidations.$anonfun$validateMultiQueryTables$3($this, f))) && ((DataflowGraph)$this).table().contains((Object)dest);
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ void $anonfun$validateFlowStreamingness$3(ResolvedFlow resolvedFlow$1, TableIdentifier destTableIdentifier$1, Table destTable) {
        if (destTable.isStreamingTable()) {
            if (!resolvedFlow$1.df().isStreaming()) {
                throw new AnalysisException("INVALID_FLOW_QUERY_TYPE.BATCH_RELATION_FOR_STREAMING_TABLE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flowIdentifier"), (Object)resolvedFlow$1.identifier().quotedString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableIdentifier"), (Object)destTableIdentifier$1.quotedString())})));
            }
            return;
        }
        if (resolvedFlow$1.df().isStreaming()) {
            throw new AnalysisException("INVALID_FLOW_QUERY_TYPE.STREAMING_RELATION_FOR_MATERIALIZED_VIEW", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flowIdentifier"), (Object)resolvedFlow$1.identifier().quotedString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableIdentifier"), (Object)destTableIdentifier$1.quotedString())})));
        }
    }

    public static /* synthetic */ void $anonfun$validateFlowStreamingness$4(ResolvedFlow resolvedFlow$1, TableIdentifier destTableIdentifier$1, View x0$2) {
        View view = x0$2;
        if (view instanceof PersistedView) {
            if (resolvedFlow$1.df().isStreaming()) {
                throw new AnalysisException("INVALID_FLOW_QUERY_TYPE.STREAMING_RELATION_FOR_PERSISTED_VIEW", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flowIdentifier"), (Object)resolvedFlow$1.identifier().quotedString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewIdentifier"), (Object)destTableIdentifier$1.quotedString())})));
            }
            return;
        }
        if (view instanceof TemporaryView) {
            return;
        }
        throw new MatchError((Object)view);
    }

    public static /* synthetic */ void $anonfun$validateFlowStreamingness$2(Option destTableOpt$1, TableIdentifier destTableIdentifier$1, Option destViewOpt$1, ResolvedFlow resolvedFlow) {
        if (resolvedFlow.once()) {
            if (resolvedFlow.df().isStreaming()) {
                throw new AnalysisException("INVALID_FLOW_QUERY_TYPE.STREAMING_RELATION_FOR_ONCE_FLOW", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flowIdentifier"), (Object)resolvedFlow.identifier().quotedString())})));
            }
            return;
        }
        destTableOpt$1.foreach((Function1 & Serializable)destTable -> {
            GraphValidations.$anonfun$validateFlowStreamingness$3(resolvedFlow, destTableIdentifier$1, destTable);
            return BoxedUnit.UNIT;
        });
        destViewOpt$1.foreach((Function1 & Serializable)x0$2 -> {
            GraphValidations.$anonfun$validateFlowStreamingness$4(resolvedFlow, destTableIdentifier$1, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void $anonfun$validateFlowStreamingness$1(GraphValidations $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TableIdentifier destTableIdentifier = (TableIdentifier)tuple2._1();
            Seq flowsToDataset = (Seq)tuple2._2();
            Option destTableOpt = ((DataflowGraph)$this).table().get((Object)destTableIdentifier);
            Option destViewOpt = ((DataflowGraph)$this).view().get((Object)destTableIdentifier);
            Seq resolvedFlowsToDataset = (Seq)flowsToDataset.collect((PartialFunction)new Serializable((DataflowGraph)$this){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Flow, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof ResolvedFlow) {
                        ResolvedFlow resolvedFlow = (ResolvedFlow)A1;
                        return (B1)resolvedFlow;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Flow x1) {
                    Flow flow = x1;
                    return flow instanceof ResolvedFlow;
                }
            });
            resolvedFlowsToDataset.foreach((Function1 & Serializable)resolvedFlow -> {
                GraphValidations.$anonfun$validateFlowStreamingness$2(destTableOpt, destTableIdentifier, destViewOpt, resolvedFlow);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ boolean $anonfun$validateTablesAreResettable$2(Table t) {
        return !BoxesRunTime.unboxToBoolean((Object)PipelinesTableProperties$.MODULE$.resetAllowed().fromMap(t.properties()));
    }

    public static /* synthetic */ boolean $anonfun$validateTablesAreResettable$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Table t = (Table)tuple2._1();
            return BoxesRunTime.unboxToBoolean((Object)PipelinesTableProperties$.MODULE$.resetAllowed().fromMap(t.properties()));
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ int $anonfun$validateTablesAreResettable$8(Tuple2 x$9) {
        return ((SeqOps)x$9._2()).size();
    }

    public static /* synthetic */ void $anonfun$validateUserSpecifiedSchemas$4(GraphValidations $this, StructType inferredSchema$1, TableInput t$1, StructType ss) {
        StructType structType = inferredSchema$1;
        StructType structType2 = ss;
        if (structType == null ? structType2 != null : !structType.equals(structType2)) {
            DatasetType datasetType = GraphElementTypeUtils$.MODULE$.getDatasetTypeForMaterializedViewOrStreamingTable((Seq<ResolvedFlow>)((Seq)((IterableOps)((DataflowGraph)$this).flowsTo().apply((Object)t$1.identifier())).map((Function1 & Serializable)f -> (ResolvedFlow)((DataflowGraph)$this).resolvedFlow().apply((Object)f.identifier()))));
            throw GraphErrors$.MODULE$.incompatibleUserSpecifiedAndInferredSchemasError(t$1.identifier(), datasetType, ss, inferredSchema$1, GraphErrors$.MODULE$.incompatibleUserSpecifiedAndInferredSchemasError$default$5());
        }
    }

    public static /* synthetic */ void $anonfun$validateUserSpecifiedSchemas$2(GraphValidations $this, TableInput t) {
        StructType inferredSchema = SchemaInferenceUtils$.MODULE$.inferSchemaFromFlows((Seq<ResolvedFlow>)((Seq)((IterableOps)((DataflowGraph)$this).flowsTo().apply((Object)t.identifier())).map((Function1 & Serializable)f -> (ResolvedFlow)((DataflowGraph)$this).resolvedFlow().apply((Object)f.identifier()))), t.specifiedSchema());
        t.specifiedSchema().foreach((Function1 & Serializable)ss -> {
            GraphValidations.$anonfun$validateUserSpecifiedSchemas$4($this, inferredSchema, t, ss);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ boolean $anonfun$validateSuccessfulFlowAnalysis$4(GraphValidations $this, scala.collection.immutable.Set failedFlowIdentifiers$1, scala.collection.mutable.Map failedFlowsSubgraph$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TableIdentifier flowIdentifier = (TableIdentifier)tuple2._1();
            Seq failedFlowsWritingToRequestedDatasets = ((SetOps)((IterableOps)((ResolutionFailedFlow)((DataflowGraph)$this).resolutionFailedFlow().apply((Object)flowIdentifier)).funcResult().requestedInputs().flatMap((Function1 & Serializable)d -> (Seq)((DataflowGraph)$this).flowsTo().getOrElse(d, (Function0 & Serializable)() -> (Seq)Nil$.MODULE$))).map((Function1 & Serializable)x$12 -> x$12.identifier())).intersect((Set)failedFlowIdentifiers$1).toSeq();
            failedFlowsSubgraph$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)flowIdentifier), (Object)failedFlowsWritingToRequestedDatasets));
            return failedFlowsWritingToRequestedDatasets.nonEmpty();
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ void $anonfun$detectCycle$1(TableIdentifier f$2, List currentPath$1, ObjectRef cycle$1, scala.collection.mutable.Set visited$1, Map ancestors$1, TableIdentifier x$14) {
        TableIdentifier tableIdentifier = f$2;
        GraphValidations.visit$1(x$14, currentPath$1.$colon$colon((Object)tableIdentifier), cycle$1, visited$1, ancestors$1);
    }

    private static void visit$1(TableIdentifier f, List currentPath, ObjectRef cycle$1, scala.collection.mutable.Set visited$1, Map ancestors$1) {
        if (((Option)cycle$1.elem).isEmpty() && !visited$1.contains((Object)f)) {
            if (currentPath.contains((Object)f)) {
                cycle$1.elem = Option$.MODULE$.apply((Object)new Tuple2(currentPath.head(), (Object)f));
                return;
            }
            ((IterableOnceOps)ancestors$1.apply((Object)f)).foreach((Function1 & Serializable)x$14 -> {
                GraphValidations.$anonfun$detectCycle$1(f, currentPath, cycle$1, visited$1, ancestors$1, x$14);
                return BoxedUnit.UNIT;
            });
            visited$1.$plus$eq((Object)f);
            return;
        }
    }

    public static /* synthetic */ void $anonfun$validatePersistedViewSources$4(PersistedView persistedView$1, View x0$1) {
        View view = x0$1;
        if (view instanceof TemporaryView) {
            TemporaryView temporaryView = (TemporaryView)view;
            throw new AnalysisException("INVALID_TEMP_OBJ_REFERENCE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"persistedViewName"), (Object)persistedView$1.identifier().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"temporaryViewName"), (Object)temporaryView.identifier().toString())})), null);
        }
    }

    public static /* synthetic */ void $anonfun$validatePersistedViewSources$1(GraphValidations $this, Map viewToFlowMap$1, PersistedView persistedView) {
        Flow flow = (Flow)viewToFlowMap$1.apply((Object)persistedView.identifier());
        FlowFunctionResult funcResult = ((ResolutionCompletedFlow)((DataflowGraph)$this).resolvedFlow().apply((Object)flow.identifier())).funcResult();
        scala.collection.immutable.Set inputIdentifiers = (scala.collection.immutable.Set)funcResult.batchInputs().$plus$plus(funcResult.streamingInputs()).map((Function1 & Serializable)x$16 -> x$16.input().identifier());
        ((IterableOnceOps)inputIdentifiers.flatMap((Function1 & Serializable)key -> ((DataflowGraph)$this).view().get(key))).foreach((Function1 & Serializable)x0$1 -> {
            GraphValidations.$anonfun$validatePersistedViewSources$4(persistedView, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static void $init$(GraphValidations $this) {
    }

    public static /* synthetic */ Object $anonfun$validateSuccessfulFlowAnalysis$4$adapted(GraphValidations $this, scala.collection.immutable.Set failedFlowIdentifiers$1, scala.collection.mutable.Map failedFlowsSubgraph$1, Tuple2 x0$1) {
        return BoxesRunTime.boxToBoolean((boolean)GraphValidations.$anonfun$validateSuccessfulFlowAnalysis$4($this, failedFlowIdentifiers$1, failedFlowsSubgraph$1, x0$1));
    }
}

